/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.web;

import com.honeywell.sbc.BSbcDevice;
import com.honeywell.sbc.BSbcNetwork;
import com.honeywell.sbc.message.SbcRequestMessage;
import com.honeywell.sbc.message.SbcResponseMessage;
import com.honeywell.sbc.message.commands.WebTelegramRequest;
import com.honeywell.sbc.message.commands.WebTelegramRequestData;
import com.honeywell.sbc.util.SbcUtil;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;

public class SbcWebRequest {
    private static final int TIME_OUT = 1000;
    private static final int DATA_STATUS_INDEX = 10;
    private static final int SLEEP = 1000;
    private static final int DATA_START_INDEX = 12;
    private static final int EXCLUDE_LAST_BYTES = 2;
    public static final String TRANSFER_ENCODING_CHUNKED = "Transfer-Encoding: chunked";

    public void sendWebRequest(String data, BSbcDevice sbcDevice) throws Exception {
        int nextSeqNo = sbcDevice.getSbcIpDriverNetwork().getSequenceNumber();
        SbcRequestMessage writeRequest = new SbcRequestMessage(sbcDevice.getStationId(), nextSeqNo);
        WebTelegramRequest writeData = new WebTelegramRequest(data);
        writeRequest.appendPayload(writeData.getPayload());
        writeRequest.setAddress((BAddress)sbcDevice.getIpAddress());
        writeRequest.setResponseTimeOut(1000);
        BSbcNetwork sbcNetwork = sbcDevice.getSbcNetwork();
        ((NComm)sbcNetwork.getUdpConfig().getComm()).sendRequest((NMessage)writeRequest);
    }

    public String getResponseString(BSbcDevice sbcDevice) throws Exception {
        byte dataStatus;
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        int nextSeqNo = sbcDevice.getSbcIpDriverNetwork().getSequenceNumber();
        SbcRequestMessage writeRequest = new SbcRequestMessage(sbcDevice.getStationId(), nextSeqNo);
        WebTelegramRequestData requestData = new WebTelegramRequestData();
        writeRequest.setAddress((BAddress)sbcDevice.getIpAddress());
        do {
            writeRequest.appendPayload(requestData.getPayload());
            writeRequest.setResponseTimeOut(1000);
            SbcResponseMessage msg = (SbcResponseMessage)((NComm)((BSbcNetwork)sbcDevice.getNetwork()).getUdpConfig().comm()).sendRequest((NMessage)writeRequest);
            byte[] trimmedRespMsg = msg.getResponsePayload();
            dataStatus = trimmedRespMsg[10];
            if (dataStatus == 20 || dataStatus == 19) {
                int seqNum = requestData.getReadSeqNum();
                int readSeqNum = seqNum - 1;
                requestData.setReadSeqNum(readSeqNum);
                Thread.sleep(1000L);
                continue;
            }
            byte[] rangeCopied = Arrays.copyOfRange(trimmedRespMsg, 12, trimmedRespMsg.length - 2);
            for (int i = 0; i < rangeCopied.length; ++i) {
                bytes.add(rangeCopied[i]);
            }
        } while (dataStatus != 18);
        byte[] byteBuffer = new byte[bytes.size()];
        for (int i = 0; i < bytes.size(); ++i) {
            byteBuffer[i] = (Byte)bytes.get(i);
        }
        return new String(byteBuffer);
    }

    public String[] getDataArrayFromResponse(String response) {
        String[] str = response.split("\n");
        boolean isChunkedData = this.getIsChunkedData(str);
        int index = this.getDataIndex(str);
        return this.getDataOnEncodingType(Arrays.copyOfRange(str, index, str.length), isChunkedData);
    }

    private String[] getDataOnEncodingType(String[] arrStrings, boolean isChunkedData) {
        SbcUtil.log_driver.log(Level.FINEST, "Chunked data: " + isChunkedData);
        if (isChunkedData) {
            boolean flag = false;
            int length = 0;
            StringBuilder builder = new StringBuilder();
            int totalLength = 0;
            for (String data : arrStrings) {
                if (!flag) {
                    length = Integer.parseInt(data.trim(), 16);
                    length += 2;
                    flag = true;
                    continue;
                }
                int tempLength = data.getBytes().length + 1;
                if ((totalLength += tempLength) < length) {
                    builder.append(data);
                    builder.append("\n");
                    continue;
                }
                if (totalLength != length) continue;
                builder.append(data.trim());
                flag = false;
                totalLength = 0;
                length = 0;
            }
            return builder.toString().split("\n");
        }
        return arrStrings;
    }

    private boolean getIsChunkedData(String[] str) {
        for (int i = 0; i < str.length; ++i) {
            String data = str[i].trim();
            if (!"".equals(data)) {
                if (!data.startsWith(TRANSFER_ENCODING_CHUNKED)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private int getDataIndex(String[] str) {
        int index = -1;
        for (int i = 0; i < str.length; ++i) {
            if (!"".equals(str[i].trim())) continue;
            index = i + 1;
            break;
        }
        return index;
    }

    public void authenticateHttpConnection(BSbcDevice sbcDevice) throws Exception {
        String pwd = SbcUtil.getPassword(sbcDevice.getHttpPassword());
        if (null != pwd && !"".equals(pwd)) {
            String data = "POST /login.cgi HTTP/1.1\r\nHost: localhost\r\nContent-Length: " + pwd.length() + "\r\nUser-Agent: Saia.Net/2.1\r\nContent-Type: application/x-www-form-urlencoded\r\n\r\npwd=" + pwd;
            this.sendWebRequest(data, sbcDevice);
            this.getResponseString(sbcDevice);
        } else {
            SbcUtil.log_driver.log(Level.INFO, "HTTP authentication not required");
        }
    }
}

