/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.util;

import java.util.HashMap;
import java.util.Map;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.DstRule;

public class TimeZoneMapper {
    private static Map<String, String> TIME_ZONES = null;

    public static final BTimeZone getTimeZone(String input) {
        String output;
        if (TIME_ZONES == null) {
            TIME_ZONES = new HashMap<String, String>();
            TimeZoneMapper.loadTimeZones();
        }
        if ((output = TIME_ZONES.get(input)) == null) {
            return TimeZoneMapper.lookForCustomTimeZone(input);
        }
        return BTimeZone.getTimeZone((String)output);
    }

    private static BTimeZone lookForCustomTimeZone(String input) {
        BTimeZone outputTimeZone = BTimeZone.getLocal();
        if (input == null || "".equals(input.trim())) {
            return outputTimeZone;
        }
        String[] timeZoneEle = input.split(",");
        if (timeZoneEle.length > 1) {
            BTimeZone reqTimeZone;
            String timeZoneOffset = timeZoneEle[0].substring(TimeZoneMapper.checkForChar(timeZoneEle[0]));
            String dayLightTimeZoneOffset = timeZoneEle[1].substring(TimeZoneMapper.checkForChar(timeZoneEle[1]));
            int timeZoneOffsetMilli = TimeZoneMapper.convertToMills(timeZoneOffset);
            int dayLightAdj = TimeZoneMapper.convertToMills(dayLightTimeZoneOffset) - timeZoneOffsetMilli;
            String startRule = timeZoneEle[2];
            String endRule = timeZoneEle[3];
            outputTimeZone = reqTimeZone = BTimeZone.make((String)TimeZoneMapper.getCustomTimeZoneId(input), (int)timeZoneOffsetMilli, (int)dayLightAdj, (DstRule)DstRule.makeWeekday((BTime)BTime.make((int)Integer.parseInt(startRule.substring(startRule.indexOf("/") + 1)), (int)0, (int)0), (int)Integer.parseInt(startRule.substring(startRule.indexOf(".") + 1, startRule.lastIndexOf("."))), (BWeekday)BWeekday.make((int)Integer.parseInt(startRule.substring(startRule.lastIndexOf(".") + 1, startRule.indexOf("/")))), (BMonth)BMonth.make((int)(Integer.parseInt(startRule.substring(1, startRule.indexOf("."))) - 1))), (DstRule)DstRule.makeWeekday((BTime)BTime.make((int)Integer.parseInt(endRule.substring(endRule.indexOf("/") + 1)), (int)0, (int)0), (int)Integer.parseInt(endRule.substring(endRule.indexOf(".") + 1, endRule.lastIndexOf("."))), (BWeekday)BWeekday.make((int)Integer.parseInt(endRule.substring(endRule.lastIndexOf(".") + 1, endRule.indexOf("/")))), (BMonth)BMonth.make((int)(Integer.parseInt(endRule.substring(1, endRule.indexOf("."))) - 1))));
        } else if (timeZoneEle.length == 1 && (timeZoneEle[0].contains("+") || timeZoneEle[0].contains("-"))) {
            BTimeZone reqTimeZone;
            String timeZoneOffset = timeZoneEle[0].substring(TimeZoneMapper.checkForChar(timeZoneEle[0]));
            int timeZoneOffsetMilli = TimeZoneMapper.convertToMills(timeZoneOffset);
            outputTimeZone = reqTimeZone = BTimeZone.make((String)TimeZoneMapper.getCustomTimeZoneId(input), (int)timeZoneOffsetMilli);
        }
        return outputTimeZone;
    }

    private static String getCustomTimeZoneId(String input) {
        return "Custom".concat(" ").concat(input);
    }

    private static int checkForChar(String s) {
        if (s.contains("+")) {
            return s.indexOf("+");
        }
        return s.indexOf("-");
    }

    private static int convertToMills(String offset) {
        String[] minutesEle = offset.split(":");
        if (minutesEle.length > 1) {
            return (int)BRelTime.make((int)0, (int)Integer.parseInt(minutesEle[0]), (int)Integer.parseInt(TimeZoneMapper.getSign(offset).concat(minutesEle[1])), (int)0).getMillis();
        }
        return (int)BRelTime.makeHours((int)Integer.parseInt(minutesEle[0])).getMillis();
    }

    private static String getSign(String s) {
        if (s.contains("+")) {
            return "+";
        }
        return "-";
    }

    private static void loadTimeZones() {
        TIME_ZONES.put("UTC+00", "UTC");
        TIME_ZONES.put("EET+02,EEST+03,M3.5.0/2,M10.5.0/2", "Europe/Mariehamn");
        TIME_ZONES.put("AFT+04:30", "Asia/Kabul");
        TIME_ZONES.put("CET+01,CEST+02,M3.5.0/2,M10.5.0/2", "Europe/Tirane");
        TIME_ZONES.put("CET+01", "Africa/Algiers");
        TIME_ZONES.put("WAT+01", "Africa/Luanda");
        TIME_ZONES.put("AST-04", "America/Anguilla");
        TIME_ZONES.put("DAVT+07", "Antarctica/Davis");
        TIME_ZONES.put("DDUT+10", "Antarctica/DumontDUrville");
        TIME_ZONES.put("MIST+11", "Antarctica/Macquarie");
        TIME_ZONES.put("MAWT+05", "Antarctica/Mawson");
        TIME_ZONES.put("ROTT-03", "Antarctica/Rothera");
        TIME_ZONES.put("SYOT+03", "Antarctica/Syowa");
        TIME_ZONES.put("VOST+06", "Antarctica/Vostok");
        TIME_ZONES.put("ART-03", "America/Argentina/Buenos_Aires");
        TIME_ZONES.put("WARST-03", "America/Argentina/San_Luis");
        TIME_ZONES.put("AMT+04,AMST+05,M3.5.0/3,M10.5.0/3", "Asia/Yerevan");
        TIME_ZONES.put("CST+09:30,CST+10:30,M10.1.0/3,M4.1.0/3", "Australia/Adelaide");
        TIME_ZONES.put("EST+10", "Australia/Brisbane");
        TIME_ZONES.put("EST+10,EST+11,M10.1.0/3,M4.1.0/3", "Australia/Sydney");
        TIME_ZONES.put("CST+09:30", "Australia/Darwin");
        TIME_ZONES.put("CWST+08:45", "Australia/Eucla");
        TIME_ZONES.put("LHST+10:30,LHST+11,M10.1.0/2,M4.1.0/2", "Australia/Lord_Howe");
        TIME_ZONES.put("WST+08", "Australia/Perth");
        TIME_ZONES.put("AZT+04,AZST+05,M3.5.0/6,M10.5.0/6", "Asia/Baku");
        TIME_ZONES.put("EST-05,EDT-04,M3.2.0/3,M11.1.0/3", "America/Nassau");
        TIME_ZONES.put("AST+03", "Asia/Bahrain");
        TIME_ZONES.put("BDT+06", "Asia/Dhaka");
        TIME_ZONES.put("EET+02,EEST+03,M3.5.0/3,M10.5.0/3", "Europe/Minsk");
        TIME_ZONES.put("CST-06", "America/Belize");
        TIME_ZONES.put("BTT+06", "Asia/Thimphu");
        TIME_ZONES.put("BOT-04", "America/La_Paz");
        TIME_ZONES.put("CAT+02", "Africa/Gaborone");
        TIME_ZONES.put("BRT-03", "America/Belem");
        TIME_ZONES.put("AMT-04", "America/Porto_Velho");
        TIME_ZONES.put("AMT-04,AMST-03,M10.3.0/1,M2.3.0/1", "America/Campo_Grande");
        TIME_ZONES.put("FNT-02", "America/Noronha");
        TIME_ZONES.put("BRT-03,BRST-02,M10.3.0/1,M2.3.0/1", "America/Sao_Paulo");
        TIME_ZONES.put("GMT+00,GMT+01,M3.5.0/2,M10.5.0/2", "Europe/London");
        TIME_ZONES.put("IOT+06", "Indian/Chagos");
        TIME_ZONES.put("BNT+08", "Asia/Brunei");
        TIME_ZONES.put("GMT+00", "Africa/Ouagadougou");
        TIME_ZONES.put("ICT+07", "Asia/Phnom_Penh");
        TIME_ZONES.put("EST-05", "America/Atikokan");
        TIME_ZONES.put("MST-07,MDT-06,M3.2.0/3,M11.1.0/3", "America/Edmonton");
        TIME_ZONES.put("PST-08,PDT-07,M3.2.0/3,M11.1.0/3", "America/Vancouver");
        TIME_ZONES.put("MST-07", "America/Dawson_Creek");
        TIME_ZONES.put("AST-04,ADT-03,M3.2.0/3,M11.1.0/3", "America/Halifax");
        TIME_ZONES.put("AST-04,ADT-03,M3.2.0/1,M11.1.0/1", "America/Goose_Bay");
        TIME_ZONES.put("CST-06,CDT-05,M3.2.0/3,M11.1.0/3", "America/Rankin_Inlet");
        TIME_ZONES.put("CDT-05,EST-05,M11.1.0/2,M3.2.0/2", "America/Resolute");
        TIME_ZONES.put("NST-03:30,NDT-02:30,M3.2.0/1,M11.1.0/1", "America/St_Johns");
        TIME_ZONES.put("CVT-01", "Atlantic/Cape_Verde");
        TIME_ZONES.put("EAST-06,EASST-05,M10.2.0/4,M3.2.0/4", "Pacific/Easter");
        TIME_ZONES.put("CLT-04,CLST-03,M10.2.0/4,M3.2.0/4", "America/Santiago");
        TIME_ZONES.put("CST+08", "Asia/Chongqing");
        TIME_ZONES.put("CXT+07", "Indian/Christmas");
        TIME_ZONES.put("CCT+06:30", "Indian/Cocos");
        TIME_ZONES.put("COT-05", "America/Bogota");
        TIME_ZONES.put("EAT+03", "Indian/Comoro");
        TIME_ZONES.put("CKT-10", "Pacific/Rarotonga");
        TIME_ZONES.put("CST-05,CDT-04,M3.2.0/1,M10.5.0/1", "America/Havana");
        TIME_ZONES.put("TLT+09", "Asia/Dili");
        TIME_ZONES.put("GALT-06", "Pacific/Galapagos");
        TIME_ZONES.put("ECT-05", "America/Guayaquil");
        TIME_ZONES.put("EET+02", "Africa/Cairo");
        TIME_ZONES.put("FKT-04,FKST-03,M9.1.0/3,M4.3.0/3", "Atlantic/Stanley");
        TIME_ZONES.put("WET+00,WEST+01,M3.5.0/2,M10.5.0/2", "Atlantic/Faroe");
        TIME_ZONES.put("FJT+12", "Pacific/Fiji");
        TIME_ZONES.put("GFT-03", "America/Cayenne");
        TIME_ZONES.put("GAMT-09", "Pacific/Gambier");
        TIME_ZONES.put("MART-09:30", "Pacific/Marquesas");
        TIME_ZONES.put("TAHT-10", "Pacific/Tahiti");
        TIME_ZONES.put("TFT+05", "Indian/Kerguelen");
        TIME_ZONES.put("GET+04", "Asia/Tbilisi");
        TIME_ZONES.put("WGT-03,WGST-02,M3.5.0/2,M10.5.0/2", "America/Godthab");
        TIME_ZONES.put("EGT-01,EGST+00,M3.5.0/2,M10.5.0/2", "America/Scoresbysund");
        TIME_ZONES.put("GYT-04", "America/Guyana");
        TIME_ZONES.put("HKT+08", "Asia/Hong_Kong");
        TIME_ZONES.put("IST+05:30", "Asia/Calcutta");
        TIME_ZONES.put("WIT+07", "Asia/Jakarta");
        TIME_ZONES.put("EIT+09", "Asia/Jayapura");
        TIME_ZONES.put("CIT+08", "Asia/Makassar");
        TIME_ZONES.put("IRST+03:30,IRDT+04:30,M3.3.0/1,M9.3.0/1", "Asia/Tehran");
        TIME_ZONES.put("IST+02,IDT+03,M3.3.0/3,M9.3.0/3", "Asia/Jerusalem");
        TIME_ZONES.put("JST+09", "Asia/Tokyo");
        TIME_ZONES.put("EET+02,EEST+03,M3.5.4/1,M10.5.5/1", "Asia/Amman");
        TIME_ZONES.put("ALMT+06", "Asia/Almaty");
        TIME_ZONES.put("AQTT+05", "Asia/Aqtobe");
        TIME_ZONES.put("ORAT+05", "Asia/Oral");
        TIME_ZONES.put("QYZT+06", "Asia/Qyzylorda");
        TIME_ZONES.put("PHOT+13", "Pacific/Enderbury");
        TIME_ZONES.put("LINT+14", "Pacific/Kiritimati");
        TIME_ZONES.put("GILT+12", "Pacific/Tarawa");
        TIME_ZONES.put("KST+09", "Asia/Pyongyang");
        TIME_ZONES.put("KGT+06", "Asia/Bishkek");
        TIME_ZONES.put("EET+02,EEST+03,M3.5.0/1,M10.5.0/1", "Asia/Beirut");
        TIME_ZONES.put("SAST+02", "Africa/Maseru");
        TIME_ZONES.put("MYT+08", "Asia/Kuala_Lumpur");
        TIME_ZONES.put("MVT+05", "Indian/Maldives");
        TIME_ZONES.put("MHT+12", "Pacific/Kwajalein");
        TIME_ZONES.put("MUT+04", "Indian/Mauritius");
        TIME_ZONES.put("CST-06,CDT-05,M4.1.0/3,M10.5.0/3", "America/Mexico_City");
        TIME_ZONES.put("MST-07,MDT-06,M4.1.0/3,M10.5.0/3", "America/Mazatlan");
        TIME_ZONES.put("PST-08,PDT-07,M4.1.0/3,M10.5.0/3", "America/Santa_Isabel");
        TIME_ZONES.put("CHUT+10", "Pacific/Chuuk");
        TIME_ZONES.put("KOST+11", "Pacific/Kosrae");
        TIME_ZONES.put("PONT+11", "Pacific/Pohnpei");
        TIME_ZONES.put("CHOT+08", "Asia/Choibalsan");
        TIME_ZONES.put("HOVT+07", "Asia/Hovd");
        TIME_ZONES.put("ULAT+08", "Asia/Ulaanbaatar");
        TIME_ZONES.put("WET+00", "Africa/Casablanca");
        TIME_ZONES.put("MMT+06:30", "Asia/Rangoon");
        TIME_ZONES.put("WAT+01,WAST+02,M9.1.0/3,M4.1.0/3", "Africa/Windhoek");
        TIME_ZONES.put("NRT+12", "Pacific/Nauru");
        TIME_ZONES.put("NPT+05:45", "Asia/Kathmandu");
        TIME_ZONES.put("NCT+11", "Pacific/Noumea");
        TIME_ZONES.put("NZST+12,NZDT+13,M9.5.0/3,M4.1.0/3", "Pacific/Auckland");
        TIME_ZONES.put("CHAST+12:45,CHADT+13:45,M9.5.0/3,M4.1.0/3", "Pacific/Chatham");
        TIME_ZONES.put("NUT-11", "Pacific/Niue");
        TIME_ZONES.put("NFT+11:30", "Pacific/Norfolk");
        TIME_ZONES.put("ChST+10", "Pacific/Saipan");
        TIME_ZONES.put("GST+04", "Asia/Muscat");
        TIME_ZONES.put("PKT+05", "Asia/Karachi");
        TIME_ZONES.put("PWT+09", "Pacific/Palau");
        TIME_ZONES.put("EET+02,EEST+03,M3.5.6/3,M9.1.5/3", "Asia/Gaza");
        TIME_ZONES.put("PGT+10", "Pacific/Port_Moresby");
        TIME_ZONES.put("PYT-04,PYST-03,M10.1.0/1,M4.2.0/1", "America/Asuncion");
        TIME_ZONES.put("PET-05", "America/Lima");
        TIME_ZONES.put("PHT+08", "Asia/Manila");
        TIME_ZONES.put("PST-08", "Pacific/Pitcairn");
        TIME_ZONES.put("AZOT-01,AZOST+00,M3.5.0/2,M10.5.0/2", "Atlantic/Azores");
        TIME_ZONES.put("RET+04", "Indian/Reunion");
        TIME_ZONES.put("ANAT+12", "Asia/Anadyr");
        TIME_ZONES.put("IRKT+09", "Asia/Irkutsk");
        TIME_ZONES.put("EET+03", "Europe/Kaliningrad");
        TIME_ZONES.put("PETT+12", "Asia/Kamchatka");
        TIME_ZONES.put("KRAT+08", "Asia/Krasnoyarsk");
        TIME_ZONES.put("MAGT+12", "Asia/Magadan");
        TIME_ZONES.put("MSK+04", "Europe/Moscow");
        TIME_ZONES.put("NOVT+07", "Asia/Novosibirsk");
        TIME_ZONES.put("OMST+07", "Asia/Omsk");
        TIME_ZONES.put("SAKT+11", "Asia/Sakhalin");
        TIME_ZONES.put("SAMT+04", "Europe/Samara");
        TIME_ZONES.put("VLAT+11", "Asia/Vladivostok");
        TIME_ZONES.put("VOLT+04", "Europe/Volgograd");
        TIME_ZONES.put("YAKT+10", "Asia/Yakutsk");
        TIME_ZONES.put("YEKT+06", "Asia/Yekaterinburg");
        TIME_ZONES.put("SST-11", "Pacific/Pago_Pago");
        TIME_ZONES.put("WST-11", "Pacific/Apia");
        TIME_ZONES.put("SCT+04", "Indian/Mahe");
        TIME_ZONES.put("SGT+08", "Asia/Singapore");
        TIME_ZONES.put("SBT+11", "Pacific/Guadalcanal");
        TIME_ZONES.put("GST-02", "Atlantic/South_Georgia");
        TIME_ZONES.put("PMST-03,PMDT-02,M3.2.0/3,M11.1.0/3", "America/Miquelon");
        TIME_ZONES.put("SRT-03", "America/Paramaribo");
        TIME_ZONES.put("EET+02,EEST+03,M4.1.5/1,M10.5.5/1", "Asia/Damascus");
        TIME_ZONES.put("TJT+05", "Asia/Dushanbe");
        TIME_ZONES.put("TKT-10", "Pacific/Fakaofo");
        TIME_ZONES.put("TOT+13", "Pacific/Tongatapu");
        TIME_ZONES.put("TMT+05", "Asia/Ashgabat");
        TIME_ZONES.put("TVT+12", "Pacific/Funafuti");
        TIME_ZONES.put("HAST-10,HADT-09,M3.2.0/3,M11.1.0/3", "America/Adak");
        TIME_ZONES.put("AKST-09,AKDT-08,M3.2.0/3,M11.1.0/3", "America/Anchorage");
        TIME_ZONES.put("HST-10", "Pacific/Honolulu");
        TIME_ZONES.put("MeST-08,MeST-07,M3.2.0/3,M11.1.0/3", "America/Metlakatla");
        TIME_ZONES.put("UYT-03,UYST-02,M10.1.0/3,M3.2.0/3", "America/Montevideo");
        TIME_ZONES.put("WAKT+12", "Pacific/Wake");
        TIME_ZONES.put("UZT+05", "Asia/Tashkent");
        TIME_ZONES.put("VUT+11", "Pacific/Efate");
        TIME_ZONES.put("VET-04:30", "America/Caracas");
        TIME_ZONES.put("WFT+12", "Pacific/Wallis");
    }
}

