/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.util;

import com.honeywell.sbc.BSbcDevice;
import com.honeywell.sbc.bean.BSbcDbBean;
import com.honeywell.sbc.enums.BSbcMediaTypeEnum;
import com.honeywell.sbc.enums.BSbcRegisterTypeEnum;
import com.honeywell.sbc.exception.SbcAlarmHandlingException;
import com.honeywell.sbc.message.SbcRequestMessage;
import com.honeywell.sbc.message.SbcResponseMessage;
import com.honeywell.sbc.message.commands.ReadDBSize;
import com.honeywell.sbc.point.BSbcDb;
import com.honeywell.sbc.point.BSbcDbRam;
import com.honeywell.sbc.point.BSbcProxyExt;
import com.honeywell.sbc.util.SbcByteConverter;
import com.honeywell.sbc.util.SbcConstants;
import com.honeywell.sbc.web.SbcWebRequest;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

public class SbcUtil {
    public static final Logger log_driver = Logger.getLogger("SbcIpDriver");
    public static final Logger sequenceTracker = Logger.getLogger("SbcIpDriver.SequenceTracker");
    public static final Logger sbcPointPoll = Logger.getLogger("SbcIpDriver.PointRead");
    public static final Logger sbcPointWrite = Logger.getLogger("SbcIpDriver.PointWrite");
    public static final Logger sbcPointDump = Logger.getLogger("SbcIpDriver.PointDump");
    public static final Logger sbcAlarmPoll = Logger.getLogger("SbcIpDriver.AlarmPoll");
    private static int sequenceNumber = -1;
    public static final Lexicon lexicon = Lexicon.make(SbcUtil.class);
    private static BAlarmService alarmService;

    private SbcUtil() {
    }

    public static BAlarmService getAlarmService() {
        if (alarmService == null) {
            alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        return alarmService;
    }

    public static int getSequenceNumber() {
        if (sequenceNumber == 65535) {
            sequenceNumber = -1;
        }
        return ++sequenceNumber;
    }

    public static int byteArrayToInt(byte[] b) {
        if (b.length == 4) {
            return b[0] << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
        }
        if (b.length == 2) {
            return 0 | (b[0] & 0xFF) << 8 | b[1] & 0xFF;
        }
        return -1;
    }

    public static byte[] trim(byte[] bytes) {
        int dataLen = 0;
        if (bytes.length > 4) {
            byte[] dataLength = new byte[]{bytes[0], bytes[1], bytes[2], bytes[3]};
            dataLen = SbcUtil.byteArrayToInt(dataLength);
        }
        return Arrays.copyOf(bytes, dataLen);
    }

    public static boolean isValidPositiveInteger(double value) {
        if (Math.abs(value % 1.0) == 0.0) {
            if (log_driver.isLoggable(Level.INFO)) {
                log_driver.log(Level.INFO, "**** isValidPositiveInteger value ::" + value + " is whole number");
            }
            return SbcUtil.isUnSignedInput((int)value);
        }
        return false;
    }

    private static boolean isUnSignedInput(int input) {
        if (input < 0 || Integer.toUnsignedLong(input) > 0xFFFFFFFFL) {
            if (log_driver.isLoggable(Level.INFO)) {
                log_driver.log(Level.INFO, "**** isUnSignedInput value is not unsigned::" + input);
            }
            return false;
        }
        return true;
    }

    public static void addDbElements(List<Integer> dbElemIndexList, BComponent bComponent) throws Exception {
        String memAddress = "";
        BSbcMediaTypeEnum sbcMediaType = null;
        try {
            if (bComponent instanceof BSbcDb) {
                memAddress = ((BSbcDb)bComponent).getBlockDetails().getMemoryAddress();
                sbcMediaType = BSbcMediaTypeEnum.db;
            } else if (bComponent instanceof BSbcDbRam) {
                memAddress = ((BSbcDbRam)bComponent).getBlockDetails().getMemoryAddress();
                sbcMediaType = BSbcMediaTypeEnum.dbRam;
            } else {
                throw new Exception("Unsupported Component Type was encountered while adding DB Elements");
            }
            for (int dbElemIndex : dbElemIndexList) {
                String dbElemName = "Element" + dbElemIndex;
                if (SbcUtil.isChildAlreadyExists(dbElemName, bComponent)) continue;
                Object dbElem = bComponent instanceof BSbcDb ? new BNumericPoint() : new BNumericWritable();
                dbElem.add("mediaType", (BValue)sbcMediaType, 1);
                dbElem.add("comments", (BValue)BString.make((String)""));
                dbElem.add("dbElement", (BValue)BString.make((String)Integer.toString(dbElemIndex)));
                dbElem.add("icon", (BValue)BIcon.make((String)"module://sbc/resources/images/element.png"), 4);
                BSbcProxyExt dbRamProxyExt = new BSbcProxyExt();
                dbRamProxyExt.setDataFormat((BEnum)BSbcRegisterTypeEnum.signedInt);
                dbRamProxyExt.setMemoryAddress(memAddress);
                dbElem.setProxyExt((BAbstractProxyExt)dbRamProxyExt);
                bComponent.add(dbElemName, (BValue)dbElem);
            }
        }
        catch (Exception e) {
            throw new Exception("Exception occurred during adding Db Elements", e);
        }
    }

    private static boolean isChildAlreadyExists(String dbElemName, BComponent bComponent) {
        BComponent[] childArray;
        boolean isChildPresent = false;
        for (BComponent child : childArray = bComponent.getChildComponents()) {
            if (!child.getName().equalsIgnoreCase(dbElemName)) continue;
            return true;
        }
        return isChildPresent;
    }

    public static List<Integer> getDbElemToAdd(BSbcDbBean bean) throws Exception {
        ArrayList<Integer> dbElemIndexList = new ArrayList<Integer>();
        int blockSize = Integer.parseInt(bean.getDbElemSize());
        try {
            if (!bean.getUserSelectedVal().equals("")) {
                String[] dbElem = bean.getUserSelectedVal().split(",");
                SbcUtil.parsedbElement(dbElem, dbElemIndexList, blockSize);
            }
        }
        catch (Exception e) {
            throw new Exception("Exception occurred during parsing user input of db elements", e);
        }
        return dbElemIndexList;
    }

    private static void parsedbElement(String[] dbElem, List<Integer> dbElemIndexList, int blockSize) {
        for (String dbElemIndex : dbElem) {
            SbcUtil.parseAndAddDBElement(dbElemIndex, dbElemIndexList, blockSize);
        }
    }

    private static void parseAndAddDBElement(String dbElemIndex, List<Integer> dbElemIndexList, int blockSize) {
        block6: {
            try {
                if (dbElemIndex.contains("-")) {
                    String[] arr = dbElemIndex.split("-");
                    for (int i = Integer.parseInt(arr[0]); i <= Integer.parseInt(arr[1]); ++i) {
                        if (!SbcUtil.isValidDbElem(i, blockSize)) continue;
                        dbElemIndexList.add(i);
                    }
                } else if (SbcUtil.isValidDbElem(Integer.parseInt(dbElemIndex), blockSize)) {
                    dbElemIndexList.add(Integer.parseInt(dbElemIndex));
                }
            }
            catch (Exception e) {
                if (!log_driver.isLoggable(Level.SEVERE)) break block6;
                log_driver.log(Level.SEVERE, "Unable to parse dbElement");
            }
        }
    }

    private static boolean isValidDbElem(int dbElemIndex, int blockSize) throws Exception {
        boolean isValidDbElem = false;
        if (dbElemIndex < blockSize) {
            isValidDbElem = true;
        } else {
            log_driver.log(Level.WARNING, "Attempt to add invalid DB Element " + dbElemIndex + ".The size of DB Block is " + blockSize);
        }
        return isValidDbElem;
    }

    public static int getDataBlockSize(String memoryAddress, BSbcDevice device) throws Exception {
        int dbBlockSize = 0;
        try {
            ReadDBSize readDbSizeCommand = new ReadDBSize(Integer.parseInt(memoryAddress), 7);
            int nextSeqNo = device.getSbcIpDriverNetwork().getSequenceNumber();
            SbcRequestMessage requestMessage = new SbcRequestMessage(device.getStationId(), nextSeqNo);
            requestMessage.setResponseTimeOut(device.getReadTimeout());
            requestMessage.appendPayload(readDbSizeCommand.getPayload());
            requestMessage.setAddress((BAddress)device.getIpAddress());
            NComm comm = (NComm)device.getSbcIpDriverNetwork().getUdpConfig().comm();
            SbcResponseMessage msg = (SbcResponseMessage)comm.sendRequest((NMessage)requestMessage);
            byte[] respMsg = msg.getResponsePayload();
            byte[] value = Arrays.copyOfRange(respMsg, 9, 12);
            dbBlockSize = SbcByteConverter.convertByteArrayToSignedInt(value);
        }
        catch (Exception e) {
            throw new Exception("Exception occurred fetching data block Size", e);
        }
        return dbBlockSize;
    }

    public static void removeUnwantedElements(List<Integer> dbElemList, BComponent bComponent) throws Exception {
        try {
            BComponent[] childArray;
            for (BComponent child : childArray = bComponent.getChildComponents()) {
                int elemIndex = Integer.parseInt(child.getName().replace("Element", "").trim());
                if (dbElemList.contains(elemIndex)) continue;
                bComponent.remove((BComplex)child);
            }
        }
        catch (Exception e) {
            throw new Exception("Error occurred during removing a child component", e);
        }
    }

    public static BComponent getParentDevice(BComponent bComponent) {
        BComponent obj = (BComponent)bComponent.getParent();
        if (null != obj) {
            if (obj instanceof BSbcDevice) {
                return obj;
            }
            return SbcUtil.getParentDevice(obj);
        }
        return obj;
    }

    public static void logFinestMessage(String input) {
        if (log_driver.isLoggable(Level.FINEST)) {
            log_driver.log(Level.FINEST, input);
        }
    }

    public static String getPassword(final BPassword password) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String output = "";
                if (!password.isDefault()) {
                    output = password.getValue();
                }
                return output;
            }
        });
    }

    public static String getProgramCrcFromLine(String input) {
        String output;
        block3: {
            output = "";
            String[] tokens = input.split("=");
            if (tokens.length > 1) {
                try {
                    output = tokens[1];
                }
                catch (Exception e) {
                    if (!log_driver.isLoggable(Level.FINER)) break block3;
                    log_driver.log(Level.FINER, "Found invalid program crc: " + tokens[1], e);
                }
            }
        }
        return output;
    }

    private static String getUrlToProgramInfo() {
        StringBuilder programInfoUrl = new StringBuilder();
        programInfoUrl.append("GET /PROGRAMINFO.TXT?").append(" HTTP/1.1\r\nHost: localhost\r\n").append("User-Agent: Saia.Net/2.1\r\n\r\n");
        return programInfoUrl.toString();
    }

    public static void sendProgramInfoRequest(BSbcDevice bSbcDevice) throws Exception {
        block5: {
            String programInfoUrl = SbcUtil.getUrlToProgramInfo();
            SbcWebRequest sbcWebRequest = new SbcWebRequest();
            sbcWebRequest.authenticateHttpConnection(bSbcDevice);
            String[] responseArray = null;
            try {
                Thread.sleep(500L);
                sbcWebRequest.sendWebRequest(programInfoUrl, bSbcDevice);
                String responseStr = sbcWebRequest.getResponseString(bSbcDevice);
                responseArray = sbcWebRequest.getDataArrayFromResponse(responseStr);
                String progCrc = "";
                for (String line : responseArray) {
                    if (!line.startsWith("ProgramCRC")) continue;
                    progCrc = SbcUtil.getProgramCrcFromLine(line);
                    break;
                }
                if (bSbcDevice.getIsProgramCRCRead()) {
                    SbcUtil.processProgramCRC(bSbcDevice, progCrc);
                } else {
                    bSbcDevice.setProgramCRC(progCrc);
                    bSbcDevice.setIsProgramCRCRead(true);
                }
            }
            catch (Exception e) {
                if (!log_driver.isLoggable(Level.FINER)) break block5;
                log_driver.log(Level.FINER, "Error occurred while fetching PROGRAMINFO.TXT file pcd", e);
            }
        }
    }

    private static void processProgramCRC(BSbcDevice bSbcDevice, String progCrc) {
        if (!bSbcDevice.getProgramCRC().equalsIgnoreCase(progCrc)) {
            SbcUtil.generateCRCMisMatchAlarm(bSbcDevice, progCrc);
        } else if (SbcUtil.isCRCMessageStateChanged(bSbcDevice, "")) {
            SbcUtil.updateAlarm(bSbcDevice, true);
        }
    }

    private static void generateCRCMisMatchAlarm(BSbcDevice bSbcDevice, String progCrc) {
        if (SbcUtil.isCRCMessageStateChanged(bSbcDevice, lexicon.getText("SbcDevInfo.pcd.program.match.error", new Object[]{bSbcDevice.getProgramCRC(), progCrc}))) {
            bSbcDevice.setProgramCRCMismatcherror(lexicon.getText("SbcDevInfo.pcd.program.match.error", new Object[]{bSbcDevice.getProgramCRC(), progCrc}));
            if (!bSbcDevice.getUuid().equals((Object)BUuid.DEFAULT) && !bSbcDevice.getUuid().equals((Object)BUuid.NULL)) {
                SbcConstants.CRC_MISMATCH_ERROR = bSbcDevice.getProgramCRCMismatcherror();
                SbcUtil.updateGeneratedAlarm(bSbcDevice, SbcConstants.CRC_MISMATCH_ERROR);
            } else {
                SbcUtil.generateAlarm(bSbcDevice, true);
            }
        }
    }

    private static boolean isCRCMessageStateChanged(BSbcDevice device, String expectedMsg) {
        return !device.getProgramCRCMismatcherror().equals(expectedMsg);
    }

    public static boolean isDeviceStatusChanged(BSbcDevice device, String expectedMsg) {
        return !device.getStatusErrorMessage().equals(expectedMsg);
    }

    public static BAlarmRecord getAlarmRecordFromDb(BUuid uuid) {
        AlarmDbConnection connection = null;
        BAlarmRecord alarmRecord = null;
        try {
            connection = SbcUtil.getAlarmService().getAlarmDb().getDbConnection(null);
            alarmRecord = connection.getRecord(uuid);
        }
        catch (Exception e) {
            throw new SbcAlarmHandlingException(" Error occurred while fetching Alarm record from Niagara db", e);
        }
        return alarmRecord;
    }

    public static void generateAlarm(BSbcDevice device, boolean isCRCMisMatch) {
        BAlarmRecord alarmRecord = new BAlarmRecord();
        BUuid uuid = BUuid.make();
        if (isCRCMisMatch) {
            device.setUuid(uuid);
            alarmRecord.setUuid(uuid);
            SbcConstants.CRC_MISMATCH_ERROR = device.getProgramCRCMismatcherror();
            SbcUtil.processToGenerateAlarm(SbcConstants.CRC_MISMATCH_ERROR, device, alarmRecord);
        } else {
            device.setStatusUuid(uuid);
            alarmRecord.setUuid(uuid);
            SbcConstants.STATUS_ERROR_MESSAGE = device.getStatusErrorMessage();
            SbcUtil.processToGenerateAlarm(SbcConstants.STATUS_ERROR_MESSAGE, device, alarmRecord);
        }
    }

    public static void processToGenerateAlarm(String expectedMessage, BSbcDevice device, BAlarmRecord alarmRecord) {
        alarmRecord.setAlarmClass(device.getAlarmSourceInfo().getAlarmClass());
        BOrdList list = BOrdList.make((BOrd)device.getNavOrd());
        BFacets alarmData = BFacets.make((String)"sourceName", (String)device.getDisplayName(null));
        alarmData = BFacets.make((BFacets)alarmData, (BFacets)BFacets.make((String)"msgText", (BIDataValue)BString.make((String)expectedMessage)));
        alarmData = BFacets.make((BFacets)alarmData, (BFacets)BFacets.make((String)"TimeZone", (BIDataValue)BTimeZone.getLocal()));
        alarmRecord.setAlarmData(alarmData);
        alarmRecord.setSource(list);
        alarmRecord.setLastUpdate(BAbsTime.now());
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        alarmService.routeAlarm(alarmRecord);
    }

    public static void updateAlarm(BSbcDevice bSbcDevice, boolean isCRCMisMatch) {
        if (isCRCMisMatch) {
            bSbcDevice.setProgramCRCMismatcherror("");
            SbcConstants.CRC_MISMATCH_ERROR = bSbcDevice.getProgramCRCMismatcherror();
            SbcUtil.processToUpdateCRCAlarm(SbcConstants.CRC_MISMATCH_ERROR, bSbcDevice);
        } else {
            bSbcDevice.setStatusErrorMessage("");
            SbcConstants.STATUS_ERROR_MESSAGE = bSbcDevice.getStatusErrorMessage();
            SbcUtil.processToUpdateStatusAlarm(SbcConstants.STATUS_ERROR_MESSAGE, bSbcDevice);
        }
    }

    public static void processToUpdateStatusAlarm(String expectedMessage, BSbcDevice bSbcDevice) {
        if (!bSbcDevice.getStatusUuid().equals((Object)BUuid.DEFAULT) && !bSbcDevice.getStatusUuid().equals((Object)BUuid.NULL)) {
            BAlarmRecord record = SbcUtil.getAlarmRecordFromDb(bSbcDevice.getStatusUuid());
            SbcUtil.updateExistingAlarm(record, bSbcDevice, expectedMessage);
        }
    }

    public static void processToUpdateCRCAlarm(String expectedMessage, BSbcDevice bSbcDevice) {
        if (!bSbcDevice.getUuid().equals((Object)BUuid.DEFAULT) && !bSbcDevice.getUuid().equals((Object)BUuid.NULL)) {
            BAlarmRecord record = SbcUtil.getAlarmRecordFromDb(bSbcDevice.getUuid());
            SbcUtil.updateExistingAlarm(record, bSbcDevice, expectedMessage);
        }
    }

    public static void updateExistingAlarm(BAlarmRecord record, BSbcDevice bSbcDevice, String expectedMessage) {
        if (record != null) {
            record.setSourceState(BSourceState.normal);
            record.setAckState(BAckState.unacked);
            record.setAckRequired(true);
            SbcUtil.processExistingAlarm(bSbcDevice, record, expectedMessage);
        }
    }

    public static void updateGeneratedAlarm(BSbcDevice device, String expectedMessage) {
        BAlarmRecord record = SbcUtil.getAlarmRecordFromDb(device.getUuid());
        if (record != null) {
            if (record.isAcknowledged()) {
                record.setAckState(BAckState.unacked);
                record.setAckRequired(true);
            }
            SbcUtil.processExistingAlarm(device, record, expectedMessage);
        }
    }

    public static void processExistingAlarm(BSbcDevice device, BAlarmRecord record, String expectedMessage) {
        BFacets alarmData = BFacets.make((String)"sourceName", (String)device.getDisplayName(null));
        alarmData = BFacets.make((BFacets)alarmData, (BFacets)BFacets.make((String)"msgText", (BIDataValue)BString.make((String)expectedMessage)));
        record.setAlarmData(alarmData);
        record.setNormalTime(BAbsTime.now());
        record.setLastUpdate(BAbsTime.now());
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        alarmService.routeAlarm(record);
    }
}

