/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.util;

import com.honeywell.sbc.exception.ConversionException;
import com.honeywell.sbc.util.SbcUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import javax.baja.nre.util.ByteBuffer;

public class SbcByteConverter {
    private static final long MAX32UNISIGNEDINT = 0xFFFFFFFFL;
    private static final int BITS9 = 9;
    private static final int MAXBYTE_VALUE = 255;
    private static final int HALFMAXBYTE_VALUE = 127;
    private static final int EXCESS64 = 62;
    private static final int MAX_EXPONENT = 189;
    private static final int BYTE_ARRAY_SIZE = 4;
    private static final int BITS8 = 8;

    public static int convertByteArrayToSignedInt(byte[] b) throws ConversionException {
        if (b.length > 4) {
            throw new ConversionException("Too big to convert to SignedInt");
        }
        int signedInt = 0;
        for (int i = 0; i < b.length; ++i) {
            signedInt <<= 8;
            signedInt |= b[i] & 0xFF;
        }
        SbcUtil.log_driver.log(Level.INFO, " ***** Signed value in convertByteArrayToSignedInt is ::: " + signedInt);
        return signedInt;
    }

    public static long convertByteArrayToUnSignedInt(byte[] b) throws ConversionException {
        if (b.length > 4) {
            throw new ConversionException("Too big to convert to UnSignedInt");
        }
        long l = 0L;
        if (b.length == 4) {
            l |= (long)(b[0] & 0xFF);
            l <<= 8;
            l |= (long)(b[1] & 0xFF);
            l <<= 8;
            l |= (long)(b[2] & 0xFF);
            l <<= 8;
            l |= (long)(b[3] & 0xFF);
        } else {
            SbcUtil.log_driver.log(Level.SEVERE, " Error: Length of data byte received is " + b.length + ". Expected 4");
        }
        SbcUtil.log_driver.log(Level.INFO, " ***** Unsigned value in convertByteArrayToUnSignedInt is ::: " + l);
        return l;
    }

    public static byte[] convertSignedIntToByteArray(int input) {
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bytes[i] = (byte)(input >>> i * 8);
            SbcUtil.log_driver.log(Level.INFO, " ***** Signed byte array in convertSignedIntToByteArray is ::: " + bytes[i]);
        }
        return bytes;
    }

    public static byte[] convertUnSignedIntToByteArray(int input) {
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bytes[i] = (byte)(input >> (i & 0xFF));
            SbcUtil.log_driver.log(Level.INFO, " ***** UnSigned byte array in convertUnSignedIntToByteArray is ::: " + bytes[i]);
        }
        return bytes;
    }

    public static byte[] convertIEEEFloatToByteArray(float input) {
        byte[] conv;
        ByteBuffer buf = new ByteBuffer();
        buf.writeFloat(input);
        for (byte p : conv = Arrays.copyOfRange(buf.getBytes(), 0, 4)) {
            SbcUtil.log_driver.log(Level.INFO, " ***** UnSigned byte array in convertIEEEFloatToByteArray is ::: " + p);
        }
        return conv;
    }

    public static float convertByteArrayToIEEEFloat(byte[] b) {
        try {
            ByteBuffer buf = new ByteBuffer(b);
            return buf.readFloat();
        }
        catch (IOException e) {
            SbcUtil.log_driver.log(Level.SEVERE, "Something went wrong while converting to IEEE Float\n" + e.getMessage(), e);
            return 0.0f;
        }
    }

    public static double convertByteArrayToMffp(byte[] value) {
        long maskByte = 0xFFFFFFFFL;
        int signedInt = 0;
        long unsignedLong = 0L;
        try {
            ByteBuffer buffer = new ByteBuffer(value);
            signedInt = buffer.readInt();
            unsignedLong = Integer.toUnsignedLong(signedInt);
            SbcByteConverter.defaultChecksForFloatConversion(unsignedLong);
            unsignedLong <<= 1;
            long exponent = (unsignedLong &= maskByte) & 0xFFL;
            exponent ^= 0x80L;
            if (((exponent >>= 1) & 0x40L) != 0L) {
                exponent += 128L;
                exponent &= 0xFFL;
            }
            exponent -= 130L;
            unsignedLong &= 0xFFFFFFFFFFFFFF00L;
            unsignedLong += (exponent &= 0xFFL);
            for (int i = 0; i < 9; ++i) {
                unsignedLong = ((unsignedLong &= maskByte) & 1L) != 0L ? unsignedLong >> 1 | Integer.MIN_VALUE : unsignedLong >> 1;
            }
            return Float.intBitsToFloat((int)unsignedLong);
        }
        catch (IOException e) {
            SbcUtil.log_driver.log(Level.SEVERE, "Something went wrong while converting to byte array to Mffp Float", e);
            return 0.0;
        }
    }

    private static double defaultChecksForFloatConversion(long unsignedLong) {
        if ((unsignedLong & Integer.MIN_VALUE) == 0L && unsignedLong != 0L) {
            return Double.NaN;
        }
        if ((unsignedLong & Integer.MIN_VALUE) == 0L) {
            return 0.0;
        }
        return 0.0;
    }

    public static byte[] convertMffpToByteArray(float iFloat) {
        long maskByte = 0xFFFFFFFFL;
        long unsignedInt = Float.floatToIntBits(iFloat);
        for (int i = 0; i < 9; ++i) {
            unsignedInt = ((unsignedInt &= maskByte) & Integer.MIN_VALUE) != 0L ? unsignedInt << 1 | 1L : unsignedInt << 1;
        }
        long e = (unsignedInt &= maskByte) & 0xFFL;
        if (e < 62L) {
            return new byte[]{0, 0, 0, 0};
        }
        if (e > 189L) {
            byte[] byArray;
            if ((unsignedInt & 0x100L) != 0L) {
                byte[] byArray2 = new byte[4];
                byArray2[0] = -1;
                byArray2[1] = -1;
                byArray2[2] = -1;
                byArray = byArray2;
                byArray2[3] = -1;
            } else {
                byte[] byArray3 = new byte[4];
                byArray3[0] = -1;
                byArray3[1] = -1;
                byArray3[2] = -1;
                byArray = byArray3;
                byArray3[3] = 127;
            }
            return byArray;
        }
        e = (byte)((e << 1) + 5L ^ 0x80L);
        unsignedInt = (unsignedInt & 0xFFFFFFFFFFFFFF00L) + (e &= 0xFFL);
        unsignedInt = ((unsignedInt &= maskByte) & 1L) != 0L ? unsignedInt >> 1 | Integer.MIN_VALUE : unsignedInt >> 1;
        int reverseBytes = Integer.reverseBytes((int)(unsignedInt &= maskByte));
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bytes[i] = (byte)(reverseBytes >> i * 8 & 0xFF);
            SbcUtil.log_driver.log(Level.INFO, " ***** MFFP byte array in convertMffpToByteArray is ::: " + bytes[i]);
        }
        return bytes;
    }

    public static double convertToAppropriateValue(int conversionType, byte[] value) throws ConversionException {
        switch (conversionType) {
            case 1: {
                return SbcByteConverter.convertByteArrayToSignedInt(value);
            }
            case 2: {
                return SbcByteConverter.convertByteArrayToUnSignedInt(value);
            }
            case 4: {
                return SbcByteConverter.convertByteArrayToIEEEFloat(value);
            }
            case 3: {
                return SbcByteConverter.convertByteArrayToMffp(value);
            }
        }
        return SbcByteConverter.convertByteArrayToSignedInt(value);
    }

    public static double convertToAppropriateValueForRegFloat(int conversionType, byte[] value) throws ConversionException {
        switch (conversionType) {
            case 1: {
                return SbcByteConverter.convertByteArrayToMffp(value);
            }
            case 2: {
                return SbcByteConverter.convertByteArrayToIEEEFloat(value);
            }
        }
        return SbcByteConverter.convertByteArrayToIEEEFloat(value);
    }
}

