/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.util;

import com.honeywell.sbc.alarms.BSbcAlarmDeviceExt;
import com.honeywell.sbc.util.SbcUtil;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType
public class BSbcUtilRpc
extends BObject {
    public static final Type TYPE = Sys.loadType(BSbcUtilRpc.class);
    public static final Lexicon lexicon = Lexicon.make(BSbcUtilRpc.class);
    public static final Logger log_driver = Logger.getLogger("SbcIpDriver");

    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.box)}, permissions="unrestricted")
    public static String checkForceClear(Map<String, Object> map, Context cx) {
        return AccessController.doPrivileged(() -> {
            String errorMessage;
            block3: {
                errorMessage = "";
                try {
                    boolean allowClear = BSbcUtilRpc.isForceClearAllowed(map);
                    if (!allowClear) {
                        errorMessage = lexicon.get("sbcdb.msg.forceClearError");
                    }
                }
                catch (FeatureNotLicensedException ex) {
                    errorMessage = "Internal error occurred, check station errors";
                    if (!log_driver.isLoggable(Level.FINER)) break block3;
                    log_driver.log(Level.FINER, "Force Clear not allowed for this record", ex);
                }
            }
            return errorMessage;
        });
    }

    private static boolean isForceClearAllowed(Map<String, Object> map) {
        boolean isSbcAlarm = false;
        boolean allowClear = true;
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        ArrayList arrayList = (ArrayList)map.get("records");
        for (HashMap object : arrayList) {
            Set entrySet = object.entrySet();
            for (Map.Entry entry : entrySet) {
                BUuid uuid;
                BAlarmRecord alarmRecord;
                if (!((String)entry.getKey()).equals("uuid") || (alarmRecord = SbcUtil.getAlarmRecordFromDb(uuid = BUuid.make((String)entry.getValue().toString()))) == null) continue;
                BSourceState alarmState = alarmRecord.getSourceState();
                BOrdList list = alarmRecord.getSource();
                BObject obj = list.get(0).resolve((BObject)alarmService).get();
                if (obj instanceof BSbcAlarmDeviceExt) {
                    isSbcAlarm = true;
                }
                boolean bl = allowClear = !isSbcAlarm;
                if (!isSbcAlarm || BSourceState.normal.equals((Object)alarmState)) continue;
                return false;
            }
        }
        return allowClear;
    }
}

