/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.util;

import com.honeywell.sbc.BSbcDevice;
import com.honeywell.sbc.common.BSbcWorker;
import com.honeywell.sbc.message.SbcRequestMessage;
import com.honeywell.sbc.message.SbcResponseMessage;
import com.honeywell.sbc.message.commands.ReadPcdTypeFwVersion;
import com.honeywell.sbc.message.commands.ReadSystemInformation;
import com.honeywell.sbc.stations.BSbcSubStation;
import com.honeywell.sbc.util.SbcUtil;
import com.honeywell.sbc.util.TimeZoneMapper;
import com.honeywell.sbc.web.SbcWebRequest;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.logging.Level;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="PCDStatus", type="String", defaultValue="", flags=1), @NiagaraProperty(name="PCDType", type="String", defaultValue="", flags=1), @NiagaraProperty(name="PCDClock", type="String", defaultValue="", flags=1), @NiagaraProperty(name="pcdTimeZoneCode", type="BString", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="pcdTimeZone", type="BTimeZone", defaultValue="BTimeZone.DEFAULT", flags=5), @NiagaraProperty(name="FirmwareVersion", type="String", defaultValue="", flags=1), @NiagaraProperty(name="worker", type="BSbcWorker", defaultValue="new BSbcWorker()", flags=4)})
@NiagaraAction(name="readSystemInfo", flags=20)
public class BSbcDeviceInformation
extends BComponent {
    public static final Property PCDStatus = BSbcDeviceInformation.newProperty((int)1, (String)"", null);
    public static final Property PCDType = BSbcDeviceInformation.newProperty((int)1, (String)"", null);
    public static final Property PCDClock = BSbcDeviceInformation.newProperty((int)1, (String)"", null);
    public static final Property pcdTimeZoneCode = BSbcDeviceInformation.newProperty((int)1, (BValue)BString.DEFAULT, null);
    public static final Property pcdTimeZone = BSbcDeviceInformation.newProperty((int)5, (BValue)BTimeZone.DEFAULT, null);
    public static final Property FirmwareVersion = BSbcDeviceInformation.newProperty((int)1, (String)"", null);
    public static final Property worker = BSbcDeviceInformation.newProperty((int)4, (BValue)new BSbcWorker(), null);
    public static final Action readSystemInfo = BSbcDeviceInformation.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BSbcDeviceInformation.class);
    public static final Lexicon lexicon = Lexicon.make(BSbcDeviceInformation.class);
    private static final int RES_YEAR_INDEX = 11;
    private static final int RES_MONTH_INDEX = 12;
    private static final int RES_DAY_INDEX = 13;
    private static final int RES_HOUR_INDEX = 14;
    private static final int RES_MIN_INDEX = 15;
    private static final int RES_SEC_INDEX = 16;
    private static final int PCD_STATUS_INDEX = 9;
    private static final int PCD_RUN = 82;
    private static final int PCD_STOP = 83;
    private static final int PCD_HALT = 72;
    private static final int PCDTYPE_RES_START_INDEX = 26;
    private static final int PCDTYPE_INDEX = 0;
    private static final int PCDFW_INDEX = 1;
    private static final String RESMSG_SPLIT_REG = ", 0";
    private static final String REQ_BYTE_SPLIT_REG = ",";

    public String getPCDStatus() {
        return this.getString(PCDStatus);
    }

    public void setPCDStatus(String v) {
        this.setString(PCDStatus, v, null);
    }

    public String getPCDType() {
        return this.getString(PCDType);
    }

    public void setPCDType(String v) {
        this.setString(PCDType, v, null);
    }

    public String getPCDClock() {
        return this.getString(PCDClock);
    }

    public void setPCDClock(String v) {
        this.setString(PCDClock, v, null);
    }

    public String getPcdTimeZoneCode() {
        return this.getString(pcdTimeZoneCode);
    }

    public void setPcdTimeZoneCode(String v) {
        this.setString(pcdTimeZoneCode, v, null);
    }

    public BTimeZone getPcdTimeZone() {
        return (BTimeZone)this.get(pcdTimeZone);
    }

    public void setPcdTimeZone(BTimeZone v) {
        this.set(pcdTimeZone, (BValue)v, null);
    }

    public String getFirmwareVersion() {
        return this.getString(FirmwareVersion);
    }

    public void setFirmwareVersion(String v) {
        this.setString(FirmwareVersion, v, null);
    }

    public BSbcWorker getWorker() {
        return (BSbcWorker)this.get(worker);
    }

    public void setWorker(BSbcWorker v) {
        this.set(worker, (BValue)v, null);
    }

    public void readSystemInfo() {
        this.invoke(readSystemInfo, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.get("timeZone") != null) {
            this.remove("timeZone");
        }
    }

    public void doReadSystemInfo() {
        BSbcDevice device = (BSbcDevice)this.getParent();
        if (device.isDeviceStatusOk()) {
            try {
                if ("Head Station".equalsIgnoreCase(device.getDeviceType())) {
                    this.readTimeZone(device);
                }
                this.readSystemStatusAndClock(20, device);
                this.readSystemStatusAndClock(4, device);
                this.readPcdTypeAndPcdFw(device);
            }
            catch (Exception e) {
                SbcUtil.log_driver.log(Level.SEVERE, "Unexpected error occurred, while reading pcd information ", e);
            }
        } else {
            SbcUtil.log_driver.log(Level.SEVERE, "Device is down or not reachable. Could not fetch system information");
            this.setPCDStatus("Device down or not reachable");
            this.setPCDType("Device down or not reachable");
            this.setFirmwareVersion("Device down or not reachable");
            this.setPCDClock("Device down or not reachable");
        }
    }

    public void readSystemStatusAndClock(int reqCommand, BSbcDevice sbcDevice) throws Exception {
        ReadSystemInformation readSysInfo = new ReadSystemInformation(reqCommand);
        int nextSeqNo = sbcDevice.getSbcIpDriverNetwork().getSequenceNumber();
        SbcRequestMessage requestMessage = new SbcRequestMessage(sbcDevice.getStationId(), nextSeqNo);
        requestMessage.setResponseTimeOut(sbcDevice.getReadTimeout());
        requestMessage.appendPayload(readSysInfo.getPayload());
        requestMessage.setAddress((BAddress)sbcDevice.getIpAddress());
        NComm comm = (NComm)sbcDevice.getSbcIpDriverNetwork().getUdpConfig().comm();
        SbcResponseMessage msg = (SbcResponseMessage)comm.sendRequest((NMessage)requestMessage);
        byte[] respMsg = msg.getResponsePayload();
        if (reqCommand == 20) {
            this.displayPcdStatusInfo(sbcDevice, respMsg);
        } else if (reqCommand == 4) {
            this.displayPcdClockInfo(respMsg);
        }
    }

    private void displayPcdClockInfo(byte[] respMsgClock) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat df1 = new SimpleDateFormat("yy-MM-dd'T'HH:mm:ss");
        try {
            int LEN_CLOCK_RES = 19;
            if (respMsgClock.length == LEN_CLOCK_RES) {
                cal.set(Integer.parseInt(Integer.toHexString(respMsgClock[11] & 0xFF)), Integer.parseInt(Integer.toHexString(respMsgClock[12])) - 1, Integer.parseInt(Integer.toHexString(respMsgClock[13])), Integer.parseInt(Integer.toHexString(respMsgClock[14])), Integer.parseInt(Integer.toHexString(respMsgClock[15])), Integer.parseInt(Integer.toHexString(respMsgClock[16])));
                this.setPCDClock(df1.format(cal.getTime()));
            }
        }
        catch (NumberFormatException nfe) {
            SbcUtil.log_driver.log(Level.SEVERE, "Unable to fomrat the clock information", nfe);
        }
    }

    private void displayPcdStatusInfo(BSbcDevice bSbcDevice, byte[] respMsgStatus) {
        if (respMsgStatus[9] == 82) {
            this.setPCDStatus("Run");
            if (SbcUtil.isDeviceStatusChanged(bSbcDevice, "")) {
                SbcUtil.updateAlarm(bSbcDevice, false);
            }
        } else if (respMsgStatus[9] == 83) {
            this.setPCDStatus("Stop");
            if (SbcUtil.isDeviceStatusChanged(bSbcDevice, lexicon.getText("SbcDevInfo.pcd.status.stop"))) {
                bSbcDevice.setStatusErrorMessage(lexicon.getText("SbcDevInfo.pcd.status.stop"));
                SbcUtil.generateAlarm(bSbcDevice, false);
            }
        } else if (respMsgStatus[9] == 72) {
            this.setPCDStatus("Halt");
            if (SbcUtil.isDeviceStatusChanged(bSbcDevice, lexicon.getText("SbcDevInfo.pcd.status.halt"))) {
                bSbcDevice.setStatusErrorMessage(lexicon.getText("SbcDevInfo.pcd.status.halt"));
                SbcUtil.generateAlarm(bSbcDevice, false);
            }
        } else {
            this.setPCDStatus("unable to fetch status");
        }
    }

    public void readPcdTypeAndPcdFw(BSbcDevice sbcDevice) throws Exception {
        ReadPcdTypeFwVersion readSysInfo = new ReadPcdTypeFwVersion();
        int nextSeqNo = sbcDevice.getSbcIpDriverNetwork().getSequenceNumber();
        SbcRequestMessage requestMessage = new SbcRequestMessage(sbcDevice.getStationId(), nextSeqNo);
        requestMessage.setResponseTimeOut(sbcDevice.getReadTimeout());
        requestMessage.appendPayload(readSysInfo.getPayload());
        requestMessage.setAddress((BAddress)sbcDevice.getIpAddress());
        NComm comm = (NComm)sbcDevice.getSbcIpDriverNetwork().getUdpConfig().comm();
        SbcResponseMessage msg = (SbcResponseMessage)comm.sendRequest((NMessage)requestMessage);
        byte[] respMsg = msg.getResponsePayload();
        byte[] resReqBytes = Arrays.copyOfRange(respMsg, 26, respMsg.length);
        String[] respMsgToString = Arrays.toString(resReqBytes).split(RESMSG_SPLIT_REG);
        String[] resMsgReqBytes = respMsgToString[0].substring(1).split(REQ_BYTE_SPLIT_REG);
        char[] pcdTypeInfo = new char[resMsgReqBytes.length];
        for (int i = 0; i < resMsgReqBytes.length; ++i) {
            pcdTypeInfo[i] = (char)Byte.valueOf(resMsgReqBytes[i].trim()).byteValue();
        }
        resMsgReqBytes = respMsgToString[1].substring(1).split(REQ_BYTE_SPLIT_REG);
        char[] fwVersionInfo = new char[resMsgReqBytes.length];
        for (int i = 0; i < resMsgReqBytes.length; ++i) {
            fwVersionInfo[i] = (char)Byte.valueOf(resMsgReqBytes[i].trim()).byteValue();
        }
        this.setPCDType(String.valueOf(pcdTypeInfo));
        this.setFirmwareVersion(String.valueOf(fwVersionInfo));
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        this.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, argument, cx));
        return null;
    }

    private void readTimeZone(BSbcDevice device) {
        String timeZoneId;
        BTimeZone timeZone;
        block6: {
            timeZone = null;
            timeZoneId = null;
            try {
                String timezoneQuery = this.getUrlForTimeZone();
                SbcWebRequest sbcWebRequest = new SbcWebRequest();
                sbcWebRequest.sendWebRequest(timezoneQuery, device);
                String responseStr = sbcWebRequest.getResponseString(device);
                String[] responseArray = sbcWebRequest.getDataArrayFromResponse(responseStr);
                if (responseArray.length > 0 && (timeZoneId = responseArray[0]) != null && timeZoneId.trim().length() > 0) {
                    timeZone = TimeZoneMapper.getTimeZone(responseArray[0]);
                }
            }
            catch (Exception exp) {
                if (!SbcUtil.log_driver.isLoggable(Level.FINER)) break block6;
                SbcUtil.log_driver.log(Level.FINER, "Unexpected error while reading time zone.", exp);
            }
        }
        if (timeZone == null) {
            timeZone = BTimeZone.getLocal();
            timeZoneId = timeZone.getId();
        }
        if (timeZoneId == null || timeZoneId.trim().length() == 0) {
            timeZoneId = timeZone.getId();
        }
        if (SbcUtil.log_driver.isLoggable(Level.FINEST)) {
            SbcUtil.log_driver.log(Level.FINEST, "Identified time zone code is:\t" + timeZoneId);
        }
        this.setPcdTimeZoneCode(timeZoneId);
        this.setPcdTimeZone(timeZone);
        this.updateAllItsSubstations(device, timeZone, timeZoneId);
    }

    private void updateAllItsSubstations(BSbcDevice device, BTimeZone timeZone, String timeZoneId) {
        BITable subStations = null;
        String bqlStr = device.getAbsoluteOrd().toString().concat("|bql:select * from sbc:SbcSubStation");
        try {
            subStations = (BITable)BOrd.make((String)bqlStr).get();
        }
        catch (UnresolvedException ure) {
            SbcUtil.log_driver.log(Level.SEVERE, "Unable to resolve the ord while accessing sub stations for network" + this.getName(), ure);
        }
        if (null != subStations) {
            TableCursor sStationCursor = subStations.cursor();
            while (sStationCursor.next()) {
                BSbcSubStation sStation = (BSbcSubStation)((Object)sStationCursor.get());
                BSbcDeviceInformation information = sStation.getDeviceInformation();
                information.setPcdTimeZone(timeZone);
                information.setPcdTimeZoneCode(timeZoneId);
            }
        }
    }

    private String getUrlForTimeZone() {
        return "GET /cgi-bin/readVal.exe?CFG-Rtc,TimeZone HTTP/1.1\r\nHost: localhost\r\nUser-Agent: Saia.Net/2.1\r\n\r\n";
    }
}

