/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.stations;

import com.honeywell.sbc.BSbcDevice;
import com.honeywell.sbc.BSbcDeviceFolder;
import com.honeywell.sbc.BSbcNetwork;
import com.honeywell.sbc.hdlogs.BSbcHDLog;
import com.honeywell.sbc.hdlogs.BSbcHDLogs;
import com.honeywell.sbc.stations.BSbcHeadStation;
import com.tridium.ndriver.datatypes.BIpAddress;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.BDriverContainer;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameMap;

@NiagaraType
public class BSbcSubStation
extends BSbcDevice {
    public static final Type TYPE = Sys.loadType(BSbcSubStation.class);
    public static final BIcon subStationIcon = BIcon.make((String)"module://sbc/resources/images/sStation.png");

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BSbcDevice || parent instanceof BSbcDeviceFolder;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.setDeviceType("Sub Station");
        this.setFlags(this.getSlot("ipAddress"), 1);
        this.setFlags(this.getSlot("dataPollingStatus"), 5);
        this.changeDataPollingStatus(false);
        if (this.getParent() instanceof BSbcHeadStation) {
            BSbcHeadStation headStationDevice = (BSbcHeadStation)this.getParent();
            this.setIpAddress(new BIpAddress(headStationDevice.getIpAddress().getIpAddress(), headStationDevice.getIpAddress().getPort()));
            this.setEnabled(headStationDevice.getEnabled());
            BDriverContainer drivers = (BDriverContainer)Sys.getService((Type)BDriverContainer.TYPE);
            BSbcNetwork[] networks = (BSbcNetwork[])drivers.getChildren(BSbcNetwork.class);
            BSbcNetwork network = networks[0];
            BSbcDeviceFolder folder = (BSbcDeviceFolder)network.get(SlotPath.escape((String)"SUBSTATIONS"));
            if (((BComponent)this.getParent()).get("displayNames") != null) {
                ((BComponent)this.getParent()).set("displayNames", (BValue)((BNameMap)folder.get("displayNames")));
            } else {
                ((BComponent)this.getParent()).add("displayNames", (BValue)((BNameMap)folder.get("displayNames")));
            }
        }
        this.disableAllHDLogs();
    }

    private void disableAllHDLogs() {
        BSbcHDLog[] logs;
        BSbcHDLogs historiesObj = this.getHistories();
        for (BSbcHDLog log : logs = (BSbcHDLog[])historiesObj.getChildren(BSbcHDLog.class)) {
            log.setPollStatus(false);
            log.getHdLogPollFrequency().setTriggerMode((BTriggerMode)BManualTriggerMode.make());
        }
        this.setFlags((Slot)histories, 4);
        this.setFlags((Slot)numberOfAlarmPolls, 5);
    }

    @Override
    public BIcon getIcon() {
        return subStationIcon;
    }
}

