/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.stations;

import com.honeywell.sbc.BSbcDevice;
import com.honeywell.sbc.BSbcDeviceFolder;
import com.honeywell.sbc.BSbcNetwork;
import com.honeywell.sbc.common.SbcQueueManager;
import com.honeywell.sbc.stations.BSbcSubStation;
import com.tridium.ndriver.datatypes.BIpAddress;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="dataPollFrequency", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeSeconds(30)))", flags=4)
public class BSbcHeadStation
extends BSbcDevice {
    public static final Property dataPollFrequency = BSbcHeadStation.newProperty((int)4, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeSeconds((int)30))), null);
    public static final Type TYPE = Sys.loadType(BSbcHeadStation.class);
    public static final BIcon headStationIcon = BIcon.make((String)"module://sbc/resources/images/hStation.png");

    public BTimeTrigger getDataPollFrequency() {
        return (BTimeTrigger)this.get(dataPollFrequency);
    }

    public void setDataPollFrequency(BTimeTrigger v) {
        this.set(dataPollFrequency, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BSbcNetwork || parent instanceof BSbcDeviceFolder;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.setDeviceType("Head Station");
        this.setDataPollingStatus(false);
        SbcQueueManager.make(this);
        this.linkTo(null, (BComponent)this.getDataPollFrequency(), (Slot)BTimeTrigger.fireTrigger, (Slot)readAlarms);
    }

    @Override
    public BIcon getIcon() {
        return headStationIcon;
    }

    @Override
    public void changed(Property property, Context cx) {
        super.changed(property, cx);
        if (this.isRunning() && property.equals(ipAddress) && !cx.equals(Context.decoding)) {
            BSbcSubStation[] subStations;
            for (BSbcSubStation subDevice : subStations = (BSbcSubStation[])this.getChildren(BSbcSubStation.class)) {
                subDevice.setIpAddress(new BIpAddress(this.getIpAddress().getIpAddress(), this.getIpAddress().getPort()));
            }
        }
    }
}

