/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.point;

import com.honeywell.sbc.BSbcDevice;
import com.honeywell.sbc.BSbcNetwork;
import com.honeywell.sbc.comm.BSbcUdpCommConfig;
import com.honeywell.sbc.enums.BSbcMediaTypeEnum;
import com.honeywell.sbc.exception.ConversionException;
import com.honeywell.sbc.hdlogs.BSbcHDLog;
import com.honeywell.sbc.hdlogs.BSbcHDLogs;
import com.honeywell.sbc.message.ISbcMessage;
import com.honeywell.sbc.message.SbcRequestMessage;
import com.honeywell.sbc.message.SbcResponseMessage;
import com.honeywell.sbc.message.commands.ReadRegister;
import com.honeywell.sbc.message.commands.WriteBinary;
import com.honeywell.sbc.message.commands.WriteCounter;
import com.honeywell.sbc.message.commands.WriteDbRam;
import com.honeywell.sbc.message.commands.WriteRegister;
import com.honeywell.sbc.message.commands.WriteRegisterFloat;
import com.honeywell.sbc.message.commands.WriteText;
import com.honeywell.sbc.message.commands.WriteTimer;
import com.honeywell.sbc.point.BSbcLinearConversion;
import com.honeywell.sbc.point.BSbcPointDeviceExt;
import com.honeywell.sbc.util.SbcByteConverter;
import com.honeywell.sbc.util.SbcUtil;
import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.datatypes.BIpAddress;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.logging.Level;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="conversionUpdateRequired", type="boolean", defaultValue="true", flags=5), @NiagaraProperty(name="memoryAddress", type="String", defaultValue="\"-1\""), @NiagaraProperty(name="dataFormat", type="BEnum", defaultValue="BDynamicEnum.make(-1)"), @NiagaraProperty(name="textPollRequired", type="boolean", defaultValue="true", flags=5), @NiagaraProperty(name="writeRequired", type="boolean", defaultValue="true", flags=5)})
public class BSbcProxyExt
extends BProxyExt {
    public static final Property conversionUpdateRequired = BSbcProxyExt.newProperty((int)5, (boolean)true, null);
    public static final Property memoryAddress = BSbcProxyExt.newProperty((int)0, (String)"-1", null);
    public static final Property dataFormat = BSbcProxyExt.newProperty((int)0, (BValue)BDynamicEnum.make((int)-1), null);
    public static final Property textPollRequired = BSbcProxyExt.newProperty((int)5, (boolean)true, null);
    public static final Property writeRequired = BSbcProxyExt.newProperty((int)5, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BSbcProxyExt.class);
    private static final Double SBC_CONVERSION_VAL = 0.1;

    public boolean getConversionUpdateRequired() {
        return this.getBoolean(conversionUpdateRequired);
    }

    public void setConversionUpdateRequired(boolean v) {
        this.setBoolean(conversionUpdateRequired, v, null);
    }

    public String getMemoryAddress() {
        return this.getString(memoryAddress);
    }

    public void setMemoryAddress(String v) {
        this.setString(memoryAddress, v, null);
    }

    public BEnum getDataFormat() {
        return (BEnum)this.get(dataFormat);
    }

    public void setDataFormat(BEnum v) {
        this.set(dataFormat, (BValue)v, null);
    }

    public boolean getTextPollRequired() {
        return this.getBoolean(textPollRequired);
    }

    public void setTextPollRequired(boolean v) {
        this.setBoolean(textPollRequired, v, null);
    }

    public boolean getWriteRequired() {
        return this.getBoolean(writeRequired);
    }

    public void setWriteRequired(boolean v) {
        this.setBoolean(writeRequired, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BSbcNetwork getSbcIpDriverNetwork() {
        return (BSbcNetwork)this.getNetwork();
    }

    public final BSbcDevice getBSbcIpDriverDevice() {
        return (BSbcDevice)DrUtil.getParent((BComplex)this, (Type)BSbcDevice.TYPE);
    }

    public final BSbcPointDeviceExt getSbcIpDriverPointDeviceExt() {
        return (BSbcPointDeviceExt)this.getDeviceExt();
    }

    public void readSubscribed(Context cx) throws Exception {
        BSbcDevice sbcDevice = (BSbcDevice)this.getDevice();
        BSbcMediaTypeEnum sbcMediaType = (BSbcMediaTypeEnum)this.getParentPoint().get("mediaType");
        if (null != sbcMediaType) {
            if (sbcMediaType.getOrdinal() == 10 && this.getTextPollRequired()) {
                sbcDevice.addPointToSubscriptionList(this.getParentPoint());
                this.setTextPollRequired(false);
            } else if (sbcMediaType.getOrdinal() != 8) {
                sbcDevice.addPointToSubscriptionList(this.getParentPoint());
            }
        }
    }

    public void started() throws Exception {
        super.started();
        this.setWriteRequired(true);
        this.updateScaling();
        this.setTextPollRequired(true);
        this.findAndLinkAssociatedLog();
    }

    private void updateScaling() {
        if (!this.getConversionUpdateRequired()) {
            return;
        }
        BSbcMediaTypeEnum mediaType = (BSbcMediaTypeEnum)this.getParentPoint().get("mediaType");
        if (mediaType.getOrdinal() == 2) {
            if (this.getDataFormat().getOrdinal() == 1 || this.getDataFormat().getOrdinal() == 2) {
                if (!(this.getConversion() instanceof BSbcLinearConversion)) {
                    this.setConversion(BSbcLinearConversion.make(SBC_CONVERSION_VAL, 0.0));
                }
            } else {
                this.setConversion((BProxyConversion)BDefaultProxyConversion.DEFAULT);
            }
        }
        this.setConversionUpdateRequired(false);
    }

    public void readUnsubscribed(Context cx) throws Exception {
        ((BSbcDevice)this.getDevice()).removePointFromSubscriptionList(this.getParentPoint());
    }

    public boolean write(Context cx) throws Exception {
        if (SbcUtil.sbcPointWrite.isLoggable(Level.FINEST)) {
            SbcUtil.sbcPointWrite.log(Level.FINEST, String.format("Initiated writing point value:\t%s", this.getParentPoint().getSlotPath().toString()));
        }
        if (!this.isRunning() || this.getWriteValue().getStatus().isNull()) {
            return false;
        }
        if (SbcUtil.sbcPointWrite.isLoggable(Level.FINEST)) {
            SbcUtil.sbcPointWrite.log(Level.FINEST, String.format("Started writing point value of:\t%s is: \t%s", this.getParentPoint().getSlotPath().toString(), this.getWriteValue().getValueValue().toString()));
        }
        BSbcMediaTypeEnum sbcMediaType = (BSbcMediaTypeEnum)this.getParentPoint().get("mediaType");
        int enumOrdinal = this.getDataFormat().getOrdinal();
        BSbcDevice device = this.getBSbcIpDriverDevice();
        if (sbcMediaType.getOrdinal() == 11) {
            this.sendWriteTextRequests(device);
        } else {
            ISbcMessage writePoint = this.createRequestObject(sbcMediaType, enumOrdinal);
            if (writePoint == null) {
                return false;
            }
            this.createSendRequestMessage(device, writePoint);
        }
        return false;
    }

    private void createSendRequestMessage(BSbcDevice device, ISbcMessage writePoint) {
        block4: {
            BIpAddress ipAddress = device.getIpAddress();
            int nextSeqNo = this.getSbcIpDriverNetwork().getSequenceNumber();
            SbcRequestMessage writeReqMsg = new SbcRequestMessage(device.getStationId(), nextSeqNo);
            writeReqMsg.setAddress((BAddress)ipAddress);
            writeReqMsg.appendPayload(writePoint.getPayload());
            if (SbcUtil.sbcPointWrite.isLoggable(Level.FINER)) {
                SbcUtil.sbcPointWrite.log(Level.FINER, String.format("Sending write request of Memory Address: %s and Station Id: %d", this.getMemoryAddress(), device.getStationId()));
            }
            BSbcUdpCommConfig commConfig = this.getSbcIpDriverNetwork().getUdpConfig();
            try {
                ((NComm)commConfig.comm()).sendRequest((NMessage)writeReqMsg);
                this.writeOk(this.getWriteValue());
                if (SbcUtil.sbcPointWrite.isLoggable(Level.FINER)) {
                    SbcUtil.sbcPointWrite.log(Level.FINER, String.format("Completed write request of Memory Address: %s and Station Id: %d", this.getMemoryAddress(), device.getStationId()));
                }
            }
            catch (Exception exp) {
                this.writeFail(exp.getMessage());
                if (!SbcUtil.sbcPointWrite.isLoggable(Level.FINER)) break block4;
                SbcUtil.sbcPointWrite.log(Level.FINER, " Something went wrong while sending write request ", exp);
            }
        }
    }

    private ISbcMessage createRequestObject(BSbcMediaTypeEnum sbcMediaType, int enumOrdinal) {
        ISbcMessage writePoint;
        switch (sbcMediaType.getOrdinal()) {
            case 2: {
                writePoint = this.writeRegister(enumOrdinal);
                break;
            }
            case 3: {
                writePoint = this.writeRegisterFloat(enumOrdinal);
                break;
            }
            case 9: {
                writePoint = this.writeDBRAM(enumOrdinal);
                break;
            }
            case 7: {
                writePoint = this.writeCounter();
                break;
            }
            case 6: {
                writePoint = this.writeTimer();
                break;
            }
            default: {
                writePoint = this.writeOthers(sbcMediaType);
                if (!SbcUtil.log_driver.isLoggable(Level.INFO)) break;
                SbcUtil.log_driver.log(Level.INFO, " Media type: " + (Object)((Object)sbcMediaType) + " type is not matched");
            }
        }
        return writePoint;
    }

    private ISbcMessage writeOthers(BSbcMediaTypeEnum sbcMediaType) {
        WriteBinary writePoint = null;
        switch (sbcMediaType.getOrdinal()) {
            case 5: {
                writePoint = this.writeOutputOrFlagAndFlagVolatile(13);
                break;
            }
            case 0: 
            case 1: {
                writePoint = this.writeOutputOrFlagAndFlagVolatile(11);
                break;
            }
            default: {
                if (!SbcUtil.log_driver.isLoggable(Level.INFO)) break;
                SbcUtil.log_driver.log(Level.INFO, " Media type: " + sbcMediaType.getTag() + " type is not matched");
            }
        }
        return writePoint;
    }

    private void sendWriteTextRequests(BSbcDevice sbcDevice) {
        String enteredText = ((BStatusString)this.getWriteValue()).getValue();
        int length = sbcDevice.getTextSizeOfPoint(this.getMemoryAddress());
        if (enteredText.getBytes(Charset.defaultCharset()).length > length) {
            if (SbcUtil.log_driver.isLoggable(Level.INFO)) {
                SbcUtil.log_driver.log(Level.INFO, "**** Text Entered is too long for memory address :: " + this.getMemoryAddress());
            }
            this.writeFail("Text entered is too long");
            this.setStatus(BStatus.ok);
            this.readOk(this.getReadValue());
            return;
        }
        int blanksCount = length - enteredText.getBytes(Charset.defaultCharset()).length;
        StringBuilder w = new StringBuilder(enteredText);
        for (int i = 0; i < blanksCount; ++i) {
            w.append("\u0000");
        }
        String writableText = w.toString();
        try {
            int noOfReq = length / 16;
            int charCountForLast = length % 16;
            if (charCountForLast != 0) {
                ++noOfReq;
            }
            int toIndex = 0;
            int position = 0;
            byte[] writableBytes = writableText.getBytes("UTF-8");
            for (int i = 0; i < noOfReq; ++i) {
                int fromIndex = toIndex;
                WriteText writeText = i == noOfReq - 1 && charCountForLast > 0 ? new WriteText(charCountForLast + 3, Integer.parseInt(this.getMemoryAddress()), position, Arrays.copyOfRange(writableBytes, fromIndex, toIndex += charCountForLast)) : new WriteText(19, Integer.parseInt(this.getMemoryAddress()), position, Arrays.copyOfRange(writableBytes, fromIndex, toIndex += 16));
                int nextSeqNo = this.getSbcIpDriverNetwork().getSequenceNumber();
                SbcRequestMessage writeTextReqMsg = new SbcRequestMessage(sbcDevice.getStationId(), nextSeqNo);
                writeTextReqMsg.setAddress((BAddress)sbcDevice.getIpAddress());
                if (writeText != null) {
                    writeTextReqMsg.appendPayload(writeText.getPayload());
                }
                position += 16;
                BSbcUdpCommConfig commConfig = this.getSbcIpDriverNetwork().getUdpConfig();
                ((NComm)commConfig.comm()).sendRequest((NMessage)writeTextReqMsg);
                this.writeOk(this.getWriteValue());
            }
        }
        catch (Exception e) {
            this.writeFail(e.getMessage());
            SbcUtil.log_driver.log(Level.SEVERE, " Something went wrong while sending write request for TEXT RAM\n", e);
        }
    }

    private byte[] getConvertedValue(int enumOrdinal, double input) {
        switch (enumOrdinal) {
            case 2: {
                return SbcByteConverter.convertUnSignedIntToByteArray((int)input);
            }
            case 4: {
                return SbcByteConverter.convertIEEEFloatToByteArray((float)input);
            }
            case 3: {
                return SbcByteConverter.convertMffpToByteArray((float)input);
            }
        }
        return SbcByteConverter.convertSignedIntToByteArray((int)input);
    }

    private byte[] getConvertedValueForRegFloat(int enumOrdinal, double input) {
        switch (enumOrdinal) {
            case 1: {
                return SbcByteConverter.convertMffpToByteArray((float)input);
            }
            case 2: {
                return SbcByteConverter.convertIEEEFloatToByteArray((float)input);
            }
        }
        return SbcByteConverter.convertIEEEFloatToByteArray((int)input);
    }

    public Type getDeviceExtType() {
        return BSbcPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readWrite;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(dataFormat)) {
            this.setWriteRequired(false);
            int convertTo = ((BFrozenEnum)this.get(property)).getOrdinal();
            this.createAndSendRequest(this.getParentPoint(), convertTo);
        } else if (property.equals(memoryAddress)) {
            this.textMediaReadReq();
        }
    }

    private void textMediaReadReq() {
        BSbcMediaTypeEnum mediaTypeEnum = (BSbcMediaTypeEnum)this.getParentPoint().get("mediaType");
        if (mediaTypeEnum != null && mediaTypeEnum.getOrdinal() == 10) {
            try {
                BSbcDevice device = (BSbcDevice)this.getDevice();
                device.pollTextPointSize(this.getParentPoint());
            }
            catch (Exception e) {
                SbcUtil.log_driver.log(Level.SEVERE, "Failed to update text value on memory address change ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndSendRequest(BControlPoint controlPoint, int convertTo) {
        try {
            BSbcMediaTypeEnum mediaTypeEnum = (BSbcMediaTypeEnum)controlPoint.get("mediaType");
            if (mediaTypeEnum.getOrdinal() == 2) {
                this.createReadRegisterReq(convertTo);
            }
        }
        finally {
            this.setWriteRequired(true);
        }
    }

    private void createReadRegisterReq(int convertTo) {
        if (this.isRunning()) {
            BSbcDevice sbcDevice = (BSbcDevice)this.getDevice();
            if (SbcUtil.log_driver.isLoggable(Level.INFO)) {
                SbcUtil.log_driver.log(Level.INFO, " Read Register for point :: " + this.getParentPoint().getDisplayName(null));
            }
            int nextSeqNo = this.getSbcIpDriverNetwork().getSequenceNumber();
            SbcRequestMessage requestMessage = new SbcRequestMessage(sbcDevice.getStationId(), nextSeqNo);
            requestMessage.setResponseTimeOut(sbcDevice.getReadTimeout());
            ReadRegister readReg = new ReadRegister(Integer.parseInt(this.getMemoryAddress()));
            requestMessage.appendPayload(readReg.getPayload());
            requestMessage.setAddress((BAddress)sbcDevice.getIpAddress());
            try {
                if (SbcUtil.log_driver.isLoggable(Level.INFO)) {
                    SbcUtil.log_driver.log(Level.INFO, " ****** Device Name of control Point **** " + this.getDevice().getDisplayName(null));
                }
                BSbcNetwork driverNetwork = ((BSbcDevice)this.getDevice()).getSbcIpDriverNetwork();
                NComm comm = (NComm)driverNetwork.getUdpConfig().comm();
                SbcResponseMessage msg = (SbcResponseMessage)comm.sendRequest((NMessage)requestMessage);
                byte[] respMsg = msg.getResponsePayload();
                byte[] value = Arrays.copyOfRange(respMsg, 9, 13);
                this.readOk((BStatusValue)new BStatusNumeric(this.convertOnSelection(convertTo, value), BStatus.ok));
            }
            catch (Exception e) {
                SbcUtil.log_driver.log(Level.SEVERE, " Something went wrong while polling all the points available in subscription list", e);
            }
        } else {
            SbcUtil.log_driver.log(Level.SEVERE, " Device is not in running state....");
        }
    }

    private double convertOnSelection(int value, byte[] b) throws ConversionException {
        switch (value) {
            case 2: {
                return SbcByteConverter.convertByteArrayToUnSignedInt(b);
            }
            case 4: {
                return SbcByteConverter.convertByteArrayToIEEEFloat(b);
            }
            case 3: {
                return SbcByteConverter.convertByteArrayToMffp(b);
            }
        }
        return SbcByteConverter.convertByteArrayToSignedInt(b);
    }

    public void pointFacetsChanged() {
    }

    public void writeOk(BStatusValue writeValue) {
        super.writeOk(writeValue);
        this.readOk(writeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriteRegister writeRegister(int enumOrdinal) {
        WriteRegister writePoint = null;
        try {
            if (this.getWriteRequired()) {
                double v = ((BStatusNumeric)this.getWriteValue()).getValue();
                byte[] value = this.getConvertedValue(enumOrdinal, v);
                if (SbcUtil.sbcPointWrite.isLoggable(Level.FINEST)) {
                    SbcUtil.sbcPointWrite.log(Level.FINEST, String.format("Creating register request with value:%s", new Object[]{value}));
                }
                writePoint = enumOrdinal == 3 ? new WriteRegister(Integer.parseInt(this.getMemoryAddress()), value, enumOrdinal) : new WriteRegister(Integer.parseInt(this.getMemoryAddress()), v, enumOrdinal);
            } else {
                this.setWriteRequired(true);
            }
        }
        catch (Exception exp) {
            if (SbcUtil.sbcPointWrite.isLoggable(Level.FINER)) {
                SbcUtil.sbcPointWrite.log(Level.FINER, "Unable to create valid register request.", exp);
            }
        }
        finally {
            this.setWriteRequired(true);
        }
        return writePoint;
    }

    private WriteRegisterFloat writeRegisterFloat(int enumOrdinal) {
        WriteRegisterFloat writePoint;
        block3: {
            writePoint = null;
            try {
                double mffpValue = ((BStatusNumeric)this.getWriteValue()).getValue();
                byte[] bytesValue = this.getConvertedValueForRegFloat(enumOrdinal, mffpValue);
                if (SbcUtil.sbcPointWrite.isLoggable(Level.FINEST)) {
                    SbcUtil.sbcPointWrite.log(Level.FINEST, String.format("Creating register float request with value:%s", new Object[]{bytesValue}));
                }
                writePoint = enumOrdinal == 1 ? new WriteRegisterFloat(Integer.parseInt(this.getMemoryAddress()), bytesValue, enumOrdinal) : new WriteRegisterFloat(Integer.parseInt(this.getMemoryAddress()), mffpValue, enumOrdinal);
            }
            catch (Exception exp) {
                if (!SbcUtil.sbcPointWrite.isLoggable(Level.FINER)) break block3;
                SbcUtil.sbcPointWrite.log(Level.FINER, "Unable to create valid register float request.", exp);
            }
        }
        return writePoint;
    }

    private WriteBinary writeOutputOrFlagAndFlagVolatile(int type) {
        WriteBinary writePoint;
        block3: {
            writePoint = null;
            try {
                int value;
                int n = value = ((BStatusBoolean)this.getWriteValue()).getValue() ? 1 : 0;
                if (SbcUtil.sbcPointWrite.isLoggable(Level.FINEST)) {
                    SbcUtil.sbcPointWrite.log(Level.FINEST, String.format("Creating %s request with value:%s", this.getPointType(type), value));
                }
                writePoint = new WriteBinary(Integer.parseInt(this.getMemoryAddress()), value, type);
            }
            catch (Exception exp) {
                if (!SbcUtil.sbcPointWrite.isLoggable(Level.FINER)) break block3;
                SbcUtil.sbcPointWrite.log(Level.FINER, String.format("Unable to create valid %s request.", this.getPointType(type)), exp);
            }
        }
        return writePoint;
    }

    private WriteDbRam writeDBRAM(int enumOrdinal) {
        WriteDbRam writePoint;
        block5: {
            writePoint = null;
            try {
                double dbElemVal = ((BStatusNumeric)this.getWriteValue()).getValue();
                BString dbElemIndex = (BString)this.getParentPoint().get("dbElement");
                if (SbcUtil.sbcPointWrite.isLoggable(Level.FINEST)) {
                    SbcUtil.sbcPointWrite.log(Level.FINEST, String.format("Creating DB RAM request with value:%s - %s", dbElemVal, dbElemIndex));
                }
                if (enumOrdinal == 3) {
                    byte[] floatValue = this.getConvertedValue(enumOrdinal, dbElemVal);
                    writePoint = new WriteDbRam(Integer.parseInt(this.getMemoryAddress()), floatValue, enumOrdinal, dbElemIndex.getString());
                } else {
                    writePoint = new WriteDbRam(Integer.parseInt(this.getMemoryAddress()), dbElemVal, enumOrdinal, dbElemIndex.getString());
                }
            }
            catch (Exception exp) {
                if (!SbcUtil.sbcPointWrite.isLoggable(Level.FINER)) break block5;
                SbcUtil.sbcPointWrite.log(Level.FINER, "Unable to create valid timer request.", exp);
            }
        }
        return writePoint;
    }

    private WriteCounter writeCounter() {
        WriteCounter writePoint;
        block6: {
            writePoint = null;
            try {
                double counterValue = ((BStatusNumeric)this.getWriteValue()).getValue();
                if (SbcUtil.isValidPositiveInteger(counterValue)) {
                    if (SbcUtil.sbcPointWrite.isLoggable(Level.FINEST)) {
                        SbcUtil.sbcPointWrite.log(Level.FINEST, String.format("Creating counter request with value:%s", counterValue));
                    }
                    writePoint = new WriteCounter(Integer.parseInt(this.getMemoryAddress()), (int)counterValue);
                } else {
                    if (SbcUtil.sbcPointWrite.isLoggable(Level.FINEST)) {
                        SbcUtil.sbcPointWrite.log(Level.FINEST, String.format("Invalid counter input: %s", counterValue));
                    }
                    this.writeFail("Invalid Input");
                    this.setStatus(BStatus.ok);
                    this.readOk(this.getReadValue());
                }
            }
            catch (Exception exp) {
                if (!SbcUtil.sbcPointWrite.isLoggable(Level.FINER)) break block6;
                SbcUtil.sbcPointWrite.log(Level.FINER, "Unable to create valid counter request.", exp);
            }
        }
        return writePoint;
    }

    private WriteTimer writeTimer() {
        WriteTimer writePoint;
        block6: {
            writePoint = null;
            try {
                double timerValue = ((BStatusNumeric)this.getWriteValue()).getValue();
                if (SbcUtil.isValidPositiveInteger(timerValue)) {
                    if (SbcUtil.sbcPointWrite.isLoggable(Level.FINEST)) {
                        SbcUtil.sbcPointWrite.log(Level.FINEST, String.format("Creating timer request with value:%s", timerValue));
                    }
                    writePoint = new WriteTimer(Integer.parseInt(this.getMemoryAddress()), (int)timerValue);
                } else {
                    if (SbcUtil.sbcPointWrite.isLoggable(Level.FINEST)) {
                        SbcUtil.sbcPointWrite.log(Level.FINEST, String.format("Invalid timer input: %s", timerValue));
                    }
                    this.writeFail("Invalid Input");
                    this.setStatus(BStatus.ok);
                    this.readOk(this.getReadValue());
                }
            }
            catch (Exception exp) {
                if (!SbcUtil.sbcPointWrite.isLoggable(Level.FINER)) break block6;
                SbcUtil.sbcPointWrite.log(Level.FINER, "Unable to create valid timer request.", exp);
            }
        }
        return writePoint;
    }

    private String getPointType(int input) {
        String output = "flag/flag volatile";
        if (input == 13) {
            output = "output";
        }
        return output;
    }

    private void findAndLinkAssociatedLog() {
        BSbcHDLog[] sbcHDLogs;
        BSbcDevice device = this.getBSbcIpDriverDevice();
        BSbcHDLogs deviceHistories = device.getHistories();
        BControlPoint sbcPoint = this.getParentPoint();
        for (BSbcHDLog sbcHDLog : sbcHDLogs = (BSbcHDLog[])deviceHistories.getChildren(BSbcHDLog.class)) {
            String[] points;
            String associatedPoints = sbcHDLog.get("associatedPoints").toString();
            if (associatedPoints == null || !this.linkAssociatedLog(points = associatedPoints.split(";"), device)) continue;
            return;
        }
        if (sbcPoint.get("linkedLogLocation") != null) {
            sbcPoint.set("linkedLogLocation", (BValue)BOrd.NULL);
        } else {
            sbcPoint.add("linkedLogLocation", (BValue)BOrd.NULL, 5);
        }
    }

    public boolean linkAssociatedLog(String[] points, BSbcDevice device) {
        BControlPoint sbcPoint = this.getParentPoint();
        for (String point : points) {
            if (!point.equals(sbcPoint.getName())) continue;
            String sbcHDPath = "history:/" + Sys.getStation().getStationName() + "/" + SlotPath.escape((String)(device.getDisplayName(null) + "." + point));
            if (sbcPoint.get("linkedLogLocation") != null) {
                sbcPoint.set("linkedLogLocation", (BValue)BOrd.make((String)sbcHDPath));
            } else {
                sbcPoint.add("linkedLogLocation", (BValue)BOrd.make((String)sbcHDPath), 5);
            }
            return true;
        }
        return false;
    }

    public boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    public boolean isNumeric() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusNumeric;
    }

    public boolean isString() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusString;
    }

    public boolean isEnum() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusEnum;
    }
}

