/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.point;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BSbcLinearConversion
extends BProxyConversion {
    private Double scale;
    private Double offset;
    private int hashCode = -1;
    private static final int SEMICOLON_INDEX = 59;
    public static final BSbcLinearConversion DEFAULT = new BSbcLinearConversion(1.0, 0.0);
    public static final Type TYPE = Sys.loadType(BSbcLinearConversion.class);

    private BSbcLinearConversion(Double scale, Double offset) {
        this.scale = scale;
        this.offset = offset;
    }

    public Type getType() {
        return TYPE;
    }

    public Double getScale() {
        return this.scale;
    }

    public Double getOffset() {
        return this.offset;
    }

    public static BSbcLinearConversion make(Double scale, Double offset) {
        if (BigDecimal.valueOf(scale).equals(BigDecimal.valueOf(1.0)) && BigDecimal.valueOf(offset).equals(BigDecimal.valueOf(0.0))) {
            return DEFAULT;
        }
        return (BSbcLinearConversion)new BSbcLinearConversion(scale, offset).intern();
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            long hash = 23L + Double.doubleToRawLongBits(this.offset);
            hash = hash * 37L + Double.doubleToRawLongBits(this.scale);
            this.hashCode = (int)(hash >>> 32) ^ (int)hash;
        }
        return this.hashCode;
    }

    public void convertDeviceToProxy(BProxyExt ext, BStatusValue deviceValue, BStatusValue proxyValue) throws Exception {
        if (deviceValue instanceof BStatusNumeric) {
            this.convert((BStatusNumeric)deviceValue, (BStatusNumeric)proxyValue, true);
        } else {
            proxyValue.copyFrom((BComplex)deviceValue);
        }
    }

    public void convertProxyToDevice(BProxyExt ext, BStatusValue proxyValue, BStatusValue deviceValue) throws Exception {
        if (proxyValue instanceof BStatusNumeric) {
            this.convert((BStatusNumeric)proxyValue, (BStatusNumeric)deviceValue, false);
        } else {
            deviceValue.copyFrom((BComplex)proxyValue);
        }
    }

    private void convert(BStatusNumeric from, BStatusNumeric to, boolean deviceToProxy) {
        Double fromValue = from.getValue();
        BigDecimal toValue = deviceToProxy ? BigDecimal.valueOf(fromValue).multiply(BigDecimal.valueOf(this.scale)).add(BigDecimal.valueOf(this.offset)) : BigDecimal.valueOf(fromValue).subtract(BigDecimal.valueOf(this.offset)).divide(BigDecimal.valueOf(this.scale));
        to.setStatus(from.getStatus());
        to.setValue(toValue.doubleValue());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BSbcLinearConversion)) {
            return false;
        }
        BSbcLinearConversion x = (BSbcLinearConversion)((Object)obj);
        return BigDecimal.valueOf(this.scale).equals(BigDecimal.valueOf(x.scale)) && BigDecimal.valueOf(this.offset).equals(BigDecimal.valueOf(x.offset));
    }

    public String toString(Context context) {
        StringBuilder s = new StringBuilder();
        s.append(TYPE.getDisplayName(context));
        if (!BigDecimal.valueOf(this.scale).equals(BigDecimal.valueOf(1.0))) {
            s.append(" *").append(BDouble.toString((double)this.scale, (Context)context));
        }
        if (this.offset < 0.0) {
            s.append(' ').append(BDouble.toString((double)this.offset, (Context)context));
        } else if (this.offset > 0.0) {
            s.append(" +").append(BDouble.toString((double)this.offset, (Context)context));
        }
        return s.toString();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeDouble(this.scale);
        out.writeDouble(this.offset);
    }

    public BObject decode(DataInput in) throws IOException {
        return BSbcLinearConversion.make(in.readDouble(), in.readDouble());
    }

    public String encodeToString() {
        return BDouble.encode((double)this.scale) + ";" + BDouble.encode((double)this.offset);
    }

    public BObject decodeFromString(String s) throws IOException {
        int semi = s.indexOf(59);
        return BSbcLinearConversion.make(BDouble.decode((String)s.substring(0, semi)), BDouble.decode((String)s.substring(semi + 1)));
    }
}

