/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.point;

import com.honeywell.sbc.BSbcDevice;
import com.honeywell.sbc.bean.BSbcDbBean;
import com.honeywell.sbc.util.SbcUtil;
import java.util.List;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="forceRead", flags=4)
@NiagaraProperties(value={@NiagaraProperty(name="BlockDetails", type="BSbcDbBean", defaultValue="new BSbcDbBean()", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"sbc:SbcDbFE\")")}), @NiagaraProperty(name="comments", type="String", defaultValue="")})
public class BSbcDbRam
extends BComponent {
    public static final Property BlockDetails = BSbcDbRam.newProperty((int)0, (BValue)new BSbcDbBean(), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"sbc:SbcDbFE")));
    public static final Property comments = BSbcDbRam.newProperty((int)0, (String)"", null);
    public static final Action forceRead = BSbcDbRam.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BSbcDbRam.class);
    private BSbcDevice device = null;

    public BSbcDbBean getBlockDetails() {
        return (BSbcDbBean)this.get(BlockDetails);
    }

    public void setBlockDetails(BSbcDbBean v) {
        this.set(BlockDetails, (BValue)v, null);
    }

    public String getComments() {
        return this.getString(comments);
    }

    public void setComments(String v) {
        this.setString(comments, v, null);
    }

    public void forceRead() {
        this.invoke(forceRead, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doForceRead() {
        block5: {
            try {
                if (this.device == null) {
                    this.device = (BSbcDevice)SbcUtil.getParentDevice(this);
                }
                if (this.device.getStatus().isOk()) {
                    int dataBlockSize = SbcUtil.getDataBlockSize(this.getBlockDetails().getMemoryAddress(), this.device);
                    this.getBlockDetails().setDbElemSize(Integer.toString(dataBlockSize));
                } else {
                    SbcUtil.log_driver.log(Level.WARNING, "Device is offline. Could not fetch the DB Block Size from PCD");
                }
                List<Integer> dbElemList = SbcUtil.getDbElemToAdd(this.getBlockDetails());
                SbcUtil.addDbElements(dbElemList, this);
                SbcUtil.removeUnwantedElements(dbElemList, this);
            }
            catch (Exception e) {
                if (!SbcUtil.log_driver.isLoggable(Level.FINER)) break block5;
                SbcUtil.log_driver.log(Level.FINER, "Error while doing force read of db ram.", e);
            }
        }
    }
}

