/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.point;

import com.honeywell.sbc.BSbcDevice;
import com.honeywell.sbc.bean.BSbcDbBean;
import com.honeywell.sbc.message.SbcRequestMessage;
import com.honeywell.sbc.message.SbcResponseMessage;
import com.honeywell.sbc.message.commands.ReadDbElement;
import com.honeywell.sbc.point.BSbcProxyExt;
import com.honeywell.sbc.util.SbcByteConverter;
import com.honeywell.sbc.util.SbcUtil;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="forceRead", flags=20), @NiagaraAction(name="fetchValues", flags=20)})
@NiagaraProperties(value={@NiagaraProperty(name="BlockDetails", type="BSbcDbBean", defaultValue="new BSbcDbBean()", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"sbc:SbcDbFE\")")}), @NiagaraProperty(name="comments", type="String", defaultValue="")})
public class BSbcDb
extends BComponent {
    public static final Property BlockDetails = BSbcDb.newProperty((int)0, (BValue)new BSbcDbBean(), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"sbc:SbcDbFE")));
    public static final Property comments = BSbcDb.newProperty((int)0, (String)"", null);
    public static final Action forceRead = BSbcDb.newAction((int)20, null);
    public static final Action fetchValues = BSbcDb.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BSbcDb.class);
    private BSbcDevice device = null;

    public BSbcDbBean getBlockDetails() {
        return (BSbcDbBean)this.get(BlockDetails);
    }

    public void setBlockDetails(BSbcDbBean v) {
        this.set(BlockDetails, (BValue)v, null);
    }

    public String getComments() {
        return this.getString(comments);
    }

    public void setComments(String v) {
        this.setString(comments, v, null);
    }

    public void forceRead() {
        this.invoke(forceRead, null, null);
    }

    public void fetchValues() {
        this.invoke(fetchValues, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doForceRead() {
        block7: {
            try {
                if (this.device == null) {
                    this.device = (BSbcDevice)SbcUtil.getParentDevice(this);
                }
                if (this.device.getStatus().isOk()) {
                    int dataBlockSize = SbcUtil.getDataBlockSize(this.getBlockDetails().getMemoryAddress(), this.device);
                    this.getBlockDetails().setDbElemSize(Integer.toString(dataBlockSize));
                } else {
                    SbcUtil.log_driver.log(Level.WARNING, "Device is offline. Could not fetch the DB Block Size from PCD");
                }
                List<Integer> dbElemList = SbcUtil.getDbElemToAdd(this.getBlockDetails());
                SbcUtil.addDbElements(dbElemList, this);
                SbcUtil.removeUnwantedElements(dbElemList, this);
                if (this.device.getStatus().isOk()) {
                    this.fetchDbElementDataFromPcd();
                } else {
                    SbcUtil.log_driver.log(Level.FINER, "Device is offline. Could not fetch db element data from PCD");
                }
            }
            catch (Exception e) {
                if (!SbcUtil.log_driver.isLoggable(Level.FINER)) break block7;
                SbcUtil.log_driver.log(Level.FINER, "Error while doing force read of db", e);
            }
        }
    }

    public void doFetchValues() {
        block2: {
            try {
                this.fetchDbElementDataFromPcd();
            }
            catch (Exception e) {
                if (!SbcUtil.log_driver.isLoggable(Level.FINER)) break block2;
                SbcUtil.log_driver.log(Level.FINER, "Error while fetching db elements", e);
            }
        }
    }

    private void fetchDbElementDataFromPcd() throws Exception {
        BComponent[] childArray = this.getChildComponents();
        if (this.device == null) {
            this.device = (BSbcDevice)SbcUtil.getParentDevice(this);
        }
        String memoryAddress = this.getBlockDetails().getMemoryAddress();
        for (BComponent child : childArray) {
            BControlPoint dBElem = (BControlPoint)child;
            BString dbElemIndex = (BString)dBElem.get("dbElement");
            BSbcProxyExt sbcDriverProxyExt = (BSbcProxyExt)dBElem.getProxyExt();
            sbcDriverProxyExt.setMemoryAddress(memoryAddress);
            int dataFormat = sbcDriverProxyExt.getDataFormat().getOrdinal();
            ReadDbElement readDbRamCommand = new ReadDbElement(Integer.parseInt(memoryAddress), 0, Integer.parseInt(dbElemIndex.getString()));
            int nextSeqNo = this.device.getSbcIpDriverNetwork().getSequenceNumber();
            SbcRequestMessage requestMessage = new SbcRequestMessage(this.device.getStationId(), nextSeqNo);
            requestMessage.setResponseTimeOut(this.device.getReadTimeout());
            requestMessage.appendPayload(readDbRamCommand.getPayload());
            requestMessage.setAddress((BAddress)this.device.getIpAddress());
            NComm comm = (NComm)this.device.getSbcIpDriverNetwork().getUdpConfig().comm();
            SbcResponseMessage msg = (SbcResponseMessage)comm.sendRequest((NMessage)requestMessage);
            byte[] respMsg = msg.getResponsePayload();
            byte[] value = Arrays.copyOfRange(respMsg, 9, 13);
            sbcDriverProxyExt.readOk((BStatusValue)new BStatusNumeric(SbcByteConverter.convertToAppropriateValue(dataFormat, value), BStatus.ok));
        }
    }
}

