/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.message.commands;

import com.honeywell.sbc.message.ISbcMessage;
import com.honeywell.sbc.util.SbcUtil;
import com.tridium.ndriver.io.TypedOutputStream;
import java.io.IOException;
import java.util.logging.Level;

public class WriteRegister
implements ISbcMessage {
    private int baseAddress;
    private int dataFormat;
    private double data;
    private byte[] conData;
    private byte[] payload;

    public WriteRegister(int baseAddress, double data, int dataFormat) {
        this.baseAddress = baseAddress;
        this.dataFormat = dataFormat;
        this.data = data;
    }

    public WriteRegister(int baseAddress, byte[] bytes, int dataFormat) {
        this.baseAddress = baseAddress;
        this.dataFormat = dataFormat;
        this.conData = (byte[])bytes.clone();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getPayload() {
        try (TypedOutputStream tos = new TypedOutputStream();){
            tos.writeUnsigned8(14);
            tos.writeUnsigned8(5);
            tos.writeUnsigned16(this.baseAddress);
            switch (this.dataFormat) {
                case 4: {
                    tos.writeFloat((float)this.data);
                    break;
                }
                case 3: {
                    tos.write(this.conData);
                    break;
                }
                default: {
                    tos.writeUnsigned32((long)((int)this.data));
                }
            }
            byte[] byArray = tos.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            if (!SbcUtil.log_driver.isLoggable(Level.FINER)) return new byte[0];
            SbcUtil.log_driver.log(Level.FINER, "Unexpected error while preparing payload of Write Register.", ioe);
            return new byte[0];
        }
    }

    @Override
    public void appendPayload(byte[] data) {
        this.payload = (byte[])data.clone();
        if (SbcUtil.log_driver.isLoggable(Level.FINEST)) {
            SbcUtil.log_driver.log(Level.FINEST, "Pay Load of the request:" + this.payload);
        }
    }
}

