/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.message.commands;

import com.honeywell.sbc.message.ISbcMessage;
import com.honeywell.sbc.util.SbcUtil;
import com.tridium.ndriver.io.TypedOutputStream;
import java.io.IOException;
import java.util.logging.Level;

public class WriteDbRam
implements ISbcMessage {
    private final int baseAddress;
    private double data;
    private byte[] conData;
    private int dbElement;
    private int dataFormat;
    private byte[] payload;

    public WriteDbRam(int baseAddress, double data, int dataFormat, String dbElement) {
        this.baseAddress = baseAddress;
        this.data = data;
        this.dataFormat = dataFormat;
        this.dbElement = Integer.parseInt(dbElement);
    }

    public WriteDbRam(int baseAddress, byte[] floatValue, int dataFormat, String dbElement) {
        this.baseAddress = baseAddress;
        this.conData = (byte[])floatValue.clone();
        this.dataFormat = dataFormat;
        this.dbElement = Integer.parseInt(dbElement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getPayload() {
        try (TypedOutputStream tos = new TypedOutputStream();){
            tos.writeUnsigned8(151);
            tos.writeUnsigned8(7);
            tos.writeUnsigned16(this.baseAddress);
            tos.writeUnsigned16(this.dbElement);
            switch (this.dataFormat) {
                case 4: {
                    tos.writeFloat((float)this.data);
                    break;
                }
                case 3: {
                    tos.write(this.conData);
                    break;
                }
                default: {
                    tos.writeUnsigned32((long)((int)this.data));
                }
            }
            byte[] byArray = tos.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            if (!SbcUtil.log_driver.isLoggable(Level.FINER)) return new byte[0];
            SbcUtil.log_driver.log(Level.FINER, "Unexpected error while preparing payload of Write Db Ram.", ioe);
            return new byte[0];
        }
    }

    @Override
    public void appendPayload(byte[] data) {
        this.payload = (byte[])data.clone();
        if (SbcUtil.log_driver.isLoggable(Level.FINEST)) {
            SbcUtil.log_driver.log(Level.FINEST, "Pay Load of the request:" + this.payload);
        }
    }
}

