/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.message.commands;

import com.honeywell.sbc.message.ISbcMessage;
import com.honeywell.sbc.util.SbcUtil;
import com.tridium.ndriver.io.TypedOutputStream;
import java.io.IOException;
import java.util.logging.Level;

public class WriteCounter
implements ISbcMessage {
    private final int baseAddress;
    private final int data;
    private byte[] payload;

    public WriteCounter(int baseAddress, int data) {
        this.baseAddress = baseAddress;
        this.data = data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getPayload() {
        try (TypedOutputStream tos = new TypedOutputStream();){
            tos.writeUnsigned8(10);
            tos.writeUnsigned8(5);
            tos.writeUnsigned16(this.baseAddress);
            tos.writeUnsigned32((long)this.data);
            byte[] byArray = tos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            SbcUtil.log_driver.log(Level.SEVERE, "Unable to close Typed Output Stream", e);
            return new byte[0];
        }
    }

    @Override
    public void appendPayload(byte[] data) {
        this.payload = (byte[])data.clone();
        if (SbcUtil.log_driver.isLoggable(Level.FINEST)) {
            SbcUtil.log_driver.log(Level.FINEST, "Pay Load of the request:" + this.payload);
        }
    }
}

