/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.message.commands;

import com.honeywell.sbc.message.ISbcMessage;
import com.honeywell.sbc.util.SbcUtil;
import com.tridium.ndriver.io.TypedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class Multimedia
implements ISbcMessage {
    private List<byte[]> subRequestList;

    public Multimedia(List<byte[]> subRequestList) {
        this.subRequestList = new ArrayList<byte[]>(subRequestList);
    }

    @Override
    public byte[] getPayload() {
        TypedOutputStream tos = new TypedOutputStream();
        try {
            byte[] completeSubReqPayload = this.prepareMultiMediaSubRequestPayload();
            int wCount = completeSubReqPayload.length - 1;
            tos.writeUnsigned8(19);
            tos.writeUnsigned8(wCount);
            tos.write(completeSubReqPayload);
        }
        catch (IOException ioe) {
            SbcUtil.log_driver.log(Level.SEVERE, "IO Error while creating Multimedia message payload", ioe);
        }
        catch (Exception e) {
            SbcUtil.log_driver.log(Level.SEVERE, "Error while creating Multimedia message payload", e);
        }
        return tos.toByteArray();
    }

    private byte[] prepareMultiMediaSubRequestPayload() {
        TypedOutputStream completeSubRequestPayload = new TypedOutputStream();
        for (byte[] payLoad : this.subRequestList) {
            int wCountOfSubRequest = payLoad.length - 1;
            completeSubRequestPayload.writeUnsigned8(wCountOfSubRequest);
            completeSubRequestPayload.writeByteArray(payLoad);
        }
        return completeSubRequestPayload.toByteArray();
    }

    @Override
    public void appendPayload(byte[] data) {
    }
}

