/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.message;

import com.honeywell.sbc.BSbcNetwork;
import com.honeywell.sbc.comm.BSbcUdpCommConfig;
import com.honeywell.sbc.util.SbcUtil;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.io.TypedInputStream;
import java.util.Arrays;

public class SbcResponseMessage
extends NMessage {
    private byte[] responsePayload = null;
    private int seqNo = -1;
    private BSbcNetwork sbcNetwork = null;

    public SbcResponseMessage(TypedInputStream tis, BSbcUdpCommConfig commConfig) {
        this.responsePayload = SbcUtil.trim(tis.readByteArray());
        this.sbcNetwork = commConfig.getNetwork();
    }

    public byte[] getResponsePayload() {
        return (byte[])this.responsePayload.clone();
    }

    public boolean isResponse() {
        return !this.sbcNetwork.getTags().containsKey(this.getTag());
    }

    public String toTraceString() {
        return "SbcPacketTraceMessage";
    }

    public void setTag(byte[] trimmedRespMsg) {
        byte[] respMsg = (byte[])trimmedRespMsg.clone();
        if (respMsg.length >= 8) {
            byte[] seqBytes = Arrays.copyOfRange(trimmedRespMsg, 6, 8);
            this.seqNo = SbcUtil.byteArrayToInt(seqBytes);
        }
    }

    public Object getTag() {
        return this.seqNo;
    }

    public int validateResponse(NMessage msg) throws Exception {
        return 2;
    }
}

