/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.message;

import com.honeywell.sbc.message.ISbcMessage;
import com.honeywell.sbc.util.CyclicRedundancyCheck;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.io.TypedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class SbcRequestMessage
extends NMessage
implements ISbcMessage {
    private static final int FIXED_BYTES = 12;
    private byte[] payload;
    private int stationId = -1;
    private int seqNo = -1;

    public SbcRequestMessage(int stnId, int seqNo) {
        this.stationId = stnId;
        this.seqNo = seqNo;
    }

    public boolean toOutputStream(OutputStream out) throws Exception {
        TypedOutputStream tos = new TypedOutputStream();
        int payLoad = 12 + this.payload.length;
        tos.writeUnsigned32((long)payLoad);
        tos.writeUnsigned8(1);
        tos.writeUnsigned8(0);
        tos.writeUnsigned16(this.seqNo);
        tos.writeUnsigned8(0);
        tos.writeUnsigned8(this.stationId);
        tos.write(this.payload);
        tos.writeUnsigned16(CyclicRedundancyCheck.Crc16(tos.toByteArray()));
        tos.writeTo(out);
        return false;
    }

    public void fromInputStream(InputStream in) throws Exception {
        super.fromInputStream(in);
    }

    @Override
    public byte[] getPayload() {
        return new byte[0];
    }

    @Override
    public void appendPayload(byte[] data) {
        this.payload = (byte[])data.clone();
    }

    public String toTraceString() {
        return "SbcPacketTraceMessage";
    }

    public Object getTag() {
        return this.seqNo;
    }
}

