/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.hdlogs;

import com.honeywell.sbc.BSbcDevice;
import com.honeywell.sbc.common.BSbcWorker;
import com.honeywell.sbc.common.SbcQueueManager;
import com.honeywell.sbc.exception.SbcException;
import com.honeywell.sbc.point.BSbcPointDeviceExt;
import com.honeywell.sbc.util.SbcUtil;
import com.honeywell.sbc.web.SbcWebRequest;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Tables;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.data.BIDataValue;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BCapacity;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.BTrendRecord;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="hdLogName", type="String", defaultValue="NO NAME", flags=1), @NiagaraProperty(name="associatedPoints", type="String", defaultValue="", flags=5), @NiagaraProperty(name="hdLogPollFrequency", type="BTimeTrigger", defaultValue="new BTimeTrigger()"), @NiagaraProperty(name="pollStatus", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="worker", type="BSbcWorker", defaultValue="new BSbcWorker()", flags=4), @NiagaraProperty(name="LastFile", type="String", flags=5, defaultValue=""), @NiagaraProperty(name="fileSize", type="int", flags=5, defaultValue="-1"), @NiagaraProperty(name="memory", type="String", defaultValue="", flags=5), @NiagaraProperty(name="folder", type="String", defaultValue="NO PATH", flags=5), @NiagaraProperty(name="FolderContent", type="String", defaultValue="", flags=5), @NiagaraProperty(name="Address", type="String", defaultValue="", flags=5), @NiagaraProperty(name="lastProcessed", type="long", defaultValue="0L", flags=5), @NiagaraProperty(name="lastReadLineNumber", type="int", defaultValue="0", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="startHDLogPoll", flags=16), @NiagaraAction(name="resetHDLog", flags=20), @NiagaraAction(name="execute", flags=20)})
public class BSbcHDLog
extends BComponent {
    public static final Property hdLogName = BSbcHDLog.newProperty((int)1, (String)"NO NAME", null);
    public static final Property associatedPoints = BSbcHDLog.newProperty((int)5, (String)"", null);
    public static final Property hdLogPollFrequency = BSbcHDLog.newProperty((int)0, (BValue)new BTimeTrigger(), null);
    public static final Property pollStatus = BSbcHDLog.newProperty((int)5, (boolean)false, null);
    public static final Property worker = BSbcHDLog.newProperty((int)4, (BValue)new BSbcWorker(), null);
    public static final Property LastFile = BSbcHDLog.newProperty((int)5, (String)"", null);
    public static final Property fileSize = BSbcHDLog.newProperty((int)5, (int)-1, null);
    public static final Property memory = BSbcHDLog.newProperty((int)5, (String)"", null);
    public static final Property folder = BSbcHDLog.newProperty((int)5, (String)"NO PATH", null);
    public static final Property FolderContent = BSbcHDLog.newProperty((int)5, (String)"", null);
    public static final Property Address = BSbcHDLog.newProperty((int)5, (String)"", null);
    public static final Property lastProcessed = BSbcHDLog.newProperty((int)5, (long)0L, null);
    public static final Property lastReadLineNumber = BSbcHDLog.newProperty((int)5, (int)0, null);
    public static final Action startHDLogPoll = BSbcHDLog.newAction((int)16, null);
    public static final Action resetHDLog = BSbcHDLog.newAction((int)20, null);
    public static final Action execute = BSbcHDLog.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BSbcHDLog.class);
    public static final String IS_DIRECTORY = "isDirectory";
    public static final String DELIMETER = ";";
    public static final String DN = ".";
    private static final BIcon icon = BIcon.make((String)"module://driver/com/tridium/driver/ui/history/importHistory.png");
    private String deviceHandle = null;
    private static final int MILLI_SECONDS = 1000;
    private static final int POINT_INFO_INDEX = 3;
    private static final String HEADER_IGNORE = "(s";
    private static final int MAX = Integer.MAX_VALUE;

    public String getHdLogName() {
        return this.getString(hdLogName);
    }

    public void setHdLogName(String v) {
        this.setString(hdLogName, v, null);
    }

    public String getAssociatedPoints() {
        return this.getString(associatedPoints);
    }

    public void setAssociatedPoints(String v) {
        this.setString(associatedPoints, v, null);
    }

    public BTimeTrigger getHdLogPollFrequency() {
        return (BTimeTrigger)this.get(hdLogPollFrequency);
    }

    public void setHdLogPollFrequency(BTimeTrigger v) {
        this.set(hdLogPollFrequency, (BValue)v, null);
    }

    public boolean getPollStatus() {
        return this.getBoolean(pollStatus);
    }

    public void setPollStatus(boolean v) {
        this.setBoolean(pollStatus, v, null);
    }

    public BSbcWorker getWorker() {
        return (BSbcWorker)this.get(worker);
    }

    public void setWorker(BSbcWorker v) {
        this.set(worker, (BValue)v, null);
    }

    public String getLastFile() {
        return this.getString(LastFile);
    }

    public void setLastFile(String v) {
        this.setString(LastFile, v, null);
    }

    public int getFileSize() {
        return this.getInt(fileSize);
    }

    public void setFileSize(int v) {
        this.setInt(fileSize, v, null);
    }

    public String getMemory() {
        return this.getString(memory);
    }

    public void setMemory(String v) {
        this.setString(memory, v, null);
    }

    public String getFolder() {
        return this.getString(folder);
    }

    public void setFolder(String v) {
        this.setString(folder, v, null);
    }

    public String getFolderContent() {
        return this.getString(FolderContent);
    }

    public void setFolderContent(String v) {
        this.setString(FolderContent, v, null);
    }

    public String getAddress() {
        return this.getString(Address);
    }

    public void setAddress(String v) {
        this.setString(Address, v, null);
    }

    public long getLastProcessed() {
        return this.getLong(lastProcessed);
    }

    public void setLastProcessed(long v) {
        this.setLong(lastProcessed, v, null);
    }

    public int getLastReadLineNumber() {
        return this.getInt(lastReadLineNumber);
    }

    public void setLastReadLineNumber(int v) {
        this.setInt(lastReadLineNumber, v, null);
    }

    public void startHDLogPoll() {
        this.invoke(startHDLogPoll, null, null);
    }

    public void resetHDLog() {
        this.invoke(resetHDLog, null, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setPollStatus(false);
        this.linkTo(null, (BComponent)this.getHdLogPollFrequency(), (Slot)BTimeTrigger.fireTrigger, (Slot)startHDLogPoll);
        this.linkHDLogWithAssociatedPoints();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.setPollStatus(false);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        this.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, argument, cx));
        return null;
    }

    public void doStartHDLogPoll() {
        this.deviceHandle = this.getDeviceHandle();
        if (this.deviceHandle != null) {
            SbcQueueManager.queue(this, this.deviceHandle);
        }
    }

    public void doExecute() {
        if (!this.getPollStatus()) {
            try {
                this.setPollStatus(true);
                this.deviceHandle = this.getDeviceHandle();
                if (SbcUtil.log_driver.isLoggable(Level.FINEST)) {
                    SbcUtil.log_driver.log(Level.FINEST, this.deviceHandle + "\t" + BAbsTime.now().toString((Context)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE)) + "\tStarted polling hd logs for : " + this.getHdLogName());
                }
                this.sendHDLogRequest();
                if (SbcUtil.log_driver.isLoggable(Level.FINEST)) {
                    SbcUtil.log_driver.log(Level.FINEST, this.deviceHandle + "\t" + BAbsTime.now().toString((Context)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE)) + "\tCompleted polling hd logs for : " + this.getHdLogName());
                }
            }
            catch (Exception e) {
                SbcUtil.log_driver.log(Level.SEVERE, "Fetching history data failed", e);
            }
            finally {
                this.setPollStatus(false);
            }
        }
    }

    private String getDeviceHandle() {
        try {
            BSbcDevice device = (BSbcDevice)SbcUtil.getParentDevice(this);
            return device.getHandleOrd().encodeToString();
        }
        catch (Exception e) {
            SbcUtil.log_driver.log(Level.SEVERE, "Not expected parent object", e);
            return null;
        }
    }

    private HistoryDatabaseConnection getHistoryDBConnection() {
        BHistoryService historyService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        if (null != historyService) {
            BHistoryDatabase db = historyService.getDatabase();
            return db.getDbConnection((Context)null);
        }
        return null;
    }

    private void createHistoryForPoint(HistoryDatabaseConnection conn, String stationName, String historyName, BSbcDevice sbcDevice) {
        BIHistory history = conn.getHistory(BHistoryId.make((String)stationName, (String)historyName));
        if (null == history) {
            BHistoryConfig historyConfig = new BHistoryConfig();
            historyConfig.setFlags((Slot)BHistoryConfig.capacity, 1024);
            historyConfig.setTimeZone(sbcDevice.getDeviceInformation().getPcdTimeZone());
            BHistoryId id = BHistoryId.make((String)stationName, (String)historyName);
            historyConfig.setId(id);
            historyConfig.setRecordType(BNumericTrendRecord.TYPE.getTypeSpec());
            historyConfig.setSource(BOrdList.DEFAULT);
            historyConfig.setCapacity(BCapacity.makeByRecordCount((int)Integer.MAX_VALUE));
            this.configureHistory(conn, historyConfig);
        } else {
            history.getConfig().setCapacity(BCapacity.makeByRecordCount((int)Integer.MAX_VALUE));
        }
    }

    private void configureHistory(HistoryDatabaseConnection dbConnection, BHistoryConfig config) {
        if (dbConnection.getHistory(config.getId()) == null) {
            dbConnection.recreateHistory(config, true);
        } else {
            dbConnection.reconfigureHistory(config);
        }
    }

    private void parseAndMapHistoryData(String[] dataArray, BSbcDevice sbcDevice) {
        BSbcPointDeviceExt pointDeviceExt = sbcDevice.getPoints();
        HistoryDatabaseConnection conn = this.getHistoryDBConnection();
        String stationName = Sys.getStation().getStationName();
        if (null != conn) {
            int startIndex;
            ArrayList<String> headerList = new ArrayList<String>();
            this.createHistoryObject(pointDeviceExt, conn, stationName, headerList, sbcDevice);
            for (int i = startIndex = this.getLastReadLineNumber(); i < dataArray.length; ++i) {
                this.createAndAppendTrendRecord(dataArray[i].trim(), pointDeviceExt, conn, stationName, headerList, sbcDevice);
                this.setLastReadLineNumber(this.getLastReadLineNumber() + 1);
            }
        } else {
            SbcUtil.log_driver.log(Level.SEVERE, "History service not found!!! or incorrect response data");
        }
    }

    private void createHistoryObject(BSbcPointDeviceExt pointDeviceExt, HistoryDatabaseConnection conn, String stationName, List<String> headerList, BSbcDevice device) {
        String[] headers = this.getAssociatedPoints().split(DELIMETER);
        for (int j = 0; j < headers.length; ++j) {
            String header = headers[j].trim();
            String ord = pointDeviceExt.getNavOrd().encodeToString().concat(this.getPointNav(header));
            try {
                BControlPoint point = (BControlPoint)BOrd.make((String)ord).resolve().get();
                if (null != point) {
                    String historyName = SlotPath.unescape((String)device.getName().concat(DN).concat(header));
                    this.createHistoryForPoint(conn, stationName, SlotPath.escape((String)historyName), device);
                }
            }
            catch (UnresolvedException e) {
                SbcUtil.log_driver.log(Level.FINEST, "Point not exists or not imported as part of Offline Engineering");
            }
            headerList.add(header);
        }
    }

    private void createAndAppendTrendRecord(String s, BSbcPointDeviceExt pointDeviceExt, HistoryDatabaseConnection conn, String stationName, List<String> headerList, BSbcDevice device) {
        int k = 0;
        if (s.startsWith(HEADER_IGNORE)) {
            return;
        }
        String[] values = s.split(DELIMETER);
        long temp = this.getLastProcessed();
        String timeStamp = values[0].trim();
        long timeInMilliSec = Long.parseLong(timeStamp) * 1000L;
        for (int j = 3; j < values.length; ++j) {
            try {
                String header = headerList.get(k).trim();
                String ord = pointDeviceExt.getNavOrd().encodeToString().concat(this.getPointNav(header));
                BControlPoint point = (BControlPoint)BOrd.make((String)ord).resolve().get();
                if (null != point) {
                    String historyName = SlotPath.unescape((String)device.getName().concat(DN).concat(header));
                    BIHistory history = conn.getHistory(BHistoryId.make((String)stationName, (String)SlotPath.escape((String)historyName)));
                    BTimeZone timeZone = device.getDeviceInformation().getPcdTimeZone();
                    BAbsTime outputTime = this.calculateDSTTime(timeInMilliSec, timeZone, temp);
                    this.createTrendRecord(outputTime, conn, history, values[j].trim(), point, timeInMilliSec, timeZone);
                }
            }
            catch (UnresolvedException e) {
                SbcUtil.log_driver.log(Level.WARNING, "Point not exists or not imported as part of Offline Engineering ", e);
            }
            ++k;
        }
        if (timeInMilliSec > temp) {
            this.setLastProcessed(timeInMilliSec);
        }
    }

    private void createTrendRecord(BAbsTime outputTime, HistoryDatabaseConnection conn, BIHistory history, String pointValue, BControlPoint point, long timeInMilliSec, BTimeZone timeZone) {
        if (outputTime != null) {
            BITable collection = conn.timeQuery(history, outputTime, outputTime);
            BIRandomAccessTable historyDatas = Tables.slurp((BITable)collection);
            if (historyDatas.size() <= 0) {
                BTrendRecord record = this.getTrendRecord(point, pointValue);
                this.appendHistory(conn, point, history, outputTime, record);
            }
        } else if (SbcUtil.log_driver.isLoggable(Level.FINEST)) {
            SbcUtil.log_driver.log(Level.FINEST, "Received old record: " + BAbsTime.make((long)timeInMilliSec, (BTimeZone)timeZone).toString((Context)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE)));
        }
    }

    private BAbsTime calculateDSTTime(long recordTime, BTimeZone tz, long inputTemp) {
        int dstAdjustment = tz.getDaylightAdjustment();
        BAbsTime currentTime = BAbsTime.now();
        if (dstAdjustment != 0) {
            long startTime = tz.getDaylightStartRule().getTime(currentTime.getYear(), tz, 0).getMillis();
            long endTime = tz.getDaylightEndRule().getTime(currentTime.getYear(), tz, 0).getMillis();
            long tempEndTime = endTime += (long)(tz.getUtcOffset() + tz.getDaylightAdjustment());
            long temp = inputTemp;
            if (recordTime < (startTime += (long)(tz.getUtcOffset() + tz.getDaylightAdjustment()))) {
                return BAbsTime.make((long)(recordTime -= (long)tz.getUtcOffset()), (BTimeZone)tz);
            }
            if (recordTime >= temp) {
                return this.handleDstTime(recordTime, endTime, tz);
            }
            return this.changeTimeToUtc(recordTime, tempEndTime, temp, tz);
        }
        return BAbsTime.make((long)(recordTime += (long)(tz.getUtcOffset() * -1)), (BTimeZone)tz);
    }

    private BAbsTime handleDstTime(long recordTime, long endTime, BTimeZone tz) {
        if (recordTime < endTime) {
            return BAbsTime.make((long)(recordTime -= (long)(tz.getUtcOffset() + tz.getDaylightAdjustment())), (BTimeZone)tz);
        }
        recordTime = tz.getUtcOffset() < 0 ? (recordTime -= (long)(tz.getUtcOffset() + tz.getDaylightAdjustment())) : (recordTime -= (long)tz.getUtcOffset());
        return BAbsTime.make((long)recordTime, (BTimeZone)tz);
    }

    private BAbsTime changeTimeToUtc(long recordTime, long tempEndTime, long temp, BTimeZone tz) {
        long tv;
        if (recordTime > tempEndTime) {
            long md = temp % 3600L;
            long mddiff = 3600L - md;
            this.setLastProcessed(temp += mddiff);
            return BAbsTime.make((long)(recordTime -= (long)tz.getUtcOffset()), (BTimeZone)tz);
        }
        long cal = (tz.getUtcOffset() + tz.getDaylightAdjustment()) / 2;
        if (cal < 0L) {
            cal *= -1L;
        }
        if ((tv = recordTime + cal) > tempEndTime) {
            return BAbsTime.make((long)(recordTime -= (long)tz.getUtcOffset()), (BTimeZone)tz);
        }
        return null;
    }

    private void appendHistory(HistoryDatabaseConnection conn, BControlPoint point, BIHistory history, BAbsTime time, BTrendRecord record) {
        if (null != record) {
            record.setTimestamp(time);
            conn.append(history, (BIHistoryRecordSet)record);
        } else {
            SbcUtil.log_driver.log(Level.FINEST, "Not supported point type: " + point.getType());
        }
    }

    public BTrendRecord getTrendRecord(BControlPoint point, String value) {
        if (point instanceof BNumericPoint) {
            BNumericTrendRecord numericRecord = new BNumericTrendRecord();
            numericRecord.setValue(Double.parseDouble(value));
            return numericRecord;
        }
        if (point instanceof BBooleanPoint) {
            BBooleanTrendRecord booleanRecord = new BBooleanTrendRecord();
            booleanRecord.setValue(Boolean.parseBoolean(value));
            return booleanRecord;
        }
        if (point instanceof BStringPoint) {
            BStringTrendRecord stringRecord = new BStringTrendRecord();
            stringRecord.setValue(value);
            return stringRecord;
        }
        return null;
    }

    public String getPointNav(String pointName) {
        String[] pointPathTokens;
        StringBuilder pointNav = new StringBuilder();
        for (String token : pointPathTokens = pointName.split("\\.")) {
            pointNav.append("/");
            pointNav.append(SlotPath.escape((String)token));
        }
        return pointNav.toString();
    }

    private void fetchHistory(String fileName, SbcWebRequest webRequest) throws Exception {
        BSbcDevice sbcDevice = (BSbcDevice)SbcUtil.getParentDevice(this);
        String data = "GET /cgi-bin/ftp.json?get=" + fileName + "&pwd=/" + this.getMemory() + ":" + this.getFolder() + "&usr=" + sbcDevice.getFtpUsername() + "," + SbcUtil.getPassword(sbcDevice.getFtpPassword()) + " HTTP/1.1\r\nHost: localhost\r\nUser-Agent: Saia.Net/2.1\r\nContent-Length: 0\r\n\r\n";
        webRequest.sendWebRequest(data, sbcDevice);
        if (!this.getLastFile().equals(fileName)) {
            this.setLastReadLineNumber(0);
        }
        this.parseAndMapHistoryData(webRequest.getDataArrayFromResponse(webRequest.getResponseString(sbcDevice)), sbcDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHDLogRequest() throws Exception {
        if ("NO PATH".equalsIgnoreCase(this.getFolder()) && !"".equalsIgnoreCase(this.getAddress())) {
            this.setFolder(this.getHDLogPath());
        }
        SbcWebRequest webRequest = new SbcWebRequest();
        webRequest.authenticateHttpConnection((BSbcDevice)SbcUtil.getParentDevice(this));
        JSONArray arrayOfFiles = this.getFileArray(webRequest);
        Map<Date, JSONObject> filteredHistoryFiles = this.getFilteredHdlogs(arrayOfFiles);
        boolean isLastFile = false;
        String lastSelectedFile = this.getLastFile();
        int lastFileSize = this.getFileSize();
        try {
            for (Date date : filteredHistoryFiles.keySet()) {
                JSONObject jsonObject = filteredHistoryFiles.get(date);
                boolean isDirectory = Boolean.parseBoolean(jsonObject.get(IS_DIRECTORY).toString());
                String selectedFile = jsonObject.get("name").toString();
                String fileExtension = selectedFile.substring(selectedFile.lastIndexOf(46) + 1);
                SbcUtil.log_driver.log(Level.FINEST, "Selected file for fetching history data: " + selectedFile);
                if (isDirectory || "IDX".equalsIgnoreCase(fileExtension)) continue;
                int fileSize = Integer.parseInt(jsonObject.get("size").toString());
                if ("".equalsIgnoreCase(this.getLastFile()) || isLastFile || this.getLastFile().equalsIgnoreCase(selectedFile) && fileSize > this.getFileSize()) {
                    this.fetchHistory(selectedFile, webRequest);
                    lastSelectedFile = selectedFile;
                    lastFileSize = fileSize;
                    isLastFile = true;
                    continue;
                }
                if (!this.getLastFile().equalsIgnoreCase(selectedFile) || fileSize != this.getFileSize()) continue;
                isLastFile = true;
            }
        }
        finally {
            this.setLastFile(lastSelectedFile);
            this.setFileSize(lastFileSize);
        }
    }

    private String getHDLogPath() throws SbcException {
        try {
            BSbcDevice sbcDevice = (BSbcDevice)SbcUtil.getParentDevice(this);
            return sbcDevice.sendRequestForTextByMemory(this.getAddress());
        }
        catch (Exception e) {
            throw new SbcException("Fail to get HDLog path from the PCD", e);
        }
    }

    private Map<Date, JSONObject> getFilteredHdlogs(JSONArray array) throws ParseException {
        String hdlogName = this.getHdLogName();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
        TreeMap<Date, JSONObject> map = new TreeMap<Date, JSONObject>();
        for (int i = 0; i < array.length(); ++i) {
            String fileNameStartsWithHdlogname;
            JSONObject jsonObject = array.getJSONObject(i);
            String selectedFile = jsonObject.get("name").toString();
            int lastIndex = selectedFile.lastIndexOf(95);
            if (lastIndex <= -1 || !hdlogName.equalsIgnoreCase(fileNameStartsWithHdlogname = selectedFile.substring(0, lastIndex))) continue;
            String dateString = selectedFile.substring(lastIndex + 2, selectedFile.lastIndexOf(46));
            Date date = sdf.parse(dateString);
            map.put(date, jsonObject);
        }
        SbcUtil.log_driver.log(Level.FINEST, "Filtered and Sorted History files: " + map.values());
        return map;
    }

    @Deprecated
    public String getJsonStringArray(String response) {
        String[] str = response.split("\n");
        int index = this.getDataIndex(str);
        return str[index];
    }

    private int getDataIndex(String[] str) {
        int index = -1;
        for (int i = 0; i < str.length; ++i) {
            if (!"".equalsIgnoreCase(str[i].trim())) continue;
            index = i + 1;
            break;
        }
        return index;
    }

    private JSONArray getFileArray(SbcWebRequest webRequest) throws Exception {
        block3: {
            try {
                BSbcDevice sbcDevice = (BSbcDevice)SbcUtil.getParentDevice(this);
                String data = "GET /cgi-bin/ftp.json?dir=/" + this.getMemory() + ":" + this.getFolder() + "&usr=" + sbcDevice.getFtpUsername() + "," + SbcUtil.getPassword(sbcDevice.getFtpPassword()) + " HTTP/1.1\r\nHost: localhost\r\nUser-Agent: Saia.Net/2.1\r\nContent-Length: 0\r\n\r\n";
                webRequest.sendWebRequest(data, sbcDevice);
                String[] dataArray = webRequest.getDataArrayFromResponse(webRequest.getResponseString(sbcDevice));
                String jsonString = dataArray[0].trim();
                SbcUtil.log_driver.log(Level.FINEST, "History files: " + jsonString);
                if (null != jsonString) {
                    return new JSONArray(jsonString);
                }
            }
            catch (Exception exp) {
                if (!SbcUtil.log_driver.isLoggable(Level.FINER)) break block3;
                SbcUtil.log_driver.log(Level.FINER, "Unable to find hd log data files from the controller. Please check is the data files available in controller or check ftp user name and password.");
            }
        }
        return new JSONArray();
    }

    public void doResetHDLog() {
        this.setLastFile("");
        this.setFileSize(-1);
        this.setLastProcessed(0L);
        this.setLastReadLineNumber(0);
    }

    private void linkHDLogWithAssociatedPoints() {
        BSbcDevice device = (BSbcDevice)SbcUtil.getParentDevice(this);
        BSbcPointDeviceExt getDevicePoints = device.getPoints();
        String[] pointList = this.getAssociatedPoints().split(DELIMETER);
        for (int j = 0; j < pointList.length; ++j) {
            String pointName = pointList[j].trim();
            String ord = getDevicePoints.getNavOrd().encodeToString().concat(this.getPointNav(pointName));
            try {
                BControlPoint sbcPoint = (BControlPoint)BOrd.make((String)ord).resolve().get();
                if (sbcPoint == null) continue;
                String sbcHDPath = "history:/" + Sys.getStation().getStationName() + "/" + SlotPath.escape((String)(device.getDisplayName(null) + DN + pointName));
                if (sbcPoint.get("linkedLogLocation") != null) {
                    sbcPoint.set("linkedLogLocation", (BValue)BOrd.make((String)sbcHDPath));
                    continue;
                }
                sbcPoint.add("linkedLogLocation", (BValue)BOrd.make((String)sbcHDPath), 5);
                continue;
            }
            catch (UnresolvedException e) {
                SbcUtil.log_driver.log(Level.FINEST, "Point not exists or not imported as part of Offline Engineering");
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

