/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.common;

import com.honeywell.sbc.BSbcDevice;
import com.honeywell.sbc.hdlogs.BSbcHDLog;
import com.honeywell.sbc.util.SbcUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.baja.util.Queue;

public class SbcQueueManager {
    private static Map<String, Queue> mapOfQueues = new ConcurrentHashMap<String, Queue>();
    private static Map<String, BSbcDevice> mapOfDevices = new ConcurrentHashMap<String, BSbcDevice>();

    private SbcQueueManager() {
    }

    public static synchronized void make(BSbcDevice device) {
        SbcUtil.logFinestMessage(device.getNavOrd() + " is registering with queue for processing hd logs.");
        mapOfDevices.put(device.getHandleOrd().encodeToString(), device);
        mapOfQueues.put(device.getHandleOrd().encodeToString(), new Queue());
    }

    public static void queue(BSbcHDLog input, String deviceHandle) {
        Queue upgradeList;
        if (mapOfDevices.get(deviceHandle) == null) {
            return;
        }
        BSbcDevice device = mapOfDevices.get(deviceHandle);
        if (device.getEnabled() && mapOfQueues.get(deviceHandle) != null && (upgradeList = mapOfQueues.get(deviceHandle)).find((Object)input) == null) {
            upgradeList.enqueue((Object)input);
            mapOfQueues.put(deviceHandle, upgradeList);
        }
    }

    public static void next(String deviceHandle) throws Exception {
        BSbcDevice sbcDevice = mapOfDevices.get(deviceHandle);
        if (sbcDevice == null) {
            SbcUtil.logFinestMessage(" Device is not found for the given handle: " + deviceHandle);
            return;
        }
        Queue upgradeList = mapOfQueues.get(deviceHandle);
        if (upgradeList == null) {
            SbcUtil.logFinestMessage(" Queue is empty for the device: " + deviceHandle);
            return;
        }
        SbcUtil.logFinestMessage(sbcDevice.getNavOrd() + " queue size is*************" + upgradeList.size());
        BSbcHDLog hdLog = (BSbcHDLog)((Object)upgradeList.dequeue());
        if (hdLog != null) {
            hdLog.invoke(BSbcHDLog.execute, null);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                SbcUtil.log_driver.log(Level.SEVERE, " Unable to fetch next wait hd log in the queue which are belongs to the current");
            }
            boolean flag = hdLog.getPollStatus();
            while (flag) {
                hdLog.lease();
                flag = hdLog.getPollStatus();
            }
        }
    }
}

