/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.common;

import com.honeywell.sbc.alarms.BSbcAlarmDeviceExt;
import com.honeywell.sbc.alarms.BSbcAlarmList;
import com.honeywell.sbc.util.SbcUtil;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.util.Queue;

public class SbcAlarmHandlingQueueManager {
    private Queue ackQueue = null;
    private Queue forceQueue = null;
    private BSbcAlarmList alarmList = null;

    public SbcAlarmHandlingQueueManager(BSbcAlarmList sbcAlarmList) {
        this.alarmList = sbcAlarmList;
        this.ackQueue = new Queue();
        this.forceQueue = new Queue();
    }

    public void queue(BAlarmRecord input, String requestType) {
        if (requestType.equals("A")) {
            if (this.ackQueue.find((Object)input) == null) {
                this.ackQueue.enqueue((Object)input);
            }
        } else if (requestType.equals("F") && this.forceQueue.find((Object)input) == null) {
            this.forceQueue.enqueue((Object)input);
        }
    }

    public void acknowledgeAllFailedAlarms() {
        if (this.ackQueue == null) {
            return;
        }
        while (!this.ackQueue.isEmpty()) {
            BAlarmRecord record = (BAlarmRecord)this.ackQueue.dequeue();
            if (record == null) continue;
            BOrd alarmSource = record.getSource().toArray()[0];
            try {
                BSbcAlarmDeviceExt objSourceExt = (BSbcAlarmDeviceExt)alarmSource.resolve((BObject)this.alarmList).get();
                objSourceExt.invoke(BSbcAlarmDeviceExt.sendAckRequest, (BValue)record);
            }
            catch (UnresolvedException ure) {
                SbcUtil.log_driver.log(Level.SEVERE, "Unable to get the SbcAlarmSource for ack alarms of the alarm list: " + this.alarmList.getName(), ure);
            }
        }
    }

    public void forceClearAllFailedAlarms() {
        if (this.forceQueue == null) {
            return;
        }
        while (!this.forceQueue.isEmpty()) {
            BAlarmRecord record = (BAlarmRecord)this.forceQueue.dequeue();
            if (record == null) continue;
            BOrd alarmSource = record.getSource().toArray()[0];
            try {
                BSbcAlarmDeviceExt objSourceExt = (BSbcAlarmDeviceExt)alarmSource.resolve((BObject)this.alarmList).get();
                objSourceExt.invoke(BSbcAlarmDeviceExt.sendForceClearRequest, (BValue)record);
            }
            catch (UnresolvedException ure) {
                SbcUtil.log_driver.log(Level.SEVERE, "Unable to get the SbcAlarmSource for clear alarms of the alarm list: " + this.alarmList.getName(), ure);
            }
        }
    }

    public Queue getAckQueue() {
        return this.ackQueue;
    }

    public Queue getForceQueue() {
        return this.forceQueue;
    }
}

