/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.alarms;

import com.honeywell.sbc.alarms.BSbcAlarmList;
import com.honeywell.sbc.common.SbcAlarmHandlingQueueManager;
import com.honeywell.sbc.util.SbcUtil;
import java.io.IOException;
import java.util.logging.Level;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.util.BUuid;
import javax.baja.util.Queue;

public class SbcAlarmHandlingManager {
    private BSbcAlarmList alarmList = null;
    private BAlarmService alarmService = null;

    public SbcAlarmHandlingManager(BSbcAlarmList alarmList, BAlarmService alarmService) {
        this.alarmList = alarmList;
        this.alarmService = alarmService;
    }

    public void loadAllWaitingForAcknowledgeAlarmsToStation() {
        SbcAlarmHandlingQueueManager queueManager = this.alarmList.getSbcAlarmHandlingQueueManager();
        Queue ackQueue = queueManager.getAckQueue();
        StringBuilder builder = new StringBuilder();
        boolean isStart = true;
        while (!ackQueue.isEmpty()) {
            BAlarmRecord record = (BAlarmRecord)ackQueue.dequeue();
            isStart = this.m1(record, builder, isStart);
        }
        this.alarmList.setAckPending(builder.toString());
    }

    private boolean m1(BAlarmRecord record, StringBuilder builder, boolean isStart) {
        try {
            if (record != null) {
                if (isStart) {
                    builder.append(record.getUuid().encodeToString());
                    isStart = false;
                } else {
                    builder.append(",");
                    builder.append(record.getUuid().encodeToString());
                }
            }
        }
        catch (IOException ioe) {
            SbcUtil.log_driver.log(Level.SEVERE, "Unable to read UUID of the selected alarm record.", ioe);
        }
        return isStart;
    }

    public void storeAllWaitingForAcknowledgeAlarmsToQueue() {
        SbcAlarmHandlingQueueManager queueManager = this.alarmList.getSbcAlarmHandlingQueueManager();
        AlarmDbConnection connection = this.alarmService.getAlarmDb().getDbConnection(null);
        String pendingAlarms = this.alarmList.getAckPending();
        String[] alarms = pendingAlarms.split(",");
        BAlarmRecord alarmRecord = null;
        for (String alarm : alarms) {
            try {
                if (alarm != null && alarm.trim().length() > 0) {
                    alarmRecord = connection.getRecord(BUuid.make((String)alarm));
                }
                if (alarmRecord == null) continue;
                queueManager.queue(alarmRecord, "A");
                alarmRecord = null;
            }
            catch (IOException ioe) {
                SbcUtil.log_driver.log(Level.SEVERE, "Unable to read the alarm for the given uuid: " + alarm, ioe);
            }
        }
    }

    public void loadAllWaitingForForceClearAlarmsToStation() {
        SbcAlarmHandlingQueueManager queueManager = this.alarmList.getSbcAlarmHandlingQueueManager();
        Queue forceQueue = queueManager.getForceQueue();
        StringBuilder builder = new StringBuilder();
        boolean isStart = true;
        while (!forceQueue.isEmpty()) {
            BAlarmRecord record = (BAlarmRecord)forceQueue.dequeue();
            isStart = this.m1(record, builder, isStart);
        }
        this.alarmList.setForcePending(builder.toString());
    }

    public void storeAllWaitingForForceClearAlarmsToQueue() {
        SbcAlarmHandlingQueueManager queueManager = this.alarmList.getSbcAlarmHandlingQueueManager();
        AlarmDbConnection connection = this.alarmService.getAlarmDb().getDbConnection(null);
        String pendingAlarms = this.alarmList.getAckPending();
        String[] alarms = pendingAlarms.split(",");
        BAlarmRecord alarmRecord = null;
        for (String alarm : alarms) {
            try {
                if (alarm != null && alarm.trim().length() > 0) {
                    alarmRecord = connection.getRecord(BUuid.make((String)alarm));
                }
                if (alarmRecord == null) continue;
                queueManager.queue(alarmRecord, "F");
                alarmRecord = null;
            }
            catch (IOException ioe) {
                SbcUtil.log_driver.log(Level.SEVERE, "Unable to read the alarm for the given uuid: " + alarm, ioe);
            }
        }
    }
}

