/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.alarms;

import com.honeywell.sbc.alarms.BSbcAlarmList;
import com.honeywell.sbc.util.SbcUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import javax.baja.file.BIFile;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BObject;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SBCAlarmTextLoader {
    private BSbcAlarmList alarmList = null;

    public SBCAlarmTextLoader(BSbcAlarmList objList) {
        this.alarmList = objList;
    }

    public void reloadAlarmTexts() {
        block10: {
            BIFile file = this.getDeviceAlarmTextXMLFile();
            if (file == null) {
                if (SbcUtil.sbcAlarmPoll.isLoggable(Level.FINER)) {
                    SbcUtil.sbcAlarmPoll.log(Level.FINER, "Unable to find the alarm text file for the list: " + this.alarmList.getDisplayName(null));
                }
                return;
            }
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document document = builder.parse(file.getInputStream());
                if (document == null) {
                    if (SbcUtil.sbcAlarmPoll.isLoggable(Level.FINER)) {
                        SbcUtil.sbcAlarmPoll.log(Level.FINER, "Unable to document object for the list: " + this.alarmList.getDisplayName(null));
                    }
                    return;
                }
                this.storeAlarmTextsToAlarmList(document);
            }
            catch (IOException ioe) {
                if (SbcUtil.sbcAlarmPoll.isLoggable(Level.FINER)) {
                    SbcUtil.sbcAlarmPoll.log(Level.FINER, "Unable to read given alarm list xml file : " + file.getFilePath().toString(), ioe);
                }
            }
            catch (ParserConfigurationException pce) {
                if (SbcUtil.sbcAlarmPoll.isLoggable(Level.FINER)) {
                    SbcUtil.sbcAlarmPoll.log(Level.FINER, "Unable to parse given alarm list xml: " + file.getFilePath().toString(), pce);
                }
            }
            catch (SAXException se) {
                if (!SbcUtil.sbcAlarmPoll.isLoggable(Level.FINER)) break block10;
                SbcUtil.sbcAlarmPoll.log(Level.FINER, "Invalid file format: " + file.getFilePath().toString(), se);
            }
        }
    }

    private Node storeAlarmTextsToAlarmList(Document document) {
        Node node;
        block3: {
            String expression = null;
            node = null;
            try {
                XPath xPath = XPathFactory.newInstance().newXPath();
                expression = this.getAlarmTextForSelectedLanguageExpression(this.alarmList.getSymbolName(), this.alarmList.getLanguage().getTag());
                NodeList nodeList = (NodeList)xPath.compile(expression).evaluate(document, XPathConstants.NODESET);
                HashMap<String, BFormat> entries = new HashMap<String, BFormat>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    node = nodeList.item(i);
                    entries.put(((Attr)node.getAttributes().getNamedItem("id")).getValue(), BFormat.make((String)((Attr)node.getAttributes().getNamedItem("value")).getValue()));
                }
                BNameMap nameMap = BNameMap.make(entries);
                this.alarmList.setAlarmTexts(nameMap);
            }
            catch (XPathExpressionException xee) {
                if (!SbcUtil.sbcAlarmPoll.isLoggable(Level.FINER)) break block3;
                SbcUtil.sbcAlarmPoll.log(Level.FINER, "Unexpected alarm text expression: " + expression, xee);
            }
        }
        return node;
    }

    private String getAlarmTextForSelectedLanguageExpression(String symbolName, String languageCode) {
        return "/AlarmLists/AlarmList[@name='" + symbolName + "']/Languages/Language[@code='" + languageCode + "']/AlarmText";
    }

    private BIFile getDeviceAlarmTextXMLFile() {
        try {
            BIFile outputFile = (BIFile)this.alarmList.getAlarmTextFileLocation().resolve((BObject)this.alarmList).get();
            return outputFile;
        }
        catch (UnresolvedException ure) {
            if (SbcUtil.sbcAlarmPoll.isLoggable(Level.FINER)) {
                SbcUtil.sbcAlarmPoll.log(Level.FINER, "Unable to find the alarm text xml file." + this.alarmList.getAlarmTextFileLocation().encodeToString(), ure);
            }
            return null;
        }
    }
}

