/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.alarms;

import com.honeywell.sbc.BSbcDevice;
import com.honeywell.sbc.alarms.BSbcAlarmSource;
import com.honeywell.sbc.alarms.SBCAlarmTextLoader;
import com.honeywell.sbc.alarms.SbcAlarmHandlingManager;
import com.honeywell.sbc.bean.AlarmRecordBean;
import com.honeywell.sbc.common.BSbcWorker;
import com.honeywell.sbc.common.SbcAlarmHandlingQueueManager;
import com.honeywell.sbc.enums.BSbcAlarmConfigEnum;
import com.honeywell.sbc.exception.SbcAlarmHandlingException;
import com.honeywell.sbc.util.SbcUtil;
import com.honeywell.sbc.web.SbcWebRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alarmListName", type="String", defaultValue="NO NAME"), @NiagaraProperty(name="alarmListNumber", type="int", defaultValue="-1"), @NiagaraProperty(name="deleteMode", type="int", defaultValue="-1"), @NiagaraProperty(name="memoryAddress", type="int", defaultValue="-1"), @NiagaraProperty(name="symbolName", type="String", defaultValue="", flags=5), @NiagaraProperty(name="alarmTextFileLocation", type="BOrd", defaultValue="BOrd.DEFAULT", flags=5), @NiagaraProperty(name="alarmConfigType", type="BSbcAlarmConfigEnum", defaultValue="BSbcAlarmConfigEnum.DDCSuite", flags=4), @NiagaraProperty(name="supportedLanguages", type="String", defaultValue="", flags=5), @NiagaraProperty(name="language", type="BDynamicEnum", defaultValue="BDynamicEnum.make(0,BEnumRange.make(new String[] {\"EN\"}))"), @NiagaraProperty(name="alarmClass", type="baja:String", defaultValue="BString.make(\"defaultAlarmClass\")", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"alarm:AlarmClassFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"alarm:AlarmClassEditor\")")}), @NiagaraProperty(name="pollStatus", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="alarmTexts", type="BNameMap", defaultValue="BNameMap.DEFAULT", flags=5), @NiagaraProperty(name="ackPending", type="String", defaultValue="", flags=5), @NiagaraProperty(name="forcePending", type="String", defaultValue="", flags=5), @NiagaraProperty(name="worker", type="BSbcWorker", defaultValue="new BSbcWorker()", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="execute", flags=20), @NiagaraAction(name="acknowledgeAlarms", flags=20), @NiagaraAction(name="forceClearAlarms", flags=20), @NiagaraAction(name="loadToStation", flags=4), @NiagaraAction(name="loadToQueue", flags=20), @NiagaraAction(name="loadAlarmTexts", flags=20)})
public class BSbcAlarmList
extends BComponent {
    public static final Property alarmListName = BSbcAlarmList.newProperty((int)0, (String)"NO NAME", null);
    public static final Property alarmListNumber = BSbcAlarmList.newProperty((int)0, (int)-1, null);
    public static final Property deleteMode = BSbcAlarmList.newProperty((int)0, (int)-1, null);
    public static final Property memoryAddress = BSbcAlarmList.newProperty((int)0, (int)-1, null);
    public static final Property symbolName = BSbcAlarmList.newProperty((int)5, (String)"", null);
    public static final Property alarmTextFileLocation = BSbcAlarmList.newProperty((int)5, (BValue)BOrd.DEFAULT, null);
    public static final Property alarmConfigType = BSbcAlarmList.newProperty((int)4, (BValue)BSbcAlarmConfigEnum.DDCSuite, null);
    public static final Property supportedLanguages = BSbcAlarmList.newProperty((int)5, (String)"", null);
    public static final Property language = BSbcAlarmList.newProperty((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])new String[]{"EN"})), null);
    public static final Property alarmClass = BSbcAlarmList.newProperty((int)0, (BValue)BString.make((String)"defaultAlarmClass"), (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassEditor"))));
    public static final Property pollStatus = BSbcAlarmList.newProperty((int)5, (boolean)false, null);
    public static final Property alarmTexts = BSbcAlarmList.newProperty((int)5, (BValue)BNameMap.DEFAULT, null);
    public static final Property ackPending = BSbcAlarmList.newProperty((int)5, (String)"", null);
    public static final Property forcePending = BSbcAlarmList.newProperty((int)5, (String)"", null);
    public static final Property worker = BSbcAlarmList.newProperty((int)4, (BValue)new BSbcWorker(), null);
    public static final Action execute = BSbcAlarmList.newAction((int)20, null);
    public static final Action acknowledgeAlarms = BSbcAlarmList.newAction((int)20, null);
    public static final Action forceClearAlarms = BSbcAlarmList.newAction((int)20, null);
    public static final Action loadToStation = BSbcAlarmList.newAction((int)4, null);
    public static final Action loadToQueue = BSbcAlarmList.newAction((int)20, null);
    public static final Action loadAlarmTexts = BSbcAlarmList.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BSbcAlarmList.class);
    private static final BIcon icon = BIcon.std((String)"navOnly/alarmService.png");
    private BAlarmService alarmService;
    private SbcAlarmHandlingQueueManager alarmQueueManager = new SbcAlarmHandlingQueueManager(this);

    public String getAlarmListName() {
        return this.getString(alarmListName);
    }

    public void setAlarmListName(String v) {
        this.setString(alarmListName, v, null);
    }

    public int getAlarmListNumber() {
        return this.getInt(alarmListNumber);
    }

    public void setAlarmListNumber(int v) {
        this.setInt(alarmListNumber, v, null);
    }

    public int getDeleteMode() {
        return this.getInt(deleteMode);
    }

    public void setDeleteMode(int v) {
        this.setInt(deleteMode, v, null);
    }

    public int getMemoryAddress() {
        return this.getInt(memoryAddress);
    }

    public void setMemoryAddress(int v) {
        this.setInt(memoryAddress, v, null);
    }

    public String getSymbolName() {
        return this.getString(symbolName);
    }

    public void setSymbolName(String v) {
        this.setString(symbolName, v, null);
    }

    public BOrd getAlarmTextFileLocation() {
        return (BOrd)this.get(alarmTextFileLocation);
    }

    public void setAlarmTextFileLocation(BOrd v) {
        this.set(alarmTextFileLocation, (BValue)v, null);
    }

    public BSbcAlarmConfigEnum getAlarmConfigType() {
        return (BSbcAlarmConfigEnum)this.get(alarmConfigType);
    }

    public void setAlarmConfigType(BSbcAlarmConfigEnum v) {
        this.set(alarmConfigType, (BValue)v, null);
    }

    public String getSupportedLanguages() {
        return this.getString(supportedLanguages);
    }

    public void setSupportedLanguages(String v) {
        this.setString(supportedLanguages, v, null);
    }

    public BDynamicEnum getLanguage() {
        return (BDynamicEnum)this.get(language);
    }

    public void setLanguage(BDynamicEnum v) {
        this.set(language, (BValue)v, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    public boolean getPollStatus() {
        return this.getBoolean(pollStatus);
    }

    public void setPollStatus(boolean v) {
        this.setBoolean(pollStatus, v, null);
    }

    public BNameMap getAlarmTexts() {
        return (BNameMap)this.get(alarmTexts);
    }

    public void setAlarmTexts(BNameMap v) {
        this.set(alarmTexts, (BValue)v, null);
    }

    public String getAckPending() {
        return this.getString(ackPending);
    }

    public void setAckPending(String v) {
        this.setString(ackPending, v, null);
    }

    public String getForcePending() {
        return this.getString(forcePending);
    }

    public void setForcePending(String v) {
        this.setString(forcePending, v, null);
    }

    public BSbcWorker getWorker() {
        return (BSbcWorker)this.get(worker);
    }

    public void setWorker(BSbcWorker v) {
        this.set(worker, (BValue)v, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public void acknowledgeAlarms() {
        this.invoke(acknowledgeAlarms, null, null);
    }

    public void forceClearAlarms() {
        this.invoke(forceClearAlarms, null, null);
    }

    public void loadToStation() {
        this.invoke(loadToStation, null, null);
    }

    public void loadToQueue() {
        this.invoke(loadToQueue, null, null);
    }

    public void loadAlarmTexts() {
        this.invoke(loadAlarmTexts, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setPollStatus(false);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        this.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, argument, cx));
        return null;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(language)) {
            this.invoke(loadAlarmTexts, null);
        }
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        if (!this.isRunning()) {
            return;
        }
        this.invoke(loadToQueue, null);
    }

    public void stopped() throws Exception {
        super.stopped();
        this.invoke(loadToStation, null);
    }

    public void doExecute() {
        if (!this.getPollStatus()) {
            try {
                this.setPollStatus(true);
                this.authenticateSbcWebRequest();
                this.invoke(acknowledgeAlarms, null);
                this.invoke(forceClearAlarms, null);
                this.sendAlarmRequest();
            }
            finally {
                this.setPollStatus(false);
            }
        }
    }

    private void authenticateSbcWebRequest() {
        try {
            SbcWebRequest webRequest = new SbcWebRequest();
            webRequest.authenticateHttpConnection((BSbcDevice)SbcUtil.getParentDevice(this));
        }
        catch (Exception e) {
            SbcUtil.sbcAlarmPoll.log(Level.SEVERE, " Device Authentication Failed before polling alarms", e);
        }
    }

    public void sendAlarmRequest() {
        BSbcDevice device = new BSbcDevice();
        try {
            String[] alarmsResponseArr;
            device = (BSbcDevice)this.getParent().getParent();
            if ("NO NAME".equals(this.getAlarmListName()) && this.getMemoryAddress() != -1) {
                this.fetchAlarmListName(device);
            }
            if (this.getAlarmListNumber() == -1 && !"NO NAME".equals(this.getAlarmListName())) {
                this.fetchAlarmListNumber(device);
            }
            if (this.getDeleteMode() == -1 && this.getAlarmListNumber() >= 0) {
                this.fetchAlarmListDeleteMode(device);
            }
            if ((alarmsResponseArr = this.getAlarmsFromPcd(device)) != null) {
                this.addAlarmsToNiagara(alarmsResponseArr);
            }
        }
        catch (Exception e) {
            SbcUtil.sbcAlarmPoll.log(Level.SEVERE, "Error occurred during polling alarms in device - " + device.getIpAddress() + ":" + device.getStationId(), e);
        }
    }

    private void fetchAlarmListName(BSbcDevice device) {
        try {
            String alrLstName = device.sendRequestForTextByMemory(Integer.toString(this.getMemoryAddress()));
            if ("".equals(alrLstName)) {
                throw new SbcAlarmHandlingException(" AlarmListName not received from the pcd. Expected text. Received empty string");
            }
            this.setAlarmListName(alrLstName);
        }
        catch (Exception e) {
            this.setAlarmListName("NO NAME");
            throw new SbcAlarmHandlingException("Error occurred while fetching alarm list name using S-BUS TEXT Command ", e);
        }
    }

    private String[] getAlarmsFromPcd(BSbcDevice device) {
        String alarmUrl = this.getUrlToFetchAlarms();
        SbcWebRequest sbcWebRequest = new SbcWebRequest();
        String[] responseArray = null;
        try {
            sbcWebRequest.sendWebRequest(alarmUrl, device);
            String responseStr = sbcWebRequest.getResponseString(device);
            responseArray = sbcWebRequest.getDataArrayFromResponse(responseStr);
        }
        catch (Exception e) {
            throw new SbcAlarmHandlingException("Error occurred while fetching alarms from pcd ", e);
        }
        return responseArray;
    }

    private void addAlarmsToNiagara(String[] alarmsResponseArr) {
        List<AlarmRecordBean> alarmBeanList = this.prepareListOfAlarmRecords(alarmsResponseArr);
        for (AlarmRecordBean alarmRecordBean : alarmBeanList) {
            try {
                int alarmTypeId = alarmRecordBean.getAlarmTypeId();
                BSbcAlarmSource alarmSource = this.getAlarmSource(alarmTypeId);
                if (alarmSource == null && alarmRecordBean.getCounter() != 0 && !alarmRecordBean.getTimeOn().equals((Object)BAbsTime.NULL)) {
                    alarmSource = this.createAlarmSource(alarmTypeId);
                    this.addAlarm(alarmRecordBean, alarmSource, true);
                    continue;
                }
                if (alarmSource == null) continue;
                this.updateAlarm(alarmRecordBean, alarmSource);
            }
            catch (Exception e) {
                SbcUtil.sbcAlarmPoll.log(Level.SEVERE, " Error occurred while processing an alarm record. Polling will continue.", e);
            }
        }
    }

    private BSbcAlarmSource getAlarmSource(int alarmTypeId) {
        return (BSbcAlarmSource)this.get(SlotPath.escape((String)String.valueOf(alarmTypeId)));
    }

    private BSbcAlarmSource createAlarmSource(int alarmTypeId) {
        BSbcAlarmSource alarmSource = new BSbcAlarmSource();
        this.add(SlotPath.escape((String)String.valueOf(alarmTypeId)), (BValue)alarmSource, 4);
        return alarmSource;
    }

    private void deleteAlarmSourceComponent(int alarmTypeId) {
        this.remove(SlotPath.escape((String)String.valueOf(alarmTypeId)));
    }

    private void fetchAlarmListNumber(BSbcDevice device) {
        try {
            String alarmListNrUrl = this.getUrlForAlarmListNr();
            SbcWebRequest sbcWebRequest = new SbcWebRequest();
            sbcWebRequest.sendWebRequest(alarmListNrUrl, device);
            String responseStr = sbcWebRequest.getResponseString(device);
            String[] responseArray = sbcWebRequest.getDataArrayFromResponse(responseStr);
            int listNumber = Integer.parseInt(responseArray[0].trim());
            if (listNumber < 0) {
                throw new SbcAlarmHandlingException("Invalid Alarm List Number received. Expected value greater than or equal to 0. Received " + listNumber);
            }
            this.setAlarmListNumber(listNumber);
        }
        catch (Exception e) {
            this.setAlarmListNumber(-1);
            throw new SbcAlarmHandlingException("Error occurred while fetching alarm list number ", e);
        }
    }

    private void fetchAlarmListDeleteMode(BSbcDevice device) {
        try {
            String delModeUrl = this.getUrlToFetchDelMode();
            SbcWebRequest sbcWebRequest = new SbcWebRequest();
            sbcWebRequest.sendWebRequest(delModeUrl, device);
            String responseStr = sbcWebRequest.getResponseString(device);
            String[] responseArray = sbcWebRequest.getDataArrayFromResponse(responseStr);
            String[] alarmListConfigArray = responseArray[0].trim().split(";");
            int delMode = Integer.parseInt(alarmListConfigArray[4]);
            if (delMode >= 0) {
                this.setDeleteMode(delMode);
            } else if (SbcUtil.sbcAlarmPoll.isLoggable(Level.FINEST)) {
                SbcUtil.sbcAlarmPoll.log(Level.FINEST, String.format(" Invalid Delete Mode value received. Expected value greater than or equal to 0. Received %d", delMode));
            }
        }
        catch (Exception e) {
            this.setDeleteMode(-1);
            throw new SbcAlarmHandlingException("Error occurred while fetching delete mode for alarm list ", e);
        }
    }

    private String getUrlToFetchDelMode() {
        StringBuilder delModeUrl = new StringBuilder();
        delModeUrl.append("GET /cgi-bin/alarm.exe?").append(this.getAlarmListNumber()).append("&cfg").append(" HTTP/1.1\r\nHost: localhost\r\nUser-Agent: Saia.Net/2.1\r\n\r\n");
        return delModeUrl.toString();
    }

    private String getUrlToFetchAlarms() {
        StringBuilder alarmUrl = new StringBuilder();
        alarmUrl.append("GET /cgi-bin/alarm.exe?").append(this.getAlarmListNumber()).append("&lbk&def&").append("0").append(",").append("max").append(",").append("6").append(",").append("0").append(" HTTP/1.1\r\nHost: localhost\r\n").append("User-Agent: Saia.Net/2.1\r\n\r\n");
        return alarmUrl.toString();
    }

    private String getUrlForAlarmListNr() {
        return "GET /cgi-bin/alarm.exe?open&" + this.getAlarmListName() + " HTTP/1.1\r\nHost: localhost\r\nUser-Agent: Saia.Net/2.1\r\n\r\n";
    }

    private List<AlarmRecordBean> prepareListOfAlarmRecords(String[] respMsg) {
        ArrayList<AlarmRecordBean> alarmList = new ArrayList<AlarmRecordBean>();
        for (String alarmRecord : respMsg) {
            if ("Done".equalsIgnoreCase(alarmRecord) || "End".equalsIgnoreCase(alarmRecord) || "".equals(alarmRecord)) continue;
            String[] alarmRow = alarmRecord.split(";");
            try {
                AlarmRecordBean alarmBean = new AlarmRecordBean();
                alarmBean.setAlarmTypeId(Integer.parseInt(alarmRow[0]));
                alarmBean.setCounter(Integer.parseInt(alarmRow[1]));
                this.setAlarmTimeOn(alarmRow[2], alarmBean);
                this.setAlarmTimeOff(alarmRow[3], alarmBean);
                this.setAlarmSourceState(alarmRow[3], alarmBean);
                alarmBean.setAckState(alarmRow[4].equals("1") ? BAckState.acked : BAckState.unacked);
                this.setAlarmPriority(alarmRow, alarmBean);
                this.setAlarmDeleteMode(alarmBean);
                alarmBean.setAlarmText(this.getAlarmText(alarmBean.getAlarmTypeId()));
                alarmList.add(alarmBean);
            }
            catch (NumberFormatException e) {
                SbcUtil.sbcAlarmPoll.log(Level.INFO, "Invalid data format: Error occurred while parsing the alarm record - " + alarmRecord, e);
            }
            catch (Exception e) {
                SbcUtil.sbcAlarmPoll.log(Level.INFO, "Error occurred while parsing the alarm record", e);
            }
        }
        return alarmList;
    }

    private void setAlarmTimeOn(String hexTimeStr, AlarmRecordBean alarmBean) {
        if (!"".equals(hexTimeStr) && !"0".equals(hexTimeStr)) {
            alarmBean.setTimeOn(this.getTimeAsPerSupervisorTimeZone(hexTimeStr));
        } else {
            alarmBean.setTimeOn(BAbsTime.NULL);
        }
    }

    private void setAlarmTimeOff(String hexTimeStr, AlarmRecordBean alarmBean) {
        if (!"".equals(hexTimeStr) && !"0".equals(hexTimeStr)) {
            alarmBean.setTimeOff(this.getTimeAsPerSupervisorTimeZone(hexTimeStr));
        } else {
            alarmBean.setTimeOff(BAbsTime.NULL);
        }
    }

    private void setAlarmSourceState(String hexTimeStr, AlarmRecordBean alarmBean) {
        if (!"".equals(hexTimeStr) && !"0".equals(hexTimeStr)) {
            alarmBean.setAlarmSourceState(BSourceState.normal);
        } else {
            alarmBean.setAlarmSourceState(BSourceState.offnormal);
        }
    }

    private void setAlarmPriority(String[] alarmRow, AlarmRecordBean alarmBean) {
        if (8 <= alarmRow.length) {
            alarmBean.setPriority(Integer.parseInt(alarmRow[7]));
        } else {
            alarmBean.setPriority(0);
        }
    }

    private void setAlarmDeleteMode(AlarmRecordBean alarmBean) {
        int alarmListDelMode = this.getDeleteMode();
        if (alarmListDelMode == 0) {
            alarmBean.setDelMode("All");
        } else if (alarmListDelMode == 1) {
            alarmBean.setDelMode("None");
        } else if (alarmListDelMode == 2) {
            alarmBean.setDelMode("Normal");
        } else if (alarmListDelMode == 3) {
            alarmBean.setDelMode("Ack");
        } else if (alarmListDelMode == 4) {
            alarmBean.setDelMode("Ack & Normal");
        }
    }

    private void setClearedAlarmStatus(AlarmRecordBean alarmRecordBean, BAlarmRecord localObject) {
        try {
            if (alarmRecordBean.getCounter() == 0) {
                BAlarmRecord alarmRecord = this.getAlarmRecordFromDb(localObject.getUuid());
                if (alarmRecord != null) {
                    BAbsTime timeStamp = alarmRecord.getTimestamp();
                    localObject.setTimestamp(timeStamp);
                }
                localObject.setNormalTime(BAbsTime.now());
                localObject.setSourceState(BSourceState.normal);
                localObject.setAckState(BAckState.acked);
            }
        }
        catch (Exception e) {
            SbcUtil.sbcAlarmPoll.log(Level.INFO, "Error occurred while setting the alarm clear state", e);
        }
    }

    private void addAlarm(AlarmRecordBean alarmRecordBean, BSbcAlarmSource alarmSource, boolean isNewRec) {
        try {
            BSbcDevice device = (BSbcDevice)this.getParent().getParent();
            alarmRecordBean.setDeviceIpAddress(device.getIpAddress().getIpAddress());
            alarmRecordBean.setDevicePort(device.getIpAddress().getPort());
            alarmRecordBean.setStationNumber(device.getStationId());
            alarmRecordBean.setAlarmListName(this.getAlarmListName());
            Map<String, BIDataValue> alarmDataMap = this.getAlarmDataMap(alarmRecordBean);
            BFacets alarmDataFacets = BFacets.make(alarmDataMap);
            String sourceName = this.getAlarmListName() + " / " + alarmRecordBean.getAlarmTypeId();
            BAlarmRecord localObject = new BAlarmRecord((BComponent)alarmSource.getSystemAlarm(), this.getAlarmClass(), alarmDataFacets);
            localObject.addAlarmFacet("sourceName", (BIDataValue)BString.make((String)sourceName));
            if (alarmSource.getUuid().equals("") && isNewRec) {
                localObject.setUuid(BUuid.make());
            } else {
                this.updateUUID(alarmSource, localObject, alarmRecordBean);
            }
            localObject.setPriority(alarmRecordBean.getPriority());
            localObject.setTimestamp(alarmRecordBean.getTimeOn());
            localObject.setNormalTime(alarmRecordBean.getTimeOff());
            localObject.setSourceState(alarmRecordBean.getAlarmSourceState());
            if (alarmRecordBean.getTimeOff().equals((Object)BAbsTime.NULL)) {
                localObject.setSourceState(BSourceState.offnormal);
            }
            if (BAckState.acked.equals((Object)alarmRecordBean.getAckState())) {
                localObject.setAckState(BAckState.acked);
                this.setAckDetails(localObject);
                localObject.setAckRequired(false);
            } else {
                localObject.setAckState(BAckState.unacked);
                localObject.setAckTime(BAbsTime.NULL);
                localObject.setAckRequired(true);
            }
            this.setAlarmNotes(localObject);
            this.setClearedAlarmStatus(alarmRecordBean, localObject);
            alarmSource.getSystemAlarm().setLastReceivedTime(BAbsTime.make());
            if (isNewRec && alarmSource.getLastAlarmStateKnown().equals("")) {
                this.routeAndStoretheAlarm(localObject, alarmSource);
            } else if (!(alarmSource.getLastAlarmAckStateKnown().equals("") || alarmSource.getUuid().equals("") || alarmSource.getLastAlarmAckStateKnown().equals(String.valueOf(alarmRecordBean.getAckState().getOrdinal())) && alarmSource.getLastAlarmStateKnown().equals(String.valueOf(alarmRecordBean.getAlarmSourceState().getOrdinal())))) {
                this.routeAndStoretheAlarm(localObject, alarmSource);
            }
        }
        catch (Exception e) {
            throw new SbcAlarmHandlingException(" Error occurred during adding an alarm record", e);
        }
    }

    private void updateUUID(BSbcAlarmSource alarmSource, BAlarmRecord localObject, AlarmRecordBean alarmRecordBean) {
        if (!alarmSource.getLastAlarmStateKnown().equals("")) {
            if (alarmSource.getLastAlarmStateKnown().equals("0") && alarmRecordBean.getAlarmSourceState().equals((Object)BSourceState.offnormal)) {
                localObject.setUuid(BUuid.make());
            } else if (alarmSource.getLastAlarmStateKnown().equals("1") && alarmRecordBean.getAlarmSourceState().equals((Object)BSourceState.normal) || !alarmSource.getLastAlarmAckStateKnown().equals(String.valueOf(alarmRecordBean.getAckState().getOrdinal()))) {
                if (this.getAlarmRecordFromDb(BUuid.make((String)alarmSource.getUuid())) != null) {
                    localObject.setUuid(BUuid.make((String)alarmSource.getUuid()));
                } else {
                    localObject.setUuid(BUuid.make());
                }
            }
        } else {
            localObject.setUuid(BUuid.make());
        }
    }

    private void routeAndStoretheAlarm(BAlarmRecord localObject, BSbcAlarmSource alarmSource) {
        alarmSource.getSystemAlarm().routeAlarm(localObject);
        alarmSource.setLastAlarmAckStateKnown(String.valueOf(localObject.getAckState().getOrdinal()));
        alarmSource.setLastAlarmStateKnown(String.valueOf(localObject.getSourceState().getOrdinal()));
        alarmSource.setUuid(localObject.getUuid().toString());
    }

    private void updateAlarm(AlarmRecordBean alarmRecordBean, BSbcAlarmSource alarmSource) {
        BUuid uuid = BUuid.make((String)alarmSource.getUuid());
        try {
            if (alarmRecordBean.getCounter() == 0 && this.getAlarmRecordFromDb(uuid) == null) {
                this.deleteAlarmSourceComponent(alarmRecordBean.getAlarmTypeId());
            } else {
                this.addAlarm(alarmRecordBean, alarmSource, false);
            }
        }
        catch (Exception e) {
            throw new SbcAlarmHandlingException(" Error occurred while updating an alarm record", e);
        }
    }

    private boolean hasRecurringAlarmOccurred(AlarmRecordBean alarmRecordBean, BUuid uuid) {
        boolean isAlarmStateChanged = false;
        try {
            BAlarmRecord record = this.getAlarmRecordFromDb(uuid);
            if (record != null) {
                if (alarmRecordBean.getCounter() == 0) {
                    isAlarmStateChanged = false;
                } else if (Integer.parseInt(record.getAlarmFacet("Count").toString()) != alarmRecordBean.getCounter()) {
                    isAlarmStateChanged = true;
                }
            }
        }
        catch (Exception e) {
            throw new SbcAlarmHandlingException(" Error occurred while validating if recurring alarm has occurred", e);
        }
        return isAlarmStateChanged;
    }

    private BAbsTime setAckDetails(BAlarmRecord localObject) {
        BAbsTime ackTime = BAbsTime.NULL;
        try {
            BAlarmRecord alarmRecord = this.getAlarmRecordFromDb(localObject.getUuid());
            if (alarmRecord != null) {
                localObject.setAckTime(alarmRecord.getAckTime());
                localObject.setUser(alarmRecord.getUser());
            }
        }
        catch (Exception e) {
            throw new SbcAlarmHandlingException(" Error occurred while fetching Ack Time", e);
        }
        return ackTime;
    }

    private void setAlarmNotes(BAlarmRecord localObject) {
        try {
            BFacets alarmData;
            BObject notesObj;
            BAlarmRecord rec = this.getAlarmRecordFromDb(localObject.getUuid());
            if (rec != null && (notesObj = (alarmData = rec.getAlarmData()).get("notes")) != null) {
                String notes = alarmData.get("notes").toString();
                localObject.addAlarmFacet("notes", (BIDataValue)BString.make((String)notes));
            }
        }
        catch (Exception e) {
            SbcUtil.sbcAlarmPoll.log(Level.INFO, "Error occurred while fetching notes for an alarm", e);
        }
    }

    private BAlarmRecord getAlarmRecordFromDb(BUuid uuid) {
        BAlarmRecord alarmRecord = null;
        try {
            AlarmDbConnection connection = this.getAlarmService().getAlarmDb().getDbConnection(null);
            alarmRecord = connection.getRecord(uuid);
        }
        catch (Exception e) {
            throw new SbcAlarmHandlingException(" Error occurred while fetching Alarm record from Niagara db", e);
        }
        return alarmRecord;
    }

    private Map<String, BIDataValue> getAlarmDataMap(AlarmRecordBean alarmRecordBean) {
        HashMap<String, BIDataValue> alarmInfoMap = new HashMap<String, BIDataValue>();
        alarmInfoMap.put("alarmTypeId", (BIDataValue)BInteger.make((int)alarmRecordBean.getAlarmTypeId()));
        alarmInfoMap.put("alarmListName", (BIDataValue)BString.make((String)this.getAlarmListName()));
        alarmInfoMap.put("msgText", (BIDataValue)BString.make((String)alarmRecordBean.getAlarmText().trim()));
        alarmInfoMap.put("priority", (BIDataValue)BInteger.make((int)alarmRecordBean.getPriority()));
        alarmInfoMap.put("Count", (BIDataValue)BString.make((String)Integer.toString(alarmRecordBean.getCounter())));
        alarmInfoMap.put("DeleteMode", (BIDataValue)BString.make((String)alarmRecordBean.getDelMode()));
        return alarmInfoMap;
    }

    public BIcon getIcon() {
        return icon;
    }

    public BAlarmService getAlarmService() {
        if (this.alarmService == null) {
            this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        return this.alarmService;
    }

    public String getAlarmText(int alarmId) {
        BFormat format = this.getAlarmTexts().get(String.valueOf(alarmId));
        if (format == null) {
            return "";
        }
        return format.getFormat();
    }

    public void doLoadAlarmTexts() {
        try {
            this.setFlags((Slot)language, 1);
            SBCAlarmTextLoader loader = new SBCAlarmTextLoader(this);
            loader.reloadAlarmTexts();
        }
        finally {
            this.setFlags((Slot)language, 0);
        }
    }

    private BAbsTime getTimeAsPerSupervisorTimeZone(String hexTimeString) {
        long alarmTimeStampInMilli = Long.parseLong(hexTimeString, 16) * 1000L;
        BSbcDevice device = (BSbcDevice)this.getParent().getParent();
        BTimeZone timeZone = device.getDeviceInformation().getPcdTimeZone();
        long utcTime = alarmTimeStampInMilli - (long)timeZone.getCurrentUtcOffset(alarmTimeStampInMilli);
        return BAbsTime.make((long)utcTime, (BTimeZone)BTimeZone.UTC);
    }

    public void doLoadToStation() {
        if (SbcUtil.sbcAlarmPoll.isLoggable(Level.FINEST)) {
            SbcUtil.sbcAlarmPoll.log(Level.FINEST, "Storing all the alarm lists to station for polling once the station is running.");
        }
        this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        SbcAlarmHandlingManager alarmHandlingManager = new SbcAlarmHandlingManager(this, this.alarmService);
        alarmHandlingManager.loadAllWaitingForAcknowledgeAlarmsToStation();
        alarmHandlingManager.loadAllWaitingForForceClearAlarmsToStation();
        if (SbcUtil.sbcAlarmPoll.isLoggable(Level.FINEST)) {
            SbcUtil.sbcAlarmPoll.log(Level.FINEST, "Stored all the alarm lists to station for further use.");
        }
    }

    public void doLoadToQueue() {
        if (SbcUtil.sbcAlarmPoll.isLoggable(Level.FINEST)) {
            SbcUtil.sbcAlarmPoll.log(Level.FINEST, "Recovering all the alarm list from the station.");
        }
        this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        SbcAlarmHandlingManager alarmHandlingManager = new SbcAlarmHandlingManager(this, this.alarmService);
        alarmHandlingManager.storeAllWaitingForAcknowledgeAlarmsToQueue();
        alarmHandlingManager.storeAllWaitingForForceClearAlarmsToQueue();
        if (SbcUtil.sbcAlarmPoll.isLoggable(Level.FINEST)) {
            SbcUtil.sbcAlarmPoll.log(Level.FINEST, "Reloading all the alarm list to queue so that it starts polling again.");
        }
    }

    public void doAcknowledgeAlarms() {
        this.alarmQueueManager.acknowledgeAllFailedAlarms();
    }

    public void doForceClearAlarms() {
        this.alarmQueueManager.forceClearAllFailedAlarms();
    }

    public SbcAlarmHandlingQueueManager getSbcAlarmHandlingQueueManager() {
        return this.alarmQueueManager;
    }
}

