/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.alarms;

import com.honeywell.sbc.BSbcDevice;
import com.honeywell.sbc.alarms.BSbcAlarmList;
import com.honeywell.sbc.alarms.BSbcAlarmSource;
import com.honeywell.sbc.util.SbcUtil;
import com.honeywell.sbc.web.SbcWebRequest;
import java.util.logging.Level;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.driver.alarm.BAlarmDeviceExt;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="forceClear", parameterType="alarm:AlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4), @NiagaraAction(name="sendAckRequest", parameterType="alarm:AlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4), @NiagaraAction(name="sendForceClearRequest", parameterType="alarm:AlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)})
public class BSbcAlarmDeviceExt
extends BAlarmDeviceExt
implements BIAlarmSource {
    public static final Action forceClear = BSbcAlarmDeviceExt.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action sendAckRequest = BSbcAlarmDeviceExt.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action sendForceClearRequest = BSbcAlarmDeviceExt.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BSbcAlarmDeviceExt.class);
    private AlarmSupport alarmSupport;

    public BBoolean forceClear(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(forceClear, (BValue)parameter, null);
    }

    public BBoolean sendAckRequest(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(sendAckRequest, (BValue)parameter, null);
    }

    public BBoolean sendForceClearRequest(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(sendForceClearRequest, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public AlarmSupport getAlarmSupport() {
        return this.alarmSupport;
    }

    public void started() throws Exception {
        super.started();
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        BBoolean isAckSuccess = BBoolean.FALSE;
        BSbcDevice device = (BSbcDevice)SbcUtil.getParentDevice((BComponent)this);
        BSbcAlarmList alarmList = (BSbcAlarmList)this.getParent().getParent();
        BSbcAlarmSource alarmSource = (BSbcAlarmSource)this.getParent();
        if (!bAlarmRecord.getUuid().encodeToString().equals(alarmSource.getUuid())) {
            SbcUtil.log_driver.log(Level.INFO, "Ack is triggered for an Alarm history record. Hence, Ack request will not be sent to the controller");
            this.alarmSupport.ackAlarm(bAlarmRecord);
            return BBoolean.TRUE;
        }
        if (device.isDataPolling()) {
            alarmList.getSbcAlarmHandlingQueueManager().queue(bAlarmRecord, "A");
            SbcUtil.log_driver.log(Level.WARNING, "Polling is in process. Ack Request has been queued");
        } else if (!device.isDataPolling()) {
            try {
                device.changeDataPollingStatus(true);
                isAckSuccess = this.doSendAckRequest(bAlarmRecord);
            }
            finally {
                device.changeDataPollingStatus(false);
            }
        }
        return isAckSuccess;
    }

    public void doRouteAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        alarmService.routeAlarm(bAlarmRecord);
    }

    private String getUrlForAlarmAck(int alarmTypeId) {
        BSbcAlarmList alarmList = (BSbcAlarmList)this.getParent().getParent();
        return "GET /cgi-bin/alarm.exe?" + alarmList.getAlarmListNumber() + "&ack&def&type&" + alarmTypeId + " HTTP/1.1\r\nHost: localhost\r\nUser-Agent: Saia.Net/2.1\r\n\r\n";
    }

    private String getUrlForForceClear(int alarmTypeId) {
        BSbcAlarmList alarmList = (BSbcAlarmList)this.getParent().getParent();
        return "GET /cgi-bin/alarm.exe?" + alarmList.getAlarmListNumber() + "&del&def&type&" + alarmTypeId + " HTTP/1.1\r\nHost: localhost\r\nUser-Agent: Saia.Net/2.1\r\n\r\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BBoolean doForceClear(BAlarmRecord bAlarmRecord) {
        BBoolean isAlarmClear = BBoolean.FALSE;
        BSbcDevice device = (BSbcDevice)SbcUtil.getParentDevice((BComponent)this);
        BSbcAlarmList alarmList = (BSbcAlarmList)this.getParent().getParent();
        if (device.isDataPolling()) {
            alarmList.getSbcAlarmHandlingQueueManager().queue(bAlarmRecord, "F");
            isAlarmClear = BBoolean.TRUE;
            SbcUtil.log_driver.log(Level.WARNING, "Polling is in process. Force Clear Request has been queued");
        } else if (!device.isDataPolling()) {
            try {
                device.changeDataPollingStatus(true);
                isAlarmClear = this.doSendForceClearRequest(bAlarmRecord);
            }
            finally {
                device.changeDataPollingStatus(false);
            }
        }
        return isAlarmClear;
    }

    public BBoolean doSendForceClearRequest(BAlarmRecord bAlarmRecord) {
        BBoolean isAlarmClear = BBoolean.FALSE;
        int alarmTypeId = Integer.parseInt(bAlarmRecord.getAlarmFacet("alarmTypeId").toString());
        BSbcDevice device = (BSbcDevice)SbcUtil.getParentDevice((BComponent)this);
        SbcWebRequest sbcWebRequest = new SbcWebRequest();
        BSbcAlarmList alarmList = (BSbcAlarmList)this.getParent().getParent();
        try {
            sbcWebRequest.sendWebRequest(this.getUrlForForceClear(alarmTypeId), device);
            String responseStr = sbcWebRequest.getResponseString(device);
            String[] responseArray = sbcWebRequest.getDataArrayFromResponse(responseStr);
            if ("Done".equals(responseArray[0])) {
                isAlarmClear = BBoolean.TRUE;
                SbcUtil.log_driver.log(Level.INFO, "PCD Alarm was cleared successfully");
            } else {
                alarmList.getSbcAlarmHandlingQueueManager().queue(bAlarmRecord, "F");
                SbcUtil.log_driver.log(Level.SEVERE, "Force clear failed in pcd. Unexpected response received from the controller. Force clear request has been queued");
            }
        }
        catch (Exception e) {
            alarmList.getSbcAlarmHandlingQueueManager().queue(bAlarmRecord, "F");
            SbcUtil.log_driver.log(Level.SEVERE, "Error occurred during Force Clear. Alarm record could not be cleared. Force clear request has been queued", e);
        }
        return isAlarmClear;
    }

    public BBoolean doSendAckRequest(BAlarmRecord bAlarmRecord) throws Exception {
        BBoolean isAckSuccess = BBoolean.FALSE;
        BSbcAlarmList alarmList = (BSbcAlarmList)this.getParent().getParent();
        try {
            int alarmTypeId = Integer.parseInt(bAlarmRecord.getAlarmFacet("alarmTypeId").toString());
            BSbcDevice device = (BSbcDevice)SbcUtil.getParentDevice((BComponent)this);
            SbcWebRequest sbcWebRequest = new SbcWebRequest();
            sbcWebRequest.sendWebRequest(this.getUrlForAlarmAck(alarmTypeId), device);
            String responseStr = sbcWebRequest.getResponseString(device);
            String[] responseArray = sbcWebRequest.getDataArrayFromResponse(responseStr);
            if ("Done".equals(responseArray[0])) {
                this.alarmSupport.ackAlarm(bAlarmRecord);
                isAckSuccess = BBoolean.TRUE;
                SbcUtil.log_driver.log(Level.INFO, "PCD Alarm was Acked successfully");
            } else {
                alarmList.getSbcAlarmHandlingQueueManager().queue(bAlarmRecord, "A");
                SbcUtil.log_driver.log(Level.SEVERE, "Ack failed in pcd. Response received. Unexpected response received from the controller. Ack request has been queued");
            }
        }
        catch (Exception e) {
            bAlarmRecord.setAckState(BAckState.unacked);
            bAlarmRecord.setAckTime(BAbsTime.NULL);
            bAlarmRecord.setAckRequired(true);
            this.doRouteAlarm(bAlarmRecord);
            alarmList.getSbcAlarmHandlingQueueManager().queue(bAlarmRecord, "A");
            SbcUtil.log_driver.log(Level.SEVERE, "Error occurred during Ack. Alarm record could not be acknowledged. Ack request has been queued", e);
        }
        return isAckSuccess;
    }
}

