/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc;

import com.honeywell.sbc.BSbcDevice;
import com.honeywell.sbc.BSbcDeviceFolder;
import com.honeywell.sbc.comm.BSbcUdpCommConfig;
import com.honeywell.sbc.comm.SbcCommListener;
import com.honeywell.sbc.util.SbcUtil;
import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.comm.NComm;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.license.Feature;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="udpConfig", type="BSbcUdpCommConfig", defaultValue="new BSbcUdpCommConfig()", flags=4), @NiagaraProperty(name="channelType", type="String", defaultValue="S-Bus TCP/IP", flags=1)})
public class BSbcNetwork
extends BNNetwork {
    public static final Property udpConfig = BSbcNetwork.newProperty((int)4, (BValue)new BSbcUdpCommConfig(), null);
    public static final Property channelType = BSbcNetwork.newProperty((int)1, (String)"S-Bus TCP/IP", null);
    public static final Type TYPE = Sys.loadType(BSbcNetwork.class);
    private int sequenceNumber = -1;
    private Object sequenceLock = new Object();
    private ConcurrentHashMap<Object, BAbsTime> existingTags = new ConcurrentHashMap();
    private ConcurrentHashMap<Object, BSbcDevice> tags = new ConcurrentHashMap();
    public static final Lexicon LEX = Lexicon.make(BSbcNetwork.class);
    private SbcCommListener commListener = null;

    public BSbcUdpCommConfig getUdpConfig() {
        return (BSbcUdpCommConfig)this.get(udpConfig);
    }

    public void setUdpConfig(BSbcUdpCommConfig v) {
        this.set(udpConfig, (BValue)v, null);
    }

    public String getChannelType() {
        return this.getString(channelType);
    }

    public void setChannelType(String v) {
        this.setString(channelType, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getNetworkName() {
        return "SbcIpDriverNetwork";
    }

    public Type getDeviceFolderType() {
        return BSbcDeviceFolder.TYPE;
    }

    public Type getDeviceType() {
        return BSbcDevice.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("SaiaBurgessControls", "SBCIpDriver");
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(status)) {
            this.getUdpConfig().statusUpdate();
        }
    }

    public void started() throws Exception {
        super.started();
        this.getUdpConfig().setNetwork(this);
        this.commListener = new SbcCommListener(this.getUdpConfig());
        this.getUdpConfig().setDefaultListener(this.commListener);
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] kids = super.getNavChildren();
        Array acc = new Array(BINavNode.class);
        BTuningPolicyMap tuningPolicy = this.getTuningPolicies();
        tuningPolicy.getDefaultPolicy().setWriteOnStart(false);
        tuningPolicy.getDefaultPolicy().setWriteOnUp(false);
        tuningPolicy.getDefaultPolicy().setWriteOnEnabled(false);
        acc.add((Object)tuningPolicy);
        for (int i = 0; i < kids.length; ++i) {
            acc.add((Object)kids[i]);
        }
        return (BINavNode[])acc.trim();
    }

    public void removeTag(Object input) {
        if (this.tags.containsKey(input)) {
            this.tags.remove(input);
            this.existingTags.remove(input);
        }
    }

    public void setTags(Object input, BSbcDevice device) {
        if (!this.tags.containsKey(input)) {
            this.tags.put(input, device);
            this.existingTags.put(input, BAbsTime.now());
        } else if (SbcUtil.sbcPointPoll.isLoggable(Level.FINEST)) {
            SbcUtil.sbcPointPoll.log(Level.FINEST, String.format("Sequence Number is in used - %s", input.toString()));
        }
    }

    public Map<Object, BSbcDevice> getTags() {
        return this.tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSequenceNumber() {
        Object object = this.sequenceLock;
        synchronized (object) {
            if (this.sequenceNumber == 65535) {
                this.sequenceNumber = -1;
            }
            ++this.sequenceNumber;
            boolean flag = true;
            while (flag) {
                if (!this.tags.containsKey(this.sequenceNumber)) {
                    flag = false;
                    continue;
                }
                if (this.isItStillValid(this.sequenceNumber)) continue;
                if (SbcUtil.sequenceTracker.isLoggable(Level.SEVERE)) {
                    SbcUtil.sequenceTracker.log(Level.SEVERE, String.format("Sequence Number is already in use - %d. Hence generating new sequence number", this.sequenceNumber));
                }
                if (this.sequenceNumber == 65535) {
                    this.sequenceNumber = -1;
                }
                ++this.sequenceNumber;
            }
            if (SbcUtil.sequenceTracker.isLoggable(Level.SEVERE)) {
                SbcUtil.sequenceTracker.log(Level.SEVERE, String.format("current sequence number is %d", this.sequenceNumber));
            }
            return this.sequenceNumber;
        }
    }

    private boolean isItStillValid(int seqNo) {
        BAbsTime requestedTime = this.existingTags.get(seqNo);
        if (Objects.nonNull(requestedTime) && requestedTime.delta(BAbsTime.now()).getMillis() > BRelTime.makeMinutes((int)3).getMillis()) {
            this.tags.remove(seqNo);
            this.existingTags.remove(seqNo);
            return true;
        }
        return false;
    }

    public NComm ucomm() {
        return (NComm)this.getUdpConfig().comm();
    }
}

