/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc;

import com.honeywell.sbc.BSbcNetwork;
import com.honeywell.sbc.alarms.BSbcAlarmList;
import com.honeywell.sbc.alarms.BSbcAlarms;
import com.honeywell.sbc.common.BSbcWorker;
import com.honeywell.sbc.common.SbcQueueManager;
import com.honeywell.sbc.enums.BSbcMediaTypeEnum;
import com.honeywell.sbc.hdlogs.BSbcHDLogs;
import com.honeywell.sbc.message.ISbcMessage;
import com.honeywell.sbc.message.SbcRequestMessage;
import com.honeywell.sbc.message.SbcResponseMessage;
import com.honeywell.sbc.message.commands.Multimedia;
import com.honeywell.sbc.message.commands.ReadDBSize;
import com.honeywell.sbc.message.commands.ReadDbElement;
import com.honeywell.sbc.message.commands.ReadPcdStatus;
import com.honeywell.sbc.message.commands.ReadRegister;
import com.honeywell.sbc.message.commands.ReadSingleByteCommand;
import com.honeywell.sbc.message.commands.ReadText;
import com.honeywell.sbc.message.commands.ReadTimer;
import com.honeywell.sbc.point.BSbcDbRam;
import com.honeywell.sbc.point.BSbcPointDeviceExt;
import com.honeywell.sbc.point.BSbcProxyExt;
import com.honeywell.sbc.stations.BSbcSubStation;
import com.honeywell.sbc.util.BSbcDeviceInformation;
import com.honeywell.sbc.util.PointData;
import com.honeywell.sbc.util.SbcByteConverter;
import com.honeywell.sbc.util.SbcUtil;
import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.io.TypedOutputStream;
import com.tridium.ndriver.poll.BINPollable;
import com.tridium.ndriver.poll.BNPollScheduler;
import com.tridium.ndriver.util.SfUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pollScheduler", type="BNPollScheduler", defaultValue="new BNPollScheduler()"), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="ipAddress", type="BIpAddress", defaultValue="new BIpAddress()"), @NiagaraProperty(name="stationId", type="int", defaultValue="0"), @NiagaraProperty(name="readTimeout", type="int", defaultValue="250", facets={@Facet(name="BFacets.MIN", value="BInteger.make(200)"), @Facet(name="BFacets.MAX", value="BInteger.make(60000)"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"millisecond\")")}), @NiagaraProperty(name="deviceType", type="String", defaultValue="Head Station", flags=5), @NiagaraProperty(name="points", type="BSbcPointDeviceExt", defaultValue="new BSbcPointDeviceExt()"), @NiagaraProperty(name="alarms", type="BSbcAlarms", defaultValue="new BSbcAlarms()"), @NiagaraProperty(name="histories", type="BSbcHDLogs", defaultValue="new BSbcHDLogs()"), @NiagaraProperty(name="DeviceInformation", type="BSbcDeviceInformation", defaultValue="new BSbcDeviceInformation()"), @NiagaraProperty(name="numberParallelPointPolls", type="int", defaultValue="1", flags=4, facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="5")}), @NiagaraProperty(name="dataPollingStatus", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="numberOfAlarmPolls", type="int", defaultValue="1", flags=4, facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="10")}), @NiagaraProperty(name="completedAlarmPolls", type="int", defaultValue="0", flags=5), @NiagaraProperty(name="ftpUsername", type="String", defaultValue=""), @NiagaraProperty(name="ftpPassword", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="httpPassword", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="worker", type="BSbcWorker", defaultValue="new BSbcWorker()", flags=4), @NiagaraProperty(name="programCRC", type="String", defaultValue="", flags=5), @NiagaraProperty(name="projectName", type="String", defaultValue="", flags=5), @NiagaraProperty(name="deviceName", type="String", defaultValue="", flags=4), @NiagaraProperty(name="isProgramCRCRead", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="programCRCMismatcherror", type="String", defaultValue=""), @NiagaraProperty(name="statusErrorMessage", type="String", defaultValue=""), @NiagaraProperty(name="uuid", type="BUuid", defaultValue="BUuid.DEFAULT", flags=69), @NiagaraProperty(name="statusUuid", type="BUuid", defaultValue="BUuid.DEFAULT", flags=69)})
@NiagaraActions(value={@NiagaraAction(name="readAlarms", flags=20), @NiagaraAction(name="readMultiPoints", flags=20)})
public class BSbcDevice
extends BNDevice
implements BINPollable {
    public static final Property status = BSbcDevice.newProperty((int)75, (BValue)BStatus.ok, (BFacets)SfUtil.incl((String)"ed.ro"));
    public static final Property pollScheduler = BSbcDevice.newProperty((int)0, (BValue)new BNPollScheduler(), null);
    public static final Property pollFrequency = BSbcDevice.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property ipAddress = BSbcDevice.newProperty((int)0, (BValue)new BIpAddress(), null);
    public static final Property stationId = BSbcDevice.newProperty((int)0, (int)0, null);
    public static final Property readTimeout = BSbcDevice.newProperty((int)0, (int)250, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)200)), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)60000))), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond"))));
    public static final Property deviceType = BSbcDevice.newProperty((int)5, (String)"Head Station", null);
    public static final Property points = BSbcDevice.newProperty((int)0, (BValue)new BSbcPointDeviceExt(), null);
    public static final Property alarms = BSbcDevice.newProperty((int)0, (BValue)new BSbcAlarms(), null);
    public static final Property histories = BSbcDevice.newProperty((int)0, (BValue)new BSbcHDLogs(), null);
    public static final Property DeviceInformation = BSbcDevice.newProperty((int)0, (BValue)new BSbcDeviceInformation(), null);
    public static final Property numberParallelPointPolls = BSbcDevice.newProperty((int)4, (int)1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)5)));
    public static final Property dataPollingStatus = BSbcDevice.newProperty((int)5, (boolean)false, null);
    public static final Property numberOfAlarmPolls = BSbcDevice.newProperty((int)4, (int)1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)10)));
    public static final Property completedAlarmPolls = BSbcDevice.newProperty((int)5, (int)0, null);
    public static final Property ftpUsername = BSbcDevice.newProperty((int)0, (String)"", null);
    public static final Property ftpPassword = BSbcDevice.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property httpPassword = BSbcDevice.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property worker = BSbcDevice.newProperty((int)4, (BValue)new BSbcWorker(), null);
    public static final Property programCRC = BSbcDevice.newProperty((int)5, (String)"", null);
    public static final Property projectName = BSbcDevice.newProperty((int)5, (String)"", null);
    public static final Property deviceName = BSbcDevice.newProperty((int)4, (String)"", null);
    public static final Property isProgramCRCRead = BSbcDevice.newProperty((int)5, (boolean)false, null);
    public static final Property programCRCMismatcherror = BSbcDevice.newProperty((int)0, (String)"", null);
    public static final Property statusErrorMessage = BSbcDevice.newProperty((int)0, (String)"", null);
    public static final Property uuid = BSbcDevice.newProperty((int)69, (BValue)BUuid.DEFAULT, null);
    public static final Property statusUuid = BSbcDevice.newProperty((int)69, (BValue)BUuid.DEFAULT, null);
    public static final Action readAlarms = BSbcDevice.newAction((int)20, null);
    public static final Action readMultiPoints = BSbcDevice.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BSbcDevice.class);
    private static final int SLEEP_TIME = 1000;
    private String[] clock7daySlots = new String[]{"MondayOn", "TuesdayOn", "WednesdayOn", "ThursdayOn", "FridayOn", "SaturdayOn", "SundayOn", "MondayOff", "TuesdayOff", "WednesdayOff", "ThursdayOff", "FridayOff", "SaturdayOff", "SundayOff"};
    private Map<Object, List<BControlPoint>> tagPointsMap = new ConcurrentHashMap<Object, List<BControlPoint>>();
    private Map<Object, BControlPoint> tagTextPointsMap = new ConcurrentHashMap<Object, BControlPoint>();
    private Map<Object, List<BControlPoint>> tagClockPointsMap = new ConcurrentHashMap<Object, List<BControlPoint>>();
    private Map<Object, BAbsTime> tagTimestampMap = new ConcurrentHashMap<Object, BAbsTime>();
    private Map<Object, Integer> clockTagMemoryMap = new ConcurrentHashMap<Object, Integer>();
    private List<BControlPoint> pointSubscriptionList = new CopyOnWriteArrayList<BControlPoint>();
    private Queue<BControlPoint> textPoints = new ConcurrentLinkedQueue<BControlPoint>();
    private Queue<PointData> clockPoints = new ConcurrentLinkedQueue<PointData>();
    private Queue<PointData> otherPoints = new ConcurrentLinkedQueue<PointData>();
    private static final int NUMBER_OF_POINTS_PER_FRAME = 30;
    private Object lock = new Object();
    private static boolean atSteady = false;

    public BNPollScheduler getPollScheduler() {
        return (BNPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BNPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public BIpAddress getIpAddress() {
        return (BIpAddress)this.get(ipAddress);
    }

    public void setIpAddress(BIpAddress v) {
        this.set(ipAddress, (BValue)v, null);
    }

    public int getStationId() {
        return this.getInt(stationId);
    }

    public void setStationId(int v) {
        this.setInt(stationId, v, null);
    }

    public int getReadTimeout() {
        return this.getInt(readTimeout);
    }

    public void setReadTimeout(int v) {
        this.setInt(readTimeout, v, null);
    }

    public String getDeviceType() {
        return this.getString(deviceType);
    }

    public void setDeviceType(String v) {
        this.setString(deviceType, v, null);
    }

    public BSbcPointDeviceExt getPoints() {
        return (BSbcPointDeviceExt)this.get(points);
    }

    public void setPoints(BSbcPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    public BSbcAlarms getAlarms() {
        return (BSbcAlarms)this.get(alarms);
    }

    public void setAlarms(BSbcAlarms v) {
        this.set(alarms, (BValue)v, null);
    }

    public BSbcHDLogs getHistories() {
        return (BSbcHDLogs)this.get(histories);
    }

    public void setHistories(BSbcHDLogs v) {
        this.set(histories, (BValue)v, null);
    }

    public BSbcDeviceInformation getDeviceInformation() {
        return (BSbcDeviceInformation)this.get(DeviceInformation);
    }

    public void setDeviceInformation(BSbcDeviceInformation v) {
        this.set(DeviceInformation, (BValue)v, null);
    }

    public int getNumberParallelPointPolls() {
        return this.getInt(numberParallelPointPolls);
    }

    public void setNumberParallelPointPolls(int v) {
        this.setInt(numberParallelPointPolls, v, null);
    }

    public boolean getDataPollingStatus() {
        return this.getBoolean(dataPollingStatus);
    }

    public void setDataPollingStatus(boolean v) {
        this.setBoolean(dataPollingStatus, v, null);
    }

    public int getNumberOfAlarmPolls() {
        return this.getInt(numberOfAlarmPolls);
    }

    public void setNumberOfAlarmPolls(int v) {
        this.setInt(numberOfAlarmPolls, v, null);
    }

    public int getCompletedAlarmPolls() {
        return this.getInt(completedAlarmPolls);
    }

    public void setCompletedAlarmPolls(int v) {
        this.setInt(completedAlarmPolls, v, null);
    }

    public String getFtpUsername() {
        return this.getString(ftpUsername);
    }

    public void setFtpUsername(String v) {
        this.setString(ftpUsername, v, null);
    }

    public BPassword getFtpPassword() {
        return (BPassword)this.get(ftpPassword);
    }

    public void setFtpPassword(BPassword v) {
        this.set(ftpPassword, (BValue)v, null);
    }

    public BPassword getHttpPassword() {
        return (BPassword)this.get(httpPassword);
    }

    public void setHttpPassword(BPassword v) {
        this.set(httpPassword, (BValue)v, null);
    }

    public BSbcWorker getWorker() {
        return (BSbcWorker)this.get(worker);
    }

    public void setWorker(BSbcWorker v) {
        this.set(worker, (BValue)v, null);
    }

    public String getProgramCRC() {
        return this.getString(programCRC);
    }

    public void setProgramCRC(String v) {
        this.setString(programCRC, v, null);
    }

    public String getProjectName() {
        return this.getString(projectName);
    }

    public void setProjectName(String v) {
        this.setString(projectName, v, null);
    }

    public String getDeviceName() {
        return this.getString(deviceName);
    }

    public void setDeviceName(String v) {
        this.setString(deviceName, v, null);
    }

    public boolean getIsProgramCRCRead() {
        return this.getBoolean(isProgramCRCRead);
    }

    public void setIsProgramCRCRead(boolean v) {
        this.setBoolean(isProgramCRCRead, v, null);
    }

    public String getProgramCRCMismatcherror() {
        return this.getString(programCRCMismatcherror);
    }

    public void setProgramCRCMismatcherror(String v) {
        this.setString(programCRCMismatcherror, v, null);
    }

    public String getStatusErrorMessage() {
        return this.getString(statusErrorMessage);
    }

    public void setStatusErrorMessage(String v) {
        this.setString(statusErrorMessage, v, null);
    }

    public BUuid getUuid() {
        return (BUuid)this.get(uuid);
    }

    public void setUuid(BUuid v) {
        this.set(uuid, (BValue)v, null);
    }

    public BUuid getStatusUuid() {
        return (BUuid)this.get(statusUuid);
    }

    public void setStatusUuid(BUuid v) {
        this.set(statusUuid, (BValue)v, null);
    }

    public void readAlarms() {
        this.invoke(readAlarms, null, null);
    }

    public void readMultiPoints() {
        this.invoke(readMultiPoints, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BSbcNetwork.TYPE;
    }

    public BSbcNetwork getSbcNetwork() {
        return (BSbcNetwork)this.getNetwork();
    }

    public void started() throws Exception {
        super.started();
        atSteady = false;
        this.changeDataPollingStatus(false);
        this.getPollScheduler().subscribe((BIPollable)this);
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.readRequiredInformation();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if ((property.equals(ipAddress) || property.equals(stationId) || property.equals(enabled)) && this.getEnabled()) {
            this.readRequiredInformation();
        }
        if (property.equals(enabled)) {
            this.disableAllSubstations(this.getEnabled());
        }
    }

    public void readRequiredInformation() {
        this.invoke(ping, null);
    }

    public void stopped() throws Exception {
        this.getPollScheduler().unsubscribe((BIPollable)this);
        this.changeDataPollingStatus(false);
        super.stopped();
    }

    private void pingSubstations() {
        BSbcSubStation[] subStations;
        for (BSbcSubStation subStation : subStations = (BSbcSubStation[])this.getChildren(BSbcSubStation.class)) {
            try {
                if (!Objects.nonNull((Object)subStation)) continue;
                subStation.invoke(BSbcSubStation.ping, null);
            }
            catch (Exception exp) {
                if (!SbcUtil.log_driver.isLoggable(Level.FINER)) continue;
                SbcUtil.log_driver.log(Level.SEVERE, String.format("Unable to ping sub station: %s", subStation.getSlotPath().toString()), exp);
            }
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action.equals(ping)) {
            Thread pingThd = new Thread(() -> this.doPing());
            pingThd.setName("SBCDevicePingThread");
            pingThd.start();
        } else {
            this.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, argument, cx));
        }
        return null;
    }

    public void doPing() {
        if (this.getEnabled() && this.isRunning() && Sys.atSteadyState()) {
            SbcUtil.log_driver.log(Level.INFO, "Device pinging: " + this.getDisplayName(null));
            SbcRequestMessage requestMessage = this.formPingRequest();
            requestMessage.setResponseTimeOut(this.getReadTimeout());
            try {
                ((NComm)this.getSbcIpDriverNetwork().getUdpConfig().comm()).sendRequest((NMessage)requestMessage);
                this.pingOk();
                this.setStatus(BStatus.ok);
                SbcUtil.log_driver.log(Level.INFO, "Reading PCD Information: " + this.getDisplayName(null));
                this.readDeviceInformation();
                SbcUtil.sendProgramInfoRequest(this);
                this.pingAllSubStations();
            }
            catch (Exception e) {
                SbcUtil.log_driver.log(Level.SEVERE, "Device down or not reachable " + this.getDisplayName(null), e);
                this.pingFail(e.getMessage());
                this.updateAllSubstations(e.getMessage());
            }
        } else {
            SbcUtil.log_driver.log(Level.INFO, "Unable to ping due to device disabled");
        }
    }

    private void disableAllSubstations(boolean isHeadStationEnabled) {
        BSbcSubStation[] subStations;
        for (BSbcSubStation subStation : subStations = (BSbcSubStation[])this.getChildren(BSbcSubStation.class)) {
            try {
                if (!Objects.nonNull((Object)subStation)) continue;
                subStation.setEnabled(isHeadStationEnabled);
            }
            catch (Exception exp) {
                if (!SbcUtil.log_driver.isLoggable(Level.FINER)) continue;
                SbcUtil.log_driver.log(Level.SEVERE, String.format("Unable to update fault state to sub station: %s", subStation.getSlotPath().toString()), exp);
            }
        }
    }

    private void updateAllSubstations(String message) {
        BSbcSubStation[] subStations;
        for (BSbcSubStation subStation : subStations = (BSbcSubStation[])this.getChildren(BSbcSubStation.class)) {
            try {
                if (!Objects.nonNull((Object)subStation)) continue;
                subStation.pingFail(message);
            }
            catch (Exception exp) {
                if (!SbcUtil.log_driver.isLoggable(Level.FINER)) continue;
                SbcUtil.log_driver.log(Level.SEVERE, String.format("Unable to update fault state to sub station: %s", subStation.getSlotPath().toString()), exp);
            }
        }
    }

    private void pingAllSubStations() {
        block3: {
            try {
                if ("Head Station".equalsIgnoreCase(this.getDeviceType())) {
                    this.pingSubstations();
                }
            }
            catch (Exception exp) {
                if (!SbcUtil.log_driver.isLoggable(Level.FINER)) break block3;
                SbcUtil.log_driver.log(Level.FINER, "Unexpected error while pinging sub stations of " + this.getDisplayName(null), exp);
            }
        }
    }

    private void readDeviceInformation() {
        block3: {
            try {
                BSbcDeviceInformation information = this.getDeviceInformation();
                if (information.isRunning()) {
                    this.getDeviceInformation().invoke(BSbcDeviceInformation.readSystemInfo, null);
                }
            }
            catch (Exception exp) {
                if (!SbcUtil.log_driver.isLoggable(Level.FINER)) break block3;
                SbcUtil.log_driver.log(Level.FINER, "Unexpected error while reading device information of " + this.getDisplayName(null), exp);
            }
        }
    }

    private SbcRequestMessage formPingRequest() {
        int nextSeqNo = this.getSbcIpDriverNetwork().getSequenceNumber();
        SbcRequestMessage requestMessage = new SbcRequestMessage(this.getStationId(), nextSeqNo);
        requestMessage.setAddress((BAddress)this.getIpAddress());
        ReadPcdStatus readPcdStatus = ReadPcdStatus.getInstance();
        requestMessage.appendPayload(readPcdStatus.getPayload());
        return requestMessage;
    }

    public void doReadMultiPoints() {
        block9: {
            if (!this.isRunning()) {
                return;
            }
            if (SbcUtil.sbcPointPoll.isLoggable(Level.FINEST)) {
                SbcUtil.sbcPointPoll.log(Level.FINEST, String.format("%s **** started polling points data.", this.getDisplayName(null)));
            }
            if (this.textPoints.isEmpty() && this.otherPoints.isEmpty() && this.clockPoints.isEmpty()) {
                try {
                    if (SbcUtil.sbcPointPoll.isLoggable(Level.FINEST)) {
                        SbcUtil.sbcPointPoll.log(Level.FINEST, String.format("%d **** total number of points which are ready for polling.", this.pointSubscriptionList.size()));
                    }
                    if (!this.pointSubscriptionList.isEmpty()) {
                        this.formSubscribedPointsInFrames();
                        this.pollPointData();
                    }
                    break block9;
                }
                catch (Exception exp) {
                    if (SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) {
                        SbcUtil.sbcPointPoll.log(Level.FINER, "Error occurred while polling points data.", exp);
                    }
                    break block9;
                }
            }
            this.checkForTimeOutsAndInitiateNextSet();
            if (SbcUtil.sbcPointPoll.isLoggable(Level.FINEST)) {
                SbcUtil.sbcPointPoll.log(Level.FINEST, String.format("%s of %d - other points***********%d text points", this.getDisplayName(null), this.otherPoints.size(), this.textPoints.size()));
                SbcUtil.sbcPointPoll.log(Level.FINEST, String.format("%s **** previous points poll is still in progress.", this.getDisplayName(null)));
            }
        }
    }

    private void checkForTimeOutsAndInitiateNextSet() {
        Set<Map.Entry<Object, BAbsTime>> entrySet = this.tagTimestampMap.entrySet();
        for (Map.Entry<Object, BAbsTime> entry : entrySet) {
            if (entry.getValue().delta(BAbsTime.now()).getMillis() <= (long)(this.getReadTimeout() + 250)) continue;
            if (this.tagPointsMap.containsKey(entry.getKey())) {
                this.tagPointsMap.remove(entry.getKey());
            }
            if (this.tagTextPointsMap.containsKey(entry.getKey())) {
                this.tagTextPointsMap.remove(entry.getKey());
            }
            if (this.tagClockPointsMap.containsKey(entry.getKey())) {
                this.tagClockPointsMap.remove(entry.getKey());
            }
            this.tagTextPointsMap.remove(entry.getKey());
        }
        this.pollPointData();
    }

    private void formSubscribedPointsInFrames() {
        ArrayList<Object> payloadList = new ArrayList<byte[]>();
        ArrayList<Object> controlPointList = new ArrayList<BControlPoint>();
        ArrayList<byte[]> clockPayloadList = new ArrayList<byte[]>();
        ArrayList<BControlPoint> clockControlPointList = new ArrayList<BControlPoint>();
        int position = 1;
        for (int index = 0; index < this.pointSubscriptionList.size(); ++index) {
            PointData data;
            BControlPoint point = this.pointSubscriptionList.get(index);
            if (this.isClock(point)) {
                int memoryAddress = Integer.parseInt(((BSbcProxyExt)point.getProxyExt()).getMemoryAddress());
                for (int clockIndex = 0; clockIndex < 14; ++clockIndex) {
                    ISbcMessage subRequest = this.getClockRequest(memoryAddress);
                    if (subRequest != null) {
                        clockPayloadList.add(subRequest.getPayload());
                        clockControlPointList.add(point);
                    }
                    ++memoryAddress;
                }
                data = new PointData(clockControlPointList, clockPayloadList);
                this.clockPoints.add(data);
                continue;
            }
            if (this.isTextRAM(point)) {
                this.textPoints.add(point);
                continue;
            }
            ISbcMessage subRequest = this.getSubRequest(point);
            if (subRequest != null) {
                payloadList.add(subRequest.getPayload());
                controlPointList.add(point);
            }
            if (position == 30) {
                position = 0;
                data = new PointData(controlPointList, payloadList);
                this.otherPoints.add(data);
                payloadList = new ArrayList();
                controlPointList = new ArrayList();
            }
            ++position;
        }
        if (!clockPayloadList.isEmpty()) {
            PointData data = new PointData(clockControlPointList, clockPayloadList);
            this.clockPoints.add(data);
        }
        if (!payloadList.isEmpty()) {
            PointData data = new PointData(controlPointList, payloadList);
            this.otherPoints.add(data);
        }
    }

    private void pollPointData() {
        if (SbcUtil.sbcPointPoll.isLoggable(Level.FINEST)) {
            SbcUtil.sbcPointPoll.log(Level.FINEST, String.format("%s **** total number of points which are polling other than text/text rams is %d", this.getDisplayName(null), this.otherPoints.size()));
            SbcUtil.sbcPointPoll.log(Level.FINEST, String.format("%s **** total number of text/text rams which are polling is %d", this.getDisplayName(null), this.textPoints.size()));
            SbcUtil.sbcPointPoll.log(Level.FINEST, String.format("%s **** total number of clock points which are polling is %d", this.getDisplayName(null), this.clockPoints.size()));
        }
        if (!this.clockPoints.isEmpty()) {
            this.pollClockPointsData();
        } else if (!this.otherPoints.isEmpty()) {
            this.pollOtherPointsData();
        } else if (!this.textPoints.isEmpty()) {
            this.pollTextPointData();
        }
    }

    private void pollClockPointsData() {
        PointData data;
        for (int index = 0; index < this.getNumberParallelPointPolls() && (data = this.clockPoints.poll()) != null; ++index) {
            this.sendMultiMediaRequest(data.getRequestDataList(), data.getActualPointList(), true);
        }
    }

    private void pollOtherPointsData() {
        PointData data;
        for (int index = 0; index < this.getNumberParallelPointPolls() && (data = this.otherPoints.poll()) != null; ++index) {
            this.sendMultiMediaRequest(data.getRequestDataList(), data.getActualPointList(), false);
        }
    }

    private void pollTextPointData() {
        BControlPoint point = this.textPoints.poll();
        if (point != null) {
            this.sendReadTextRequests(point);
        }
    }

    private boolean isTextRAM(BControlPoint controlPoint) {
        int mediaType = this.getSbcMediaType(controlPoint);
        return mediaType == 11 || mediaType == 10;
    }

    private boolean isClock(BControlPoint controlPoint) {
        int mediaType = this.getSbcMediaType(controlPoint);
        return mediaType == 12;
    }

    public int getSbcMediaType(BControlPoint bControlPoint) {
        BSbcMediaTypeEnum sbcMediaType = (BSbcMediaTypeEnum)bControlPoint.get("mediaType");
        return sbcMediaType.getOrdinal();
    }

    public ISbcMessage getSubRequest(BControlPoint bControlPoint) {
        ISbcMessage subRequest;
        block10: {
            subRequest = null;
            try {
                BSbcProxyExt sbcDriverProxyExt = (BSbcProxyExt)bControlPoint.getProxyExt();
                switch (this.getSbcMediaType(bControlPoint)) {
                    case 4: {
                        subRequest = new ReadSingleByteCommand(Integer.parseInt(sbcDriverProxyExt.getMemoryAddress()), 3);
                        break;
                    }
                    case 5: {
                        subRequest = new ReadSingleByteCommand(Integer.parseInt(sbcDriverProxyExt.getMemoryAddress()), 5);
                        break;
                    }
                    case 0: 
                    case 1: {
                        subRequest = new ReadSingleByteCommand(Integer.parseInt(sbcDriverProxyExt.getMemoryAddress()), 2);
                        break;
                    }
                    case 9: {
                        BString str = (BString)bControlPoint.get("dbElement");
                        int dbElem = Integer.parseInt(str.getString());
                        BSbcDbRam dbRam = (BSbcDbRam)bControlPoint.getNavParent();
                        sbcDriverProxyExt.setMemoryAddress(dbRam.getBlockDetails().getMemoryAddress());
                        subRequest = new ReadDbElement(Integer.parseInt(sbcDriverProxyExt.getMemoryAddress()), 0, dbElem);
                        break;
                    }
                    case 7: {
                        subRequest = new ReadSingleByteCommand(Integer.parseInt(sbcDriverProxyExt.getMemoryAddress()), 0);
                        break;
                    }
                    case 6: {
                        subRequest = new ReadTimer(Integer.parseInt(sbcDriverProxyExt.getMemoryAddress()));
                        break;
                    }
                    default: {
                        subRequest = new ReadRegister(Integer.parseInt(sbcDriverProxyExt.getMemoryAddress()));
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (!SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) break block10;
                SbcUtil.sbcPointPoll.log(Level.FINER, "Error occurred during preparing sub request for a control point", e);
            }
        }
        return subRequest;
    }

    public ISbcMessage getClockRequest(int memoryAddress) {
        ReadRegister subRequest;
        block2: {
            subRequest = null;
            try {
                subRequest = new ReadRegister(memoryAddress);
            }
            catch (Exception e) {
                if (!SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) break block2;
                SbcUtil.sbcPointPoll.log(Level.FINER, "Error occurred during preparing sub request for a control point", e);
            }
        }
        return subRequest;
    }

    private void sendMultiMediaRequest(List<byte[]> subRequestList, List<BControlPoint> pointList, boolean isClockRequest) {
        block5: {
            try {
                int nextSeqNo = this.getSbcIpDriverNetwork().getSequenceNumber();
                SbcRequestMessage requestMessage = new SbcRequestMessage(this.getStationId(), nextSeqNo);
                requestMessage.setResponseTimeOut(this.getReadTimeout());
                Multimedia multimediaCommand = new Multimedia(subRequestList);
                requestMessage.appendPayload(multimediaCommand.getPayload());
                requestMessage.setAddress((BAddress)this.getIpAddress());
                this.getSbcIpDriverNetwork().setTags(requestMessage.getTag(), this);
                if (isClockRequest) {
                    this.tagClockPointsMap.put(requestMessage.getTag(), pointList);
                } else {
                    this.tagPointsMap.put(requestMessage.getTag(), pointList);
                }
                this.tagTimestampMap.put(requestMessage.getTag(), BAbsTime.make());
                this.logPoints(requestMessage.getTag(), pointList, "REQUEST");
                ((NComm)this.getSbcIpDriverNetwork().getUdpConfig().comm()).sendMessage((NMessage)requestMessage);
                if (SbcUtil.sbcPointPoll.isLoggable(Level.FINEST)) {
                    SbcUtil.sbcPointPoll.log(Level.FINEST, this.getDisplayName(null).concat("===Sending request to poll points data with tag===").concat(requestMessage.getTag().toString()));
                }
            }
            catch (Exception e) {
                if (!SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) break block5;
                SbcUtil.sbcPointPoll.log(Level.FINER, "Error occurred during sending multimedia request", e);
            }
        }
    }

    private void sendReadTextRequests(BControlPoint point) {
        block2: {
            try {
                this.pollTextPointSize(point);
            }
            catch (Exception e) {
                if (!SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) break block2;
                SbcUtil.sbcPointPoll.log(Level.FINER, "Something went wrong while reading TEXT for the control point:: " + point.getName() + "\n" + e.getMessage(), e);
            }
        }
    }

    public void pollTextPointSize(BControlPoint controlPoint) throws Exception {
        block4: {
            if (SbcUtil.sbcPointPoll.isLoggable(Level.FINEST)) {
                SbcUtil.sbcPointPoll.log(Level.FINEST, " Reading size of the Text/Text RAM Point :: " + controlPoint.getName());
            }
            BSbcProxyExt proxyExt = (BSbcProxyExt)controlPoint.getProxyExt();
            int nextSeqNo = this.getSbcIpDriverNetwork().getSequenceNumber();
            SbcRequestMessage requestMessage = new SbcRequestMessage(this.getStationId(), nextSeqNo);
            requestMessage.setResponseTimeOut(this.getReadTimeout());
            ReadDBSize readPoint = new ReadDBSize(Integer.parseInt(proxyExt.getMemoryAddress()), 6);
            try {
                requestMessage.appendPayload(readPoint.getPayload());
                requestMessage.setAddress((BAddress)this.getIpAddress());
                if (SbcUtil.sbcPointPoll.isLoggable(Level.FINEST)) {
                    SbcUtil.sbcPointPoll.log(Level.FINEST, "**** The ip address set in getTextSizeOfPoint :: " + this.getIpAddress());
                }
                this.tagTextPointsMap.put(requestMessage.getTag(), controlPoint);
                this.tagTimestampMap.put(requestMessage.getTag(), BAbsTime.make());
                this.getSbcIpDriverNetwork().setTags(requestMessage.getTag(), this);
                ((NComm)this.getSbcIpDriverNetwork().getUdpConfig().comm()).sendMessage((NMessage)requestMessage);
            }
            catch (Exception e) {
                this.tagTextPointsMap.remove(requestMessage.getTag());
                this.getSbcIpDriverNetwork().removeTag(requestMessage.getTag());
                if (!SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) break block4;
                SbcUtil.sbcPointPoll.log(Level.FINER, " Something went wrong while reading TEXT SIZE of a control point\n", e);
            }
        }
    }

    public String sendRequestForTextByMemory(BControlPoint controlPoint, int count) throws Exception {
        BSbcProxyExt proxyExt = (BSbcProxyExt)controlPoint.getProxyExt();
        int noOfReq = count / 16;
        int charCountAtEnd = count % 16;
        if (charCountAtEnd != 0) {
            ++noOfReq;
        }
        int position = 0;
        int charToRead = 15;
        TypedOutputStream bytesOfText = new TypedOutputStream();
        for (int i = 0; i < noOfReq; ++i) {
            if (i == noOfReq - 1 && charCountAtEnd > 0) {
                charToRead = charCountAtEnd - 1;
                if (SbcUtil.sbcPointPoll.isLoggable(Level.FINEST)) {
                    SbcUtil.sbcPointPoll.log(Level.FINEST, String.format("No of bytes to be read from last request :: %d", charCountAtEnd));
                }
            }
            ReadText readTxt = new ReadText(Integer.parseInt(proxyExt.getMemoryAddress()), charToRead, position);
            int nextSeqNo = this.getSbcIpDriverNetwork().getSequenceNumber();
            SbcRequestMessage requestNextText = new SbcRequestMessage(this.getStationId(), nextSeqNo);
            requestNextText.setResponseTimeOut(this.getReadTimeout());
            requestNextText.setAddress((BAddress)this.getIpAddress());
            requestNextText.appendPayload(readTxt.getPayload());
            NComm comm = (NComm)this.getSbcIpDriverNetwork().getUdpConfig().comm();
            SbcResponseMessage responseNextText = (SbcResponseMessage)comm.sendRequest((NMessage)requestNextText);
            byte[] respMsg = responseNextText.getResponsePayload();
            if (respMsg.length >= 11) {
                bytesOfText.write(Arrays.copyOfRange(respMsg, 9, respMsg.length - 2));
            }
            position += 16;
        }
        return new String(bytesOfText.toByteArray(), "UTF-8").trim();
    }

    public void updatePointValue(BControlPoint bControlPoint, String displayText) {
        BSbcProxyExt proxyExt = (BSbcProxyExt)bControlPoint.getProxyExt();
        proxyExt.readOk((BStatusValue)new BStatusString(displayText, BStatus.ok));
    }

    public String sendRequestForTextByMemory(String memoryAddress) throws Exception {
        int count = this.getTextSizeOfPoint(memoryAddress);
        int noOfReq = count / 16;
        int charCountAtEnd = count % 16;
        if (charCountAtEnd != 0) {
            ++noOfReq;
        }
        int position = 0;
        int charToRead = 15;
        TypedOutputStream bytesOfText = new TypedOutputStream();
        for (int i = 0; i < noOfReq; ++i) {
            if (i == noOfReq - 1 && charCountAtEnd > 0) {
                charToRead = charCountAtEnd - 1;
                if (SbcUtil.sbcPointPoll.isLoggable(Level.FINEST)) {
                    SbcUtil.sbcPointPoll.log(Level.FINEST, String.format("No of bytes to be read from last request :: %d", charCountAtEnd));
                }
            }
            ReadText readTxt = new ReadText(Integer.parseInt(memoryAddress), charToRead, position);
            int nextSeqNo = this.getSbcIpDriverNetwork().getSequenceNumber();
            SbcRequestMessage requestNextText = new SbcRequestMessage(this.getStationId(), nextSeqNo);
            requestNextText.setResponseTimeOut(this.getReadTimeout());
            requestNextText.setAddress((BAddress)this.getIpAddress());
            requestNextText.appendPayload(readTxt.getPayload());
            NComm comm = (NComm)this.getSbcIpDriverNetwork().getUdpConfig().comm();
            SbcResponseMessage responseNextText = (SbcResponseMessage)comm.sendRequest((NMessage)requestNextText);
            byte[] respMsg = responseNextText.getResponsePayload();
            if (respMsg.length >= 11) {
                bytesOfText.write(Arrays.copyOfRange(respMsg, 9, respMsg.length - 2));
            }
            position += 16;
        }
        return new String(bytesOfText.toByteArray(), "UTF-8").trim();
    }

    public int getTextSizeOfPoint(String memoryAddress) {
        int nextSeqNo = this.getSbcIpDriverNetwork().getSequenceNumber();
        SbcRequestMessage requestMessage = new SbcRequestMessage(this.getStationId(), nextSeqNo);
        requestMessage.setResponseTimeOut(this.getReadTimeout());
        ReadDBSize readPoint = new ReadDBSize(Integer.parseInt(memoryAddress), 6);
        try {
            requestMessage.appendPayload(readPoint.getPayload());
            requestMessage.setAddress((BAddress)this.getIpAddress());
            if (SbcUtil.sbcPointPoll.isLoggable(Level.FINEST)) {
                SbcUtil.sbcPointPoll.log(Level.FINEST, "**** The ip address set in getTextSizeOfPoint :: " + this.getIpAddress());
            }
            NComm comm = (NComm)this.getSbcIpDriverNetwork().getUdpConfig().comm();
            SbcResponseMessage msg = (SbcResponseMessage)comm.sendRequest((NMessage)requestMessage);
            byte[] respMsg = msg.getResponsePayload();
            TypedOutputStream v = new TypedOutputStream();
            v.write(0);
            v.write(Arrays.copyOfRange(respMsg, 9, 12));
            ByteBuffer b = new ByteBuffer(v.toByteArray());
            return b.readInt();
        }
        catch (Exception e) {
            if (SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) {
                SbcUtil.sbcPointPoll.log(Level.FINER, " Something went wrong while reading TEXT SIZE of a control point\n", e);
            }
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void assignPointValue(BControlPoint bControlPoint, byte[] value, int clockSlotDisplayIndex) {
        BSbcProxyExt sbcDriverProxyExt = (BSbcProxyExt)bControlPoint.getProxyExt();
        int dataFormat = sbcDriverProxyExt.getDataFormat().getOrdinal();
        try {
            switch (this.getSbcMediaType(bControlPoint)) {
                case 2: 
                case 9: {
                    sbcDriverProxyExt.readOk((BStatusValue)new BStatusNumeric(SbcByteConverter.convertToAppropriateValue(dataFormat, value), BStatus.ok));
                    return;
                }
                case 3: {
                    sbcDriverProxyExt.readOk((BStatusValue)new BStatusNumeric(SbcByteConverter.convertToAppropriateValueForRegFloat(dataFormat, value), BStatus.ok));
                    return;
                }
                case 6: 
                case 7: {
                    sbcDriverProxyExt.readOk((BStatusValue)new BStatusNumeric(SbcByteConverter.convertToAppropriateValue(2, value), BStatus.ok));
                    return;
                }
                case 12: {
                    try {
                        bControlPoint.set(this.clock7daySlots[clockSlotDisplayIndex], (BValue)new BStatusNumeric(SbcByteConverter.convertToAppropriateValue(dataFormat, value), BStatus.ok));
                        return;
                    }
                    catch (Exception e) {
                        if (!SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) return;
                        SbcUtil.log_driver.log(Level.FINER, "Error while updating clock slots", e);
                    }
                    return;
                }
                default: {
                    Boolean readVal = value[0] != 0;
                    sbcDriverProxyExt.readOk((BStatusValue)new BStatusBoolean(readVal.booleanValue(), BStatus.ok));
                }
            }
            return;
        }
        catch (Exception e) {
            if (!SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) return;
            SbcUtil.log_driver.log(Level.FINER, "Error occurred while assigning value to the point", e);
        }
    }

    public void doReadAlarms() {
        if (!this.isDeviceStatusOk() && !this.isRunning()) {
            this.changeDataPollingStatus(false);
            SbcUtil.log_driver.log(Level.INFO, "Either device (" + this.getDisplayName(null) + ") is down/disabled for reading alarms & hd logs");
            return;
        }
        if (!this.isDataPolling()) {
            try {
                block10: {
                    this.changeDataPollingStatus(true);
                    try {
                        BSbcAlarms sbcAlarms = this.getAlarms();
                        BSbcAlarmList[] alarmLists = (BSbcAlarmList[])sbcAlarms.getChildren(BSbcAlarmList.class);
                        this.processAlarms(alarmLists);
                        this.processSubStationAlarms();
                    }
                    catch (Exception exp) {
                        if (!SbcUtil.sbcAlarmPoll.isLoggable(Level.FINER)) break block10;
                        SbcUtil.sbcAlarmPoll.log(Level.FINER, String.format("Unexpected error while polling alarms form : %s", this.getDisplayName(null)), exp);
                    }
                }
                try {
                    this.pollHdLogs();
                }
                catch (Exception exp) {
                    if (SbcUtil.log_driver.isLoggable(Level.FINER)) {
                        SbcUtil.log_driver.log(Level.FINER, String.format("Unexpected error while polling hd logs form : %s", this.getDisplayName(null)), exp);
                    }
                }
            }
            finally {
                this.changeDataPollingStatus(false);
            }
        }
    }

    private void pollHdLogs() {
        this.setCompletedAlarmPolls(this.getCompletedAlarmPolls() + 1);
        if (this.getCompletedAlarmPolls() >= this.getNumberOfAlarmPolls()) {
            try {
                SbcQueueManager.next(this.getHandleOrd().encodeToString());
            }
            catch (Exception exp) {
                if (SbcUtil.log_driver.isLoggable(Level.FINER)) {
                    SbcUtil.log_driver.log(Level.FINER, String.format("Unexpected error while polling hd logs form : %s", this.getDisplayName(null)), exp);
                }
            }
            finally {
                this.setCompletedAlarmPolls(0);
            }
        }
    }

    private void processSubStationAlarms() {
        String baseOrd = this.getAbsoluteOrd().toString();
        String bqlStr = baseOrd + "|bql:select * from sbc:SbcDevice";
        BITable devices = (BITable)BOrd.make((String)bqlStr).resolve((BObject)this).get();
        try (TableCursor deviceCursor = devices.cursor();){
            while (deviceCursor.next()) {
                BSbcDevice device = (BSbcDevice)((Object)deviceCursor.get());
                if (device == null) continue;
                BSbcAlarmList[] alarmLists = (BSbcAlarmList[])device.getAlarms().getChildren(BSbcAlarmList.class);
                this.processAlarms(alarmLists);
            }
        }
    }

    private void processAlarms(BSbcAlarmList[] alarmLists) {
        for (BSbcAlarmList alarmList : alarmLists) {
            alarmList.invoke(BSbcAlarmList.execute, null);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ie) {
                SbcUtil.log_driver.log(Level.SEVERE, "Interrupted!", ie);
            }
            boolean flag = alarmList.getPollStatus();
            while (flag) {
                flag = alarmList.getPollStatus();
            }
        }
    }

    public BIcon getIcon() {
        BValue dynamic = this.get("icon");
        return dynamic instanceof BIcon ? (BIcon)dynamic : icon;
    }

    public void doPoll() {
        if (!this.isRunning() || !Sys.atSteadyState()) {
            return;
        }
        boolean flag = this.isDeviceStatusOk();
        if (flag) {
            this.invoke(readMultiPoints, null);
        }
    }

    public void atSteadyState() throws Exception {
        atSteady = true;
    }

    public void receiveResponse(SbcResponseMessage responseMessage) {
        if (SbcUtil.sbcPointPoll.isLoggable(Level.FINEST)) {
            SbcUtil.sbcPointPoll.log(Level.FINEST, this.getDisplayName(null).concat("===Received response to poll points data with tag===").concat(responseMessage.getTag().toString()));
        }
        if (this.tagClockPointsMap.containsKey(responseMessage.getTag())) {
            this.processClockPointResponse(responseMessage);
        } else if (this.tagTextPointsMap.containsKey(responseMessage.getTag())) {
            this.processTextPointResponse(responseMessage);
        } else if (this.tagPointsMap.containsKey(responseMessage.getTag())) {
            this.processOtherPointsResponse(responseMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTextPointResponse(SbcResponseMessage responseMessage) {
        try {
            BControlPoint controlPoint = this.tagTextPointsMap.get(responseMessage.getTag());
            byte[] respMsg = responseMessage.getResponsePayload();
            TypedOutputStream outputStream = new TypedOutputStream();
            outputStream.write(0);
            outputStream.write(Arrays.copyOfRange(respMsg, 9, 12));
            ByteBuffer b = new ByteBuffer(outputStream.toByteArray());
            String data = this.sendRequestForTextByMemory(controlPoint, b.readInt());
            this.updatePointValue(controlPoint, data);
        }
        catch (Exception exp) {
            if (SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) {
                SbcUtil.sbcPointPoll.log(Level.FINER, "Unexpected error while reading text point data. ", exp);
            }
        }
        finally {
            this.tagTextPointsMap.remove(responseMessage.getTag());
            this.tagTimestampMap.remove(responseMessage.getTag());
            if (!this.textPoints.isEmpty()) {
                this.pollTextPointData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClockPointResponse(SbcResponseMessage responseMessage) {
        try {
            byte[] trimmedRespMsg = responseMessage.getResponsePayload();
            byte[] ackNak = Arrays.copyOfRange(trimmedRespMsg, 8, 9);
            List<BControlPoint> pointList = this.tagClockPointsMap.get(responseMessage.getTag());
            this.logPoints(responseMessage.getTag(), pointList, "RESPONSE");
            if (ackNak.length > 0 && ackNak[0] == 1) {
                byte[] responseArray = Arrays.copyOfRange(trimmedRespMsg, 10, trimmedRespMsg.length - 2);
                int wCount = -1;
                int i = 0;
                int y = 0;
                while (i < responseArray.length) {
                    if (y < pointList.size()) {
                        BControlPoint bControlPoint = pointList.get(y);
                        wCount = this.processPointResponse(bControlPoint, responseArray, i, wCount, y);
                    }
                    i = i + wCount + 1;
                    ++y;
                }
                try {
                    ((BSbcProxyExt)pointList.get(0).getProxyExt()).readOk((BStatusValue)new BStatusString(this.buildClockReadValue(pointList), BStatus.ok));
                }
                catch (Exception exp) {
                    if (SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) {
                        SbcUtil.sbcPointPoll.log(Level.FINER, "Error while creating out value of the SBC Clock.", exp);
                    }
                }
            } else if (SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) {
                SbcUtil.sbcPointPoll.log(Level.FINER, "NAK Received from PCD for the read clock request");
            }
        }
        catch (Exception e) {
            if (SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) {
                SbcUtil.sbcPointPoll.log(Level.FINER, "Unexpected error occurred while processing clock points response", e);
            }
        }
        finally {
            this.tagClockPointsMap.remove(responseMessage.getTag());
            this.tagTimestampMap.remove(responseMessage.getTag());
            this.processNextSet();
        }
    }

    private String buildClockReadValue(List<BControlPoint> pointList) {
        StringBuilder outValue = new StringBuilder("");
        try {
            for (int i = 0; i < this.clock7daySlots.length / 2; ++i) {
                if (outValue.toString().equals("")) {
                    outValue.append("" + pointList.get(0).get(this.clock7daySlots[i]) + "," + pointList.get(0).get(this.clock7daySlots[i + 7]));
                    continue;
                }
                outValue.append("," + pointList.get(0).get(this.clock7daySlots[i]) + "," + pointList.get(0).get(this.clock7daySlots[i + 7]));
            }
        }
        catch (Exception exp) {
            if (SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) {
                SbcUtil.sbcPointPoll.log(Level.FINER, "Error while creating out value of the SBC Clock.", exp);
            }
            return "Error while Building Read Value of the clock";
        }
        return outValue.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOtherPointsResponse(SbcResponseMessage responseMessage) {
        try {
            byte[] trimmedRespMsg = responseMessage.getResponsePayload();
            byte[] ackNak = Arrays.copyOfRange(trimmedRespMsg, 8, 9);
            List<BControlPoint> pointList = this.tagPointsMap.get(responseMessage.getTag());
            this.logPoints(responseMessage.getTag(), pointList, "RESPONSE");
            if (ackNak.length > 0 && ackNak[0] == 1) {
                byte[] responseArray = Arrays.copyOfRange(trimmedRespMsg, 10, trimmedRespMsg.length - 2);
                int wCount = -1;
                int i = 0;
                int y = 0;
                while (i < responseArray.length) {
                    if (y < pointList.size()) {
                        BControlPoint bControlPoint = pointList.get(y);
                        wCount = this.processPointResponse(bControlPoint, responseArray, i, wCount, -1);
                    }
                    i = i + wCount + 1;
                    ++y;
                }
            } else if (SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) {
                SbcUtil.sbcPointPoll.log(Level.FINER, "NAK Received from PCD for the read request");
            }
        }
        catch (Exception e) {
            if (SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) {
                SbcUtil.sbcPointPoll.log(Level.FINER, "Unexpected error occurred while processing other points response", e);
            }
        }
        finally {
            this.tagPointsMap.remove(responseMessage.getTag());
            this.tagTimestampMap.remove(responseMessage.getTag());
            this.processNextSet();
        }
    }

    private void processNextSet() {
        if (!this.otherPoints.isEmpty()) {
            if (this.tagPointsMap.isEmpty()) {
                this.pollOtherPointsData();
            }
        } else if (!this.textPoints.isEmpty()) {
            this.pollTextPointData();
        }
    }

    private int processPointResponse(BControlPoint controlPoint, byte[] responseArray, int index, int inputCount, int clockSlotDisplayIndex) {
        int wCount;
        block7: {
            if (controlPoint == null) {
                return inputCount;
            }
            wCount = inputCount;
            try {
                wCount = responseArray[index];
                if (wCount > 0) {
                    byte[] value = Arrays.copyOfRange(responseArray, index + 2, index + wCount + 1);
                    if (value.length > 0) {
                        this.assignPointValue(controlPoint, value, clockSlotDisplayIndex);
                    }
                } else if (SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) {
                    SbcUtil.sbcPointPoll.log(Level.FINER, "Incorrect response received for Control point - " + controlPoint.getName() + ".Value couldn't be assigned for the point.");
                }
            }
            catch (Exception e) {
                if (!SbcUtil.sbcPointPoll.isLoggable(Level.FINER)) break block7;
                SbcUtil.sbcPointPoll.log(Level.FINER, "Error occurred while parsing response for the point-" + controlPoint.getName() + "\n" + e.getMessage(), e);
            }
        }
        return wCount;
    }

    private void logPoints(Object tag, List<BControlPoint> list, String type) {
        if (SbcUtil.sbcPointDump.isLoggable(Level.FINER)) {
            StringBuilder builder = new StringBuilder();
            builder.append(type).append("\t\t");
            builder.append("TAG:\t\t").append(tag.toString());
            for (BControlPoint point : list) {
                builder.append(point.getSlotPath().toString());
                builder.append("\n");
            }
            builder.append(type).append("\t\t");
            builder.append("END TAG:\t\t").append(tag.toString());
            SbcUtil.sbcPointDump.log(Level.FINER, builder.toString());
        }
    }

    public boolean isDeviceStatusOk() {
        return this.getStatus().isOk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeDataPollingStatus(boolean flag) {
        Object object = this.lock;
        synchronized (object) {
            this.setDataPollingStatus(flag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataPolling() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDataPollingStatus();
        }
    }

    public final BSbcNetwork getSbcIpDriverNetwork() {
        return (BSbcNetwork)this.getNetwork();
    }

    public void addPointToSubscriptionList(BControlPoint point) {
        this.pointSubscriptionList.add(point);
    }

    public void removePointFromSubscriptionList(BControlPoint point) {
        this.pointSubscriptionList.remove(point);
    }
}

