/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.ui.hx;

import com.honeywell.sbc.alarms.BSbcAlarmDeviceExt;
import com.tridium.alarm.hx.BHxAlarmConsole;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

@NiagaraType(agent={@AgentOn(types={"sbc:SbcAlarmConsole"}, requiredPermissions="r")})
public class BSbcHxAlarmConsole
extends BHxAlarmConsole {
    public static final BSbcHxAlarmConsole INSTANCE = new BSbcHxAlarmConsole();
    public static final Type TYPE = Sys.loadType(BSbcHxAlarmConsole.class);
    private static Logger alarmLogger = Logger.getLogger("BSbcHxAlarmConsole");

    public Type getType() {
        return TYPE;
    }

    public void forceClearBySource(String src, HxOp op) throws Exception {
        BOrd ord = BOrd.make((String)("alarm:|bql:select * from openAlarms where source = OrdList '" + src + "'"));
        BITable result = (BITable)ord.resolve(op.get()).get();
        ArrayList<BAlarmRecord> records = new ArrayList<BAlarmRecord>();
        TableCursor tableCursor = result.cursor();
        while (tableCursor.next()) {
            try {
                records.add((BAlarmRecord)((BAlarmRecord)tableCursor.get()).newCopy());
            }
            catch (Exception e) {
                alarmLogger.log(Level.SEVERE, "Unexpected error while finding alarm records to force clear.", e);
            }
        }
        AlarmDbConnection conn = this.getAlarmService().getAlarmDb().getDbConnection((Context)null);
        for (BAlarmRecord record : records) {
            BSourceState alarmState = record.getSourceState();
            Boolean isSbcAlarm = false;
            BOrdList list = record.getSource();
            BObject obj = list.get(0).resolve((BObject)this.getAlarmService()).get();
            if (obj instanceof BSbcAlarmDeviceExt) {
                isSbcAlarm = true;
            }
            if (isSbcAlarm.booleanValue() && BSourceState.normal.equals((Object)alarmState)) {
                BSbcAlarmDeviceExt systemAlarm = (BSbcAlarmDeviceExt)obj;
                BBoolean isAlarmClearedInPcd = (BBoolean)systemAlarm.invoke(BSbcAlarmDeviceExt.forceClear, (BValue)record);
                if (!isAlarmClearedInPcd.getBoolean()) continue;
                this.forceClearAlarm(record, conn, op);
                continue;
            }
            if (isSbcAlarm.booleanValue()) continue;
            this.forceClearAlarm(record, conn, op);
        }
    }

    private void forceClearAlarm(BAlarmRecord record, AlarmDbConnection conn, HxOp op) {
        BAlarmClass alarmClass = this.getAlarmService().lookupAlarmClass(record.getAlarmClass());
        if (alarmClass == null) {
            alarmClass = this.getAlarmService().getDefaultAlarmClass();
        }
        op.getUser().check((BIProtected)alarmClass, BPermissions.adminWrite);
        record.setSourceState(BSourceState.normal);
        record.setAckState(BAckState.acked);
        record.addAlarmFacet("forceCleared", (BIDataValue)BString.make((String)op.getUser().getUsername()));
        if (record.getAckTime().equals((Object)BAbsTime.NULL)) {
            record.setAckTime(BAbsTime.now());
        }
        if (record.getNormalTime().equals((Object)BAbsTime.NULL)) {
            record.setNormalTime(BAbsTime.now());
        }
        try {
            conn.update(record);
        }
        catch (IOException | AlarmException e) {
            alarmLogger.log(Level.SEVERE, "Unable to force clear alarm: " + record.getUuid().toString(), e);
        }
        this.logAuditRecord(op.getUser(), record);
    }

    private void logAuditRecord(BUser user, BAlarmRecord record) {
        Auditor auditor = Sys.getAuditor();
        if (auditor != null) {
            String username = "";
            if (user != null) {
                username = user.getUsername();
            }
            auditor.audit(new AuditEvent("Force Clear Alarm", record.getSource().toString(), record.getUuid().toString(), "", "", username));
        }
    }
}

