/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.sbc.fe;

import com.honeywell.sbc.bean.BSbcDbBean;
import com.honeywell.sbc.point.BSbcDb;
import com.honeywell.sbc.point.BSbcDbRam;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import util.SbcWbUtils;

@NiagaraType
@NiagaraAction(name="onForceRead")
public class BSbcDbFE
extends BWbFieldEditor {
    public static final Action onForceRead = BSbcDbFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSbcDbFE.class);
    private BLabel exampleLabel;
    private BLabel memoryAddressLabel;
    private BLabel blockSizeLabel;
    private BLabel elementListLabel;
    private BTextField elementsList;
    private BButton forceRead;
    private BComponent point;
    private boolean isValidForLoad = false;
    private BTextField blockSize;
    private BTextField memoryAddress;
    private BSbcDbBean userSelection;
    private Lexicon lexicon = this.getLexicon();
    private boolean memAddressErrFlg = false;
    private boolean blockSizeErrFlg = false;
    private boolean elementListErrFlg = false;

    public BSbcDbFE() {
        this.memoryAddressLabel = new BLabel(this.lexicon.get("sbcdb.label.memoryaddress"));
        this.memoryAddress = new BTextField("");
        this.blockSizeLabel = new BLabel(this.lexicon.get("sbcdb.label.blocksize"));
        this.blockSize = new BTextField("");
        this.elementListLabel = new BLabel(this.lexicon.get("sbcdb.label.elementlist"));
        this.elementsList = new BTextField("");
        this.exampleLabel = new BLabel(this.lexicon.get("sbcdb.label.example"));
        this.forceRead = new BButton(this.lexicon.get("sbcdb.button.forceRead"));
        BGridPane b = new BGridPane(1);
        BGridPane b1 = new BGridPane(2);
        b1.add(null, (BValue)this.memoryAddressLabel);
        b1.add(null, (BValue)this.memoryAddress);
        BGridPane b2 = new BGridPane(4);
        b2.add(null, (BValue)this.blockSizeLabel);
        this.blockSizeLabel.setPadding(BInsets.make((double)0.0, (double)35.0, (double)0.0, (double)0.0));
        b2.add(null, (BValue)this.blockSize);
        BGridPane b3 = new BGridPane(4);
        b3.add(null, (BValue)this.elementListLabel);
        this.elementListLabel.setPadding(BInsets.make((double)0.0, (double)18.0, (double)0.0, (double)0.0));
        b3.add(null, (BValue)this.elementsList);
        b3.add(null, (BValue)this.exampleLabel);
        b3.add(null, (BValue)this.forceRead);
        b.add(null, (BValue)b1);
        b.add(null, (BValue)b2);
        b.add(null, (BValue)b3);
        this.setContent((BWidget)b);
        this.linkTo("lk1", (BComponent)this.memoryAddress, (Slot)BTextField.keyEvent, (Slot)setModified);
        this.linkTo("lk2", (BComponent)this.blockSize, (Slot)BTextField.keyEvent, (Slot)setModified);
        this.linkTo("lk3", (BComponent)this.elementsList, (Slot)BTextField.keyEvent, (Slot)setModified);
        this.linkTo("lk4", (BComponent)this.forceRead, (Slot)BButton.actionPerformed, (Slot)onForceRead);
    }

    public void onForceRead() {
        this.invoke(onForceRead, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doOnForceRead() {
        if (this.point.getType().equals(BSbcDb.TYPE)) {
            this.point.invoke(BSbcDb.fetchValues, null);
        }
    }

    public void updateDBElements() {
        if (this.point.getType().equals(BSbcDb.TYPE)) {
            this.point.invoke(BSbcDb.forceRead, null);
        } else if (this.point.getType().equals(BSbcDbRam.TYPE)) {
            this.point.invoke(BSbcDbRam.forceRead, null);
        }
    }

    private void setUserSelection() {
        if (this.isValidForLoad) {
            this.isValidForLoad = false;
            this.userSelection.setMemoryAddress(this.memoryAddress.getText());
            this.userSelection.setDbElemSize(this.blockSize.getText());
            this.userSelection.setUserSelectedVal(this.elementsList.getText());
            this.updateDBElements();
            this.memoryAddress.setText(this.userSelection.getMemoryAddress());
            this.blockSize.setText(this.userSelection.getDbElemSize());
            this.elementsList.setText(this.userSelection.getUserSelectedVal());
        } else {
            if (!"".equals(this.userSelection.getMemoryAddress())) {
                this.memoryAddress.setText(this.userSelection.getMemoryAddress());
            }
            if (!"".equals(this.userSelection.getDbElemSize())) {
                this.blockSize.setText(this.userSelection.getDbElemSize());
            }
            if (!"".equals(this.userSelection.getUserSelectedVal())) {
                this.elementsList.setText(this.userSelection.getUserSelectedVal());
            }
        }
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        if (this.point == null) {
            this.point = (BComponent)((BSbcDbBean)value).getParent();
            if (this.point instanceof BSbcDbRam && this.getContent().getChildWidgets().length > 1) {
                BGridPane gridPane = (BGridPane)this.getContent().getChildWidgets()[2];
                gridPane.remove((BComplex)this.forceRead);
            }
            this.point.lease();
        }
        this.userSelection = (BSbcDbBean)value;
        this.setUserSelection();
        if (this.memAddressErrFlg) {
            this.memoryAddress.setText("");
            this.userSelection.setMemoryAddress("");
            this.memAddressErrFlg = false;
        }
        if (this.blockSizeErrFlg) {
            this.blockSize.setText("");
            this.blockSizeErrFlg = false;
        }
        if (this.elementListErrFlg) {
            this.elementsList.setText("");
            this.elementListErrFlg = false;
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        this.userSelection = (BSbcDbBean)value;
        this.userSelection.setMemoryAddress(this.memoryAddress.getText());
        this.userSelection.setDbElemSize(this.blockSize.getText());
        this.userSelection.setUserSelectedVal(this.elementsList.getText());
        if ("".equals(this.memoryAddress.getText())) {
            BDialog.info((BWidget)this.getShell(), (Object)this.lexicon.get("sbcdb.msg.memoryAddress.blank"));
            this.isValidForLoad = false;
        } else if (!SbcWbUtils.isNumbersOnly(this.memoryAddress.getText())) {
            BDialog.info((BWidget)this.getShell(), (Object)this.lexicon.get("sbcdb.msg.memoryAddress.invalid.format"));
            this.isValidForLoad = false;
            this.memoryAddress.setText("");
            this.userSelection.setMemoryAddress("");
            this.memAddressErrFlg = true;
        } else if ("".equals(this.blockSize.getText())) {
            BDialog.info((BWidget)this.getShell(), (Object)this.lexicon.get("sbcdb.msg.blocksize.empty"));
            this.isValidForLoad = false;
        } else if (!SbcWbUtils.isNumbersOnly(this.blockSize.getText())) {
            BDialog.info((BWidget)this.getShell(), (Object)this.lexicon.get("sbcdb.msg.blocksize.invalid.format"));
            this.isValidForLoad = false;
            this.blockSize.setText("");
            this.userSelection.setDbElemSize("");
            this.blockSizeErrFlg = true;
        } else if ("".equals(this.elementsList.getText())) {
            BDialog.info((BWidget)this.getShell(), (Object)this.lexicon.get("sbcdb.msg.blankVal"));
            this.isValidForLoad = false;
        } else if (!this.isValidElementsList()) {
            BDialog.info((BWidget)this.getShell(), (Object)this.lexicon.get("sbcdb.msg.invalid.format"));
            this.isValidForLoad = false;
            this.elementsList.setText("");
            this.userSelection.setUserSelectedVal("");
            this.elementListErrFlg = true;
        } else {
            int blockSizeVal = Integer.parseInt(this.blockSize.getText());
            if (!this.isCountInRange(this.elementsList.getText(), blockSizeVal - 1)) {
                BDialog.info((BWidget)this.getShell(), (Object)this.lexicon.get("sbcdb.msg.blockSize"));
                this.isValidForLoad = false;
            } else {
                this.isValidForLoad = true;
            }
        }
        return this.userSelection;
    }

    public boolean isValidElementsList() {
        boolean isUserInputValid = false;
        if (SbcWbUtils.isUserInputValid(this.elementsList.getText())) {
            isUserInputValid = true;
        }
        return isUserInputValid;
    }

    public boolean isCountInRange(String countVal, int maxIndex) {
        String[] dbElem;
        for (String dbElemIndex : dbElem = countVal.split(",")) {
            if (dbElemIndex.contains("-")) {
                String[] arr = dbElemIndex.split("-");
                for (int i = Integer.parseInt(arr[0]); i <= Integer.parseInt(arr[1]); ++i) {
                    if (i <= maxIndex) continue;
                    return false;
                }
                continue;
            }
            if (Integer.parseInt(dbElemIndex) <= maxIndex) continue;
            return false;
        }
        return true;
    }
}

